/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.util;

import com.raoulvdberge.refinedstorage.api.util.IComparer;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class Comparer
implements IComparer {
    private Map<Integer, Boolean> oredictCache = new HashMap<Integer, Boolean>();

    @Override
    public boolean isEqual(ItemStack left, ItemStack right, int flags) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if ((flags & 8) == 8 && this.isEqualOredict(left, right)) {
            return true;
        }
        if (left.func_77973_b() != right.func_77973_b()) {
            return false;
        }
        if ((flags & 1) == 1 && left.func_77952_i() != Short.MAX_VALUE && right.func_77952_i() != Short.MAX_VALUE && left.func_77952_i() != right.func_77952_i()) {
            return false;
        }
        if ((flags & 2) == 2) {
            if ((flags & 0x10) == 16) {
                left = Comparer.stripTags(left.func_77946_l());
                right = Comparer.stripTags(right.func_77946_l());
            }
            if (!this.isEqualNBT(left, right)) {
                return false;
            }
        }
        return (flags & 4) != 4 || left.field_77994_a == right.field_77994_a;
    }

    @Override
    public boolean isEqual(FluidStack left, FluidStack right, int flags) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        if (left.getFluid() != right.getFluid()) {
            return false;
        }
        if ((flags & 4) == 4 && left.amount != right.amount) {
            return false;
        }
        return (flags & 2) != 2 || left.tag == null || left.tag.equals((Object)right.tag);
    }

    @Override
    public boolean isEqualNBT(ItemStack left, ItemStack right) {
        if (!ItemStack.func_77970_a((ItemStack)left, (ItemStack)right)) {
            if (left.func_77942_o() && !right.func_77942_o() && left.func_77978_p().func_82582_d()) {
                return true;
            }
            return !left.func_77942_o() && right.func_77942_o() && right.func_77978_p().func_82582_d();
        }
        return true;
    }

    @Override
    public boolean isEqualOredict(ItemStack left, ItemStack right) {
        int[] rightIds;
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right != null || left != null && right == null) {
            return false;
        }
        int code = API.instance().getItemStackHashCode(left, false);
        if (this.oredictCache.containsKey(code = 31 * code + API.instance().getItemStackHashCode(right, false))) {
            return this.oredictCache.get(code);
        }
        int[] leftIds = OreDictionary.getOreIDs((ItemStack)left);
        for (int i : rightIds = OreDictionary.getOreIDs((ItemStack)right)) {
            if (!ArrayUtils.contains((int[])leftIds, (int)i)) continue;
            this.oredictCache.put(code, true);
            return true;
        }
        this.oredictCache.put(code, false);
        return false;
    }

    public static ItemStack stripTags(ItemStack stack) {
        if (stack != null && stack.func_77942_o()) {
            switch (stack.func_77973_b().getRegistryName().func_110624_b()) {
                case "mekanism": 
                case "mekanismgenerators": 
                case "mekanismtools": {
                    stack.func_77978_p().func_82580_o("mekData");
                    break;
                }
                case "enderio": {
                    stack.func_77978_p().func_82580_o("entity");
                    stack.func_77978_p().func_82580_o("isStub");
                    stack.func_77978_p().func_82580_o("Energy");
                    stack.func_77978_p().func_82580_o("paintSource__null");
                    stack.func_77978_p().func_82580_o("paintSource");
                    stack.func_77978_p().func_82580_o("faceModes__null");
                    stack.func_77978_p().func_82580_o("faceModes");
                    stack.func_77978_p().func_82580_o("tank");
                    stack.func_77978_p().func_82580_o("voidMode");
                    stack.func_77978_p().func_82580_o("inventory");
                    stack.func_77978_p().func_82580_o("display");
                    stack.func_77978_p().func_82580_o("eio.abstractMachine");
                    break;
                }
                case "simplyjetpacks": {
                    stack.func_77978_p().func_82580_o("sjData");
                    stack.func_77978_p().func_82580_o("PackOn");
                    break;
                }
                case "storagedrawers": {
                    stack.func_77978_p().func_82580_o("material");
                    break;
                }
                case "immersiveengineering": {
                    stack.func_77978_p().func_82580_o("hammerDmg");
                    stack.func_77978_p().func_82580_o("cutterDmg");
                    break;
                }
                case "fluxnetworks": {
                    stack.func_77978_p().func_82580_o("dropped");
                    stack.func_77978_p().func_82580_o("energy");
                    break;
                }
                case "draconicevolution": {
                    stack.func_77978_p().func_82580_o("Energy");
                    stack.func_77978_p().func_82580_o("DEUpgrades");
                    Set profiles = stack.func_77978_p().func_150296_c().stream().filter(key -> key.startsWith("Profile")).collect(Collectors.toSet());
                    for (String profile : profiles) {
                        stack.func_77978_p().func_82580_o(profile);
                    }
                    break;
                }
                case "minecraft": {
                    stack.func_77978_p().func_82580_o("RepairCost");
                }
            }
        }
        return stack;
    }
}

