/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.modintegration.theoneprobe;

import com.google.common.base.Function;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementFactory;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.apiimpl.client.ElementTextRender;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class OneProbeDataProvider
implements IProbeInfoProvider {
    private static final OneProbeDataProvider INSTANCE = new OneProbeDataProvider();
    private int factoryId;

    public String getID() {
        return "shetiphian.endertanks";
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity tile;
        if (blockState.func_177230_c() instanceof BlockEnderTank && (tile = world.func_175625_s(data.getPos())) instanceof TileEntityEnderTank) {
            TileEntityEnderTank tankTile = (TileEntityEnderTank)tile;
            FluidTankInfo tank = tankTile.getTankInfo();
            probeInfo.element((IElement)new ElementTankInfo(tankTile, tank.fluid, tank.capacity));
        }
    }

    private static class ElementTankInfo
    implements IElement {
        TileEntityEnderTank tankTile;
        FluidStack fluid;
        int capacity;
        List<String> lines = new ArrayList<String>();

        private ElementTankInfo(TileEntityEnderTank tankTile, FluidStack fluid, int capacity) {
            this.tankTile = tankTile;
            this.fluid = fluid;
            this.capacity = capacity;
            TankInfoHelper.wailaGetTankInfo(this.lines, tankTile, fluid, capacity);
        }

        public void render(int x, int y) {
            for (String line : this.lines) {
                ElementTextRender.render((String)line, (int)x, (int)y);
                y += 10;
            }
        }

        public int getWidth() {
            int width = 0;
            for (String line : this.lines) {
                width = Math.max(width, ElementTextRender.getWidth((String)line));
            }
            return width;
        }

        public int getHeight() {
            return 10 + (this.lines.size() - 1) * 10;
        }

        public void toBytes(ByteBuf buf) {
            PacketBuffer buffer = new PacketBuffer(buf);
            buffer.func_179255_a(this.tankTile.func_174877_v());
            buffer.writeInt(this.capacity);
            if (this.fluid != null) {
                NBTTagCompound fluidTag = new NBTTagCompound();
                this.fluid.writeToNBT(fluidTag);
                buffer.func_150786_a(fluidTag);
            }
        }

        public int getID() {
            return INSTANCE.factoryId;
        }
    }

    private static class ElementFactoryTankInfo
    implements IElementFactory {
        private ElementFactoryTankInfo() {
        }

        public IElement createElement(ByteBuf buf) {
            PacketBuffer buffer = new PacketBuffer(buf);
            BlockPos pos = buffer.func_179259_c();
            TileEntityEnderTank tankTile = null;
            try {
                tankTile = (TileEntityEnderTank)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(pos);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int capacity = buffer.readInt();
            FluidStack fluid = null;
            try {
                NBTTagCompound fluidTag = buffer.func_150793_b();
                fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return new ElementTankInfo(tankTile, fluid, capacity);
        }
    }

    public static class GetTheOneProbe
    implements Function<ITheOneProbe, Void> {
        @Nullable
        public Void apply(@Nullable ITheOneProbe input) {
            if (input != null) {
                input.registerProvider((IProbeInfoProvider)INSTANCE);
                INSTANCE.factoryId = input.registerElementFactory((IElementFactory)new ElementFactoryTankInfo());
            }
            return null;
        }
    }
}

