/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.GuiContainerBase;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;

public class GhostSlotHandler {
    protected List<GhostSlot> ghostSlots = Lists.newArrayList();
    protected GhostSlot hoverGhostSlot;

    protected List<GhostSlot> getGhostSlots() {
        return this.ghostSlots;
    }

    protected GhostSlot getGhostSlot(GuiContainerBase guiContainerBase, int mouseX, int mouseY) {
        mouseX -= guiContainerBase.getGuiLeft();
        mouseY -= guiContainerBase.getGuiTop();
        for (GhostSlot slot : this.ghostSlots) {
            if (!slot.isVisible() || !slot.isMouseOver(mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    protected void ghostSlotClicked(GuiContainerBase gui, GhostSlot slot, int x, int y, int button) {
        ItemStack handStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        ItemStack existingStack = slot.getStack();
        if (button == 0) {
            this.ghostSlotClickedPrimaryMouseButton(slot, handStack, existingStack);
        } else if (button == 1) {
            this.ghostSlotClickedSecondaryMouseButton(slot, handStack, existingStack);
        } else if (button == -2) {
            this.ghostSlotClickedMouseWheelUp(slot, handStack, existingStack);
        } else if (button == -1) {
            this.ghostSlotClickedMouseWheelDown(slot, handStack, existingStack);
        }
    }

    protected void ghostSlotClickedPrimaryMouseButton(GhostSlot slot, ItemStack handStack, ItemStack existingStack) {
        if (handStack == null || handStack.func_77973_b() == null || handStack.field_77994_a == 0) {
            slot.putStack(null);
        } else if (existingStack == null || existingStack.func_77973_b() == null || existingStack.field_77994_a == 0) {
            this.replaceSlot(slot, handStack);
        } else if (ItemUtil.areStackMergable(existingStack, handStack)) {
            if (existingStack.field_77994_a < existingStack.func_77976_d() && existingStack.field_77994_a < slot.getStackSizeLimit()) {
                this.increaseSlot(slot, existingStack);
            }
        } else {
            this.replaceSlot(slot, handStack);
        }
    }

    protected void ghostSlotClickedSecondaryMouseButton(GhostSlot slot, ItemStack handStack, ItemStack existingStack) {
        if (handStack == null || handStack.func_77973_b() == null || handStack.field_77994_a == 0) {
            slot.putStack(null);
        } else if (existingStack == null || existingStack.func_77973_b() == null || existingStack.field_77994_a == 0) {
            this.replaceSlot1Item(slot, handStack);
        } else if (ItemUtil.areStackMergable(existingStack, handStack)) {
            this.descreaseSlot(slot, existingStack);
        } else {
            this.replaceSlot1Item(slot, handStack);
        }
    }

    protected void ghostSlotClickedMouseWheelUp(GhostSlot slot, ItemStack handStack, ItemStack existingStack) {
        if (existingStack != null && existingStack.func_77973_b() != null && existingStack.field_77994_a > 0 && existingStack.field_77994_a < existingStack.func_77976_d() && existingStack.field_77994_a < slot.getStackSizeLimit()) {
            this.increaseSlot(slot, existingStack);
        }
    }

    protected void ghostSlotClickedMouseWheelDown(GhostSlot slot, ItemStack handStack, ItemStack existingStack) {
        if (existingStack != null && existingStack.func_77973_b() != null) {
            this.descreaseSlot(slot, existingStack);
        }
    }

    protected void descreaseSlot(GhostSlot slot, ItemStack existingStack) {
        if (existingStack.field_77994_a > 1) {
            --existingStack.field_77994_a;
            slot.putStack(existingStack);
        } else {
            slot.putStack(null);
        }
    }

    protected void increaseSlot(GhostSlot slot, ItemStack existingStack) {
        ++existingStack.field_77994_a;
        slot.putStack(existingStack);
    }

    protected void replaceSlot1Item(GhostSlot slot, ItemStack handStack) {
        ItemStack oneItem = handStack.func_77946_l();
        oneItem.field_77994_a = 1;
        slot.putStack(oneItem);
    }

    protected void replaceSlot(GhostSlot slot, ItemStack handStack) {
        if (handStack.field_77994_a <= slot.getStackSizeLimit()) {
            slot.putStack(handStack);
        } else {
            ItemStack tmp = handStack.func_77946_l();
            tmp.field_77994_a = slot.getStackSizeLimit();
            slot.putStack(tmp);
        }
    }

    protected void startDrawing(GuiContainerBase gui) {
        this.hoverGhostSlot = null;
        gui.hoverGhostSlot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawGhostSlots(GuiContainerBase gui, int mouseX, int mouseY) {
        int sx = gui.getGuiLeft();
        int sy = gui.getGuiTop();
        gui.drawFakeItemsStart();
        try {
            this.hoverGhostSlot = null;
            gui.hoverGhostSlot = null;
            for (GhostSlot slot : this.ghostSlots) {
                ItemStack stack = slot.getStack();
                if (!slot.isVisible()) continue;
                if (stack != null) {
                    gui.drawFakeItemStack(slot.x + sx, slot.y + sy, stack);
                    if (slot.shouldDisplayStdOverlay()) {
                        gui.drawFakeItemStackStdOverlay(slot.x + sx, slot.y + sy, stack);
                    }
                    if (slot.shouldGrayOut()) {
                        gui.ghostSlotHandler.drawGhostSlotGrayout(gui, slot);
                    }
                }
                if (!slot.isMouseOver(mouseX - sx, mouseY - sy)) continue;
                gui.hoverGhostSlot = this.hoverGhostSlot = slot;
            }
            if (this.hoverGhostSlot != null) {
                gui.drawFakeItemHover(this.hoverGhostSlot.x + sx, this.hoverGhostSlot.y + sy);
            }
        }
        finally {
            gui.drawFakeItemsEnd();
        }
    }

    protected void drawGhostSlotGrayout(GuiContainerBase gui, GhostSlot slot) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)slot.getGrayOutLevel());
        String guiTexture = gui.getGuiTexture();
        if (guiTexture == null) {
            EnderWidget.NEUTRAL_SLOT_BACKGROUND.getMap().render((IWidgetIcon)EnderWidget.NEUTRAL_SLOT_BACKGROUND, (double)(gui.getGuiLeft() + slot.x), (double)(gui.getGuiTop() + slot.y), gui.getZlevel(), true);
        } else {
            RenderUtil.bindTexture(guiTexture);
            gui.func_73729_b(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, slot.x, slot.y, 16, 16);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
    }

    protected void drawGhostSlotTooltip(GuiContainerBase guiContainerBase, GhostSlot slot, int mouseX, int mouseY) {
        ItemStack stack = slot.getStack();
        if (stack != null) {
            guiContainerBase.func_146285_a(stack, mouseX, mouseY);
        }
    }

    protected void drawGhostSlotToolTip(GuiContainerBase gui, int mouseX, int mouseY) {
        if (this.hoverGhostSlot != null && gui.field_146297_k.field_71439_g.field_71071_by.func_70445_o() == null) {
            gui.drawGhostSlotTooltip(this.hoverGhostSlot, mouseX, mouseY);
        }
    }
}

