/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.cmd;

import com.feed_the_beast.ftbl.lib.BroadcastSender;
import com.feed_the_beast.ftbl.lib.cmd.CommandLM;
import com.feed_the_beast.ftbl.lib.util.LMFileUtils;
import com.feed_the_beast.ftbu.api.FTBULang;
import com.feed_the_beast.ftbu.config.FTBUConfigBackups;
import com.feed_the_beast.ftbu.world.backups.Backups;
import java.io.File;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.command.CommandTreeBase;

public class CmdBackup
extends CommandTreeBase {
    public CmdBackup() {
        this.addSubcommand((ICommand)new CmdStart());
        this.addSubcommand((ICommand)new CmdStop());
        this.addSubcommand((ICommand)new CmdGetSize());
    }

    public String func_71517_b() {
        return "backup";
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.ftb.backup.usage";
    }

    public static class CmdGetSize
    extends CommandLM {
        public String func_71517_b() {
            return "getsize";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            String sizeW = LMFileUtils.getSizeS((File)sender.func_130014_f_().func_72860_G().func_75765_b());
            String sizeT = LMFileUtils.getSizeS((File)Backups.INSTANCE.backupsFolder);
            FTBULang.BACKUP_SIZE.printChat(sender, new Object[]{sizeW, sizeT});
        }
    }

    public static class CmdStop
    extends CommandLM {
        public String func_71517_b() {
            return "stop";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (Backups.INSTANCE.thread != null) {
                Backups.INSTANCE.thread.interrupt();
                Backups.INSTANCE.thread = null;
                FTBULang.BACKUP_STOP.printChat(sender, new Object[0]);
                return;
            }
            throw FTBULang.BACKUP_NOT_RUNNING.commandError(new Object[0]);
        }
    }

    public static class CmdStart
    extends CommandLM {
        public String func_71517_b() {
            return "start";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            boolean b = Backups.INSTANCE.run(server, sender, args.length == 0 ? "" : args[0]);
            if (b) {
                FTBULang.BACKUP_MANUAL_LAUNCH.printChat((ICommandSender)BroadcastSender.INSTANCE, new Object[]{sender.func_70005_c_()});
                if (!FTBUConfigBackups.USE_SEPARATE_THREAD.getBoolean()) {
                    Backups.INSTANCE.postBackup();
                }
            } else {
                FTBULang.BACKUP_ALREADY_RUNNING.printChat(sender, new Object[0]);
            }
        }
    }
}

