/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbu.client;

import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbu.net.MessageRequestBadge;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class CachedClientData {
    private static final String BASE_URL = "http://api.latmod.com/badges/get?id=";
    public static final ResourceLocation NO_BADGE = new ResourceLocation("ftbu", "textures/no_badge.png");
    private static final ResourceLocation FAILED_BADGE = new ResourceLocation("ftbu", "textures/failed_badge.png");
    private static final Map<UUID, ResourceLocation> BADGE_CACHE = new HashMap<UUID, ResourceLocation>();
    private static final Map<UUID, String> BADGES = new HashMap<UUID, String>();
    public static final Map<UUID, Integer> FLAGS = new HashMap<UUID, Integer>();

    public static void clear() {
        BADGES.clear();
        BADGE_CACHE.clear();
        FLAGS.clear();
    }

    public static ResourceLocation getBadgeTexture(UUID id) {
        String url;
        ResourceLocation tex = BADGE_CACHE.get(id);
        if (tex == null) {
            tex = NO_BADGE;
            BADGE_CACHE.put(id, tex);
            new ThreadGetBadge(id).start();
        } else if (tex.equals((Object)NO_BADGE) && (url = BADGES.get(id)) != null) {
            if (!url.isEmpty()) {
                tex = new ResourceLocation("ftbu", "badges/" + url.replace(':', '.'));
                FTBLibClient.getDownloadImage((ResourceLocation)tex, (String)url, (ResourceLocation)FAILED_BADGE, null);
            }
            BADGE_CACHE.put(id, tex);
        }
        return tex;
    }

    public static void setBadge(UUID id, String url) {
        BADGES.put(id, url);
        BADGE_CACHE.put(id, NO_BADGE);
    }

    public static void setFlags(UUID playerID, int flags) {
        FLAGS.put(playerID, flags);
    }

    private static class ThreadGetBadge
    extends Thread {
        private UUID playerID;

        public ThreadGetBadge(UUID id) {
            this.playerID = id;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            String badge;
            int flags;
            int n = flags = FLAGS.containsKey(this.playerID) ? FLAGS.get(this.playerID) : 0;
            if (!(flags & true)) {
                return;
            }
            if ((flags & 4) == 0) {
                try {
                    String s = LMStringUtils.readString((InputStream)new URL(CachedClientData.BASE_URL + LMStringUtils.fromUUID((UUID)this.playerID)).openStream());
                    if (!s.isEmpty()) {
                        BADGES.put(this.playerID, s);
                        return;
                    }
                }
                catch (Exception s) {
                    // empty catch block
                }
            }
            if ((badge = (String)BADGES.get(this.playerID)) == null) {
                new MessageRequestBadge(this.playerID).sendToServer();
            } else {
                String url = badge;
                Minecraft.func_71410_x().func_152344_a(() -> CachedClientData.setBadge(this.playerID, url));
            }
        }
    }
}

