/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.compat.forestry.allele;

import elec332.core.compat.forestry.EffectData;
import elec332.core.compat.forestry.allele.AlleleEffectThrottled;
import elec332.core.util.EntityHelper;
import elec332.core.world.WorldHelper;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class AlleleEffectSpawnMob
extends AlleleEffectThrottled {
    private final ResourceLocation mobType;
    private ResourceLocation mobTypePlayerNear;
    private int chance = 100;
    private int maxMobs = 5;
    private boolean angryOnPlayer = false;
    private boolean playerMustBeNear = false;

    public AlleleEffectSpawnMob(ResourceLocation rl, ResourceLocation mobType) {
        super(rl);
        this.requiresWorkingQueen = true;
        this.mobType = mobType;
    }

    public AlleleEffectSpawnMob(String s, ResourceLocation mobType) {
        super(s);
        this.requiresWorkingQueen = true;
        this.mobType = mobType;
    }

    public AlleleEffectSpawnMob(String uid, String unlocalizedName, ResourceLocation mobType) {
        super(uid, unlocalizedName);
        this.requiresWorkingQueen = true;
        this.mobType = mobType;
    }

    public AlleleEffectSpawnMob setSpawnChance(int chance) {
        this.chance = chance;
        return this;
    }

    public AlleleEffectSpawnMob setMaxMobsInArea(int maxMobs) {
        this.maxMobs = maxMobs;
        return this;
    }

    public AlleleEffectSpawnMob setOnlySpawnsWhenPlayersNear() {
        this.playerMustBeNear = true;
        return this;
    }

    public AlleleEffectSpawnMob setMobTypeWhenPlayerNear(ResourceLocation mobType) {
        this.mobTypePlayerNear = mobType;
        return this;
    }

    public AlleleEffectSpawnMob setAngryOnPlayers() {
        this.angryOnPlayer = true;
        return this;
    }

    @Override
    public AlleleEffectSpawnMob setThrottle(int throttle) {
        return (AlleleEffectSpawnMob)super.setThrottle(throttle);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            return new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        if (world.field_73012_v.nextInt(100) <= this.chance) {
            EntityPlayer player = this.getClosestPlayer(genome, housing);
            if (player == null && this.playerMustBeNear) {
                return storedData;
            }
            this.spawn(player, this.angryOnPlayer, genome, housing);
        }
        return storedData;
    }

    protected boolean spawn(EntityPlayer player, boolean angry, IBeeGenome genome, IBeeHousing housing) {
        Entity entity = null;
        if (this.mobTypePlayerNear != null && player != null) {
            entity = EntityHelper.createEntity(this.mobTypePlayerNear, housing.getWorldObj());
        }
        if (entity == null) {
            entity = EntityHelper.createEntity(this.mobType, housing.getWorldObj());
        }
        if (entity == null) {
            return false;
        }
        if (AlleleEffectSpawnMob.getEntitiesInRange(genome, housing, entity.getClass()).size() > this.maxMobs) {
            return false;
        }
        Random random = housing.getWorldObj().field_73012_v;
        AxisAlignedBB aabb = AlleleEffectSpawnMob.getBounding(genome, housing);
        entity.func_70012_b(aabb.field_72340_a + random.nextDouble() * (aabb.field_72336_d - aabb.field_72340_a), aabb.field_72338_b + random.nextDouble() * (aabb.field_72337_e - aabb.field_72338_b), aabb.field_72339_c + random.nextDouble() * (aabb.field_72334_f - aabb.field_72339_c), random.nextFloat() * 360.0f, 0.0f);
        if (WorldHelper.spawnEntityInWorld(housing.getWorldObj(), entity)) {
            if (entity instanceof EntityLiving && angry && player != null) {
                ((EntityLiving)entity).func_70624_b((EntityLivingBase)player);
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected EntityPlayer getClosestPlayer(IBeeGenome genome, final IBeeHousing housing) {
        List<EntityPlayer> players = AlleleEffectSpawnMob.getEntitiesInRange(genome, housing, EntityPlayer.class);
        Collections.sort(players, new Comparator<EntityPlayer>(){

            @Override
            public int compare(EntityPlayer o1, EntityPlayer o2) {
                return (int)(o1.func_174818_b(housing.getCoordinates()) - o2.func_174818_b(housing.getCoordinates()));
            }
        });
        for (EntityPlayer player : players) {
            if (BeeManager.armorApiaristHelper.wearsItems((EntityLivingBase)player, this.getUID(), true) < 4) continue;
            return player;
        }
        return null;
    }
}

