/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.pipeline.attribute;

import codechicken.lib.lighting.LC;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.VertexAttribute;
import codechicken.lib.render.pipeline.attribute.AttributeKey;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;

public class LightCoordAttribute
extends VertexAttribute<LC[]> {
    public static final AttributeKey<LC[]> attributeKey = new AttributeKey<LC[]>(){

        @Override
        public LC[] newArray(int length) {
            return new LC[length];
        }
    };
    private LC[] lcRef;
    private Vector3 vec = new Vector3();
    private Vector3 pos = new Vector3();

    @Override
    public LC[] newArray(int length) {
        return new LC[length];
    }

    @Override
    public String getAttribName() {
        return "lightCoordAttrib";
    }

    @Override
    public boolean load(CCRenderState state) {
        this.lcRef = state.model.getAttributes(attributeKey);
        if (state.model.hasAttribute(attributeKey)) {
            return this.lcRef != null;
        }
        this.pos.set(new Vector3(state.lightMatrix.pos));
        state.pipeline.addDependency(state.sideAttrib);
        state.pipeline.addRequirement(Transformation.operationIndex);
        return true;
    }

    @Override
    public void operate(CCRenderState state) {
        if (this.lcRef != null) {
            state.lc.set(this.lcRef[state.vertexIndex]);
        } else {
            state.lc.compute(this.vec.set(state.vert.vec).subtract(this.pos), state.side);
        }
    }
}

