/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.colour;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.util.TripleABC;
import com.google.common.collect.ImmutableList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.oredict.OreDictionary;

public enum EnumColour implements IStringSerializable
{
    WHITE("white", "dyeWhite", "item.fireworksCharge.white", 0xFFFFFF),
    ORANGE("orange", "dyeOrange", "item.fireworksCharge.orange", 12608256),
    MAGENTA("magenta", "dyeMagenta", "item.fireworksCharge.magenta", 11868853),
    LIGHT_BLUE("light_blue", "dyeLightBlue", "item.fireworksCharge.lightBlue", 7308529),
    YELLOW("yellow", "dyeYellow", "item.fireworksCharge.yellow", 0xBFBF00),
    LIME("lime", "dyeLime", "item.fireworksCharge.lime", 7074048),
    PINK("pink", "dyePink", "item.fireworksCharge.pink", 15812213),
    GRAY("gray", "dyeGray", "item.fireworksCharge.gray", 0x535353),
    LIGHT_GRAY("light_gray", "dyeLightGray", "item.fireworksCharge.silver", 0x939393),
    CYAN("cyan", "dyeCyan", "item.fireworksCharge.cyan", 34695),
    PURPLE("purple", "dyePurple", "item.fireworksCharge.purple", 6160576),
    BLUE("blue", "dyeBlue", "item.fireworksCharge.blue", 1250240),
    BROWN("brown", "dyeBrown", "item.fireworksCharge.brown", 5187328),
    GREEN("green", "dyeGreen", "item.fireworksCharge.green", 558848),
    RED("red", "dyeRed", "item.fireworksCharge.red", 10620678),
    BLACK("black", "dyeBlack", "item.fireworksCharge.black", 0x1F1F1F);

    private String minecraftName;
    private String oreDictionaryName;
    private String unlocalizedName;
    private int rgb;
    private static final ImmutableList<TripleABC<EnumColour, EnumColour, EnumColour>> mixMap;

    private EnumColour(String minecraftName, String oreDictionaryName, String unlocalizedName, int rgb) {
        this.minecraftName = minecraftName;
        this.oreDictionaryName = oreDictionaryName;
        this.unlocalizedName = unlocalizedName;
        this.rgb = rgb;
    }

    public String func_176610_l() {
        return this.minecraftName;
    }

    public String getMinecraftName() {
        return this.minecraftName;
    }

    public String getOreDictionaryName() {
        return this.oreDictionaryName;
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public int getWoolDamage() {
        return this.ordinal();
    }

    public int getDyeDamage() {
        return 15 - this.ordinal();
    }

    public int rgba() {
        return this.rgba(255);
    }

    public int rgba(int alpha) {
        return this.rgb << 8 | alpha & 0xFF;
    }

    public int argb() {
        return this.argb(255);
    }

    public int argb(int alpha) {
        return (alpha & 0xFF) << 24 | this.rgb;
    }

    public int rgb() {
        return this.rgb;
    }

    public float rF() {
        return (float)(this.rgb >> 16 & 0xFF) / 255.0f;
    }

    public float gF() {
        return (float)(this.rgb >> 8 & 0xFF) / 255.0f;
    }

    public float bF() {
        return (float)(this.rgb & 0xFF) / 255.0f;
    }

    public ColourRGBA getColour() {
        return this.getColour(255);
    }

    public ColourRGBA getColour(int alpha) {
        return new ColourRGBA(this.rgba(alpha));
    }

    public EnumColour mix(EnumColour b) {
        return EnumColour.mix(this, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnumColour mix(EnumColour a, EnumColour b) {
        if (a == b) {
            return a;
        }
        ImmutableList<TripleABC<EnumColour, EnumColour, EnumColour>> immutableList = mixMap;
        synchronized (immutableList) {
            for (TripleABC triple : mixMap) {
                if ((!((EnumColour)((Object)triple.getA())).equals((Object)a) || !((EnumColour)((Object)triple.getB())).equals((Object)b)) && (!((EnumColour)((Object)triple.getA())).equals((Object)b) || !((EnumColour)((Object)triple.getB())).equals((Object)a))) continue;
                return (EnumColour)((Object)triple.getC());
            }
        }
        return null;
    }

    public static EnumColour fromWoolID(int id) {
        return EnumColour.values()[id];
    }

    public static EnumColour fromDyeID(int id) {
        return EnumColour.values()[15 - id];
    }

    public static EnumColour fromOreDictID(String id) {
        for (EnumColour c : EnumColour.values()) {
            if (!c.getOreDictionaryName().equals(id)) continue;
            return c;
        }
        return null;
    }

    public static EnumColour fromStack(ItemStack stack) {
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            EnumColour c = EnumColour.fromOreDictID(OreDictionary.getOreName((int)id));
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static EnumColour fromName(String name) {
        for (EnumColour colour : EnumColour.values()) {
            if (!colour.func_176610_l().equalsIgnoreCase(name)) continue;
            return colour;
        }
        return null;
    }

    private static TripleABC<EnumColour, EnumColour, EnumColour> getTriple(EnumColour a, EnumColour b, EnumColour result) {
        return new TripleABC<EnumColour, EnumColour, EnumColour>(a, b, result);
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(EnumColour.getTriple(YELLOW, RED, ORANGE));
        builder.add(EnumColour.getTriple(PINK, PURPLE, MAGENTA));
        builder.add(EnumColour.getTriple(WHITE, BLUE, LIGHT_BLUE));
        builder.add(EnumColour.getTriple(WHITE, GREEN, LIME));
        builder.add(EnumColour.getTriple(WHITE, RED, PINK));
        builder.add(EnumColour.getTriple(WHITE, BLACK, GRAY));
        builder.add(EnumColour.getTriple(WHITE, GRAY, LIGHT_GRAY));
        builder.add(EnumColour.getTriple(BLUE, GREEN, CYAN));
        builder.add(EnumColour.getTriple(BLUE, RED, PURPLE));
        builder.add(EnumColour.getTriple(ORANGE, RED, BROWN));
        builder.add(EnumColour.getTriple(YELLOW, BLUE, GREEN));
        mixMap = builder.build();
    }
}

