/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.TileOrMultipart;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.filter.SubFilterWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class RootFilter
implements IRootFilter {
    private final List<SubFilterWrapper> filterList = Lists.newArrayList();

    @Override
    public int getFilterCount() {
        return this.filterList.size();
    }

    @Override
    @Nullable
    public IFilter getFilter(int index) {
        if (index < 0 || index >= this.filterList.size()) {
            return null;
        }
        return this.filterList.get(index).getFilter();
    }

    @Override
    public boolean isBlacklist(int index) {
        if (index < 0 || index >= this.filterList.size()) {
            return false;
        }
        return this.filterList.get(index).isBlacklist();
    }

    @Override
    public void setIsBlacklist(int index, boolean isBlacklist) {
        if (index < 0 || index >= this.filterList.size()) {
            return;
        }
        this.filterList.get(index).setBlacklist(isBlacklist);
    }

    @Override
    public void addFilter(IFilter filter) {
        this.filterList.add(new SubFilterWrapper(filter));
    }

    @Override
    public void removeFilter(int index) {
        this.filterList.remove(index);
    }

    @Override
    public boolean passes(TileOrMultipart tileEntity, ItemStack itemStack) {
        boolean passes = false;
        for (SubFilterWrapper filter : this.filterList) {
            boolean filterPasses = filter.getFilter().passes(tileEntity, itemStack);
            if (filterPasses && filter.isBlacklist()) {
                return false;
            }
            passes = passes || filterPasses;
        }
        return passes;
    }

    public NBTBase serializeNBT() {
        NBTTagList list = new NBTTagList();
        for (SubFilterWrapper filter : this.filterList) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            filter.writeNBT(tagCompound);
            list.func_74742_a((NBTBase)tagCompound);
        }
        return list;
    }

    public void deserializeNBT(NBTBase nbt) {
        this.filterList.clear();
        NBTTagList list = (NBTTagList)nbt;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = list.func_150305_b(i);
            SubFilterWrapper filter = SubFilterWrapper.loadFromNBT(tagCompound);
            if (filter == null) continue;
            this.filterList.add(filter);
        }
    }
}

