/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.refinedrelocation.api.TileOrMultipart;
import net.blay09.mods.refinedrelocation.api.client.IFilterIcon;
import net.blay09.mods.refinedrelocation.api.filter.IConfigurableFilter;
import net.blay09.mods.refinedrelocation.api.filter.IFilter;
import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.blay09.mods.refinedrelocation.client.gui.GuiNameFilter;
import net.blay09.mods.refinedrelocation.container.ContainerNameFilter;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NameFilter
implements IFilter,
IConfigurableFilter {
    public static final String ID = "refinedrelocation:NameFilter";
    private static final Pattern WILDCARD_PATTERN = Pattern.compile("[^*]+|(\\*)");
    private static final Matcher WILDCARD_MATCHER = WILDCARD_PATTERN.matcher("");
    private String value = "";
    private Pattern[] cachedPatterns;

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public boolean isFilterUsable(TileOrMultipart tileEntity) {
        return true;
    }

    @Override
    public boolean passes(TileOrMultipart tileEntity, ItemStack itemStack) {
        Pattern[] patterns;
        String itemName = itemStack.func_82833_r();
        for (Pattern pattern : patterns = this.getPatterns()) {
            if (!pattern.matcher(itemName).matches()) continue;
            return true;
        }
        return false;
    }

    public void setValue(String value) {
        this.value = value;
        this.cachedPatterns = null;
    }

    public String getValue() {
        return this.value;
    }

    public Pattern[] getPatterns() {
        if (this.cachedPatterns == null) {
            String[] patternsSplit = this.value.split("[\n,]");
            this.cachedPatterns = new Pattern[patternsSplit.length];
            for (int i = 0; i < patternsSplit.length; ++i) {
                WILDCARD_MATCHER.reset(patternsSplit[i]);
                StringBuffer sb = new StringBuffer();
                while (WILDCARD_MATCHER.find()) {
                    if (WILDCARD_MATCHER.group(1) != null) {
                        WILDCARD_MATCHER.appendReplacement(sb, ".*");
                        continue;
                    }
                    WILDCARD_MATCHER.appendReplacement(sb, Matcher.quoteReplacement(WILDCARD_MATCHER.group(0)));
                }
                WILDCARD_MATCHER.appendTail(sb);
                this.cachedPatterns[i] = Pattern.compile(sb.toString());
            }
        }
        return this.cachedPatterns;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("Patterns", this.value);
        return compound;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.value = compound.func_74779_i("Patterns");
    }

    @Override
    public String getLangKey() {
        return "filter.refinedrelocation:NameFilter";
    }

    @Override
    public String getDescriptionLangKey() {
        return "filter.refinedrelocation:NameFilter.description";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IFilterIcon getFilterIcon() {
        return ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:icon_NameFilter");
    }

    @Override
    public Container createContainer(EntityPlayer player, TileOrMultipart tileEntity) {
        return new ContainerNameFilter(player, tileEntity, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen createGuiScreen(EntityPlayer player, TileOrMultipart tileEntity) {
        return new GuiNameFilter(player, tileEntity, this);
    }
}

