/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.compat.ironchest;

import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.TileEntityIronChest;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySimpleFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingGridMember;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileSortingIronChest
extends TileEntityIronChest
implements ITickable {
    private final InvWrapper invWrapper = new InvWrapper((IInventory)this);
    private final ISortingInventory sortingInventory = (ISortingInventory)CapabilitySortingInventory.CAPABILITY.getDefaultInstance();
    private final IRootFilter rootFilter = (IRootFilter)CapabilityRootFilter.CAPABILITY.getDefaultInstance();

    public TileSortingIronChest() {
    }

    public TileSortingIronChest(IronChestType type) {
        super(type);
    }

    public void onContentsChanged(int slot) {
        this.func_70296_d();
        this.sortingInventory.onSlotChanged(slot);
    }

    public void func_73660_a() {
        super.func_73660_a();
        this.sortingInventory.onUpdate((TileEntity)this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate((TileEntity)this);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_74782_a("RootFilter", this.rootFilter.serializeNBT());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.sortingInventory.deserializeNBT((NBTBase)compound.func_74775_l("SortingInventory"));
        this.rootFilter.deserializeNBT((NBTBase)compound.func_150295_c("RootFilter", 10));
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? super.func_70005_c_() : "container.refinedrelocation:ironchest.sorting_chest_" + this.getType().name().toLowerCase(Locale.ENGLISH);
    }

    public IronChestType getType() {
        if (this.func_145830_o()) {
            return IronChestType.VALUES[this.func_145832_p()];
        }
        return IronChestType.IRON;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        super.func_70299_a(index, stack);
        this.onContentsChanged(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemStack = super.func_70298_a(index, count);
        this.onContentsChanged(index);
        return itemStack;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.invWrapper;
        }
        if (capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY) {
            return (T)this.sortingInventory;
        }
        if (capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY) {
            return (T)this.rootFilter;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY || capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY || super.hasCapability(capability, facing);
    }

    public static class Silver
    extends TileSortingIronChest {
        public Silver() {
            super(IronChestType.SILVER);
        }
    }

    public static class Gold
    extends TileSortingIronChest {
        public Gold() {
            super(IronChestType.GOLD);
        }
    }

    public static class Copper
    extends TileSortingIronChest {
        public Copper() {
            super(IronChestType.COPPER);
        }
    }

    public static class Diamond
    extends TileSortingIronChest {
        public Diamond() {
            super(IronChestType.DIAMOND);
        }
    }

    public static class Crystal
    extends TileSortingIronChest {
        public Crystal() {
            super(IronChestType.CRYSTAL);
        }
    }

    public static class Obsidian
    extends TileSortingIronChest {
        public Obsidian() {
            super(IronChestType.OBSIDIAN);
        }
    }

    public static class Dirt
    extends TileSortingIronChest {
        public Dirt() {
            super(IronChestType.DIRTCHEST9000);
        }
    }
}

