/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.blay09.mods.refinedrelocation.client.util.TextureAtlasRegion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ProgressManager;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureAtlas
extends AbstractTexture
implements ITickableTextureObject,
IResourceManagerReloadListener {
    private static final Logger logger = LogManager.getLogger();
    private final ResourceLocation atlasFile;
    private final String basePath;
    private final Map<String, TextureAtlasRegion> registeredSprites = Maps.newHashMap();
    private final Map<String, TextureAtlasRegion> uploadedSprites = Maps.newHashMap();
    private final List<TextureAtlasRegion> animatedSprites = Lists.newArrayList();
    private TextureAtlasRegion missingImage;

    public TextureAtlas(ResourceLocation atlasFile, String basePath) {
        this.atlasFile = atlasFile;
        this.basePath = basePath;
        this.missingImage = new TextureAtlasRegion(this, "missingno");
    }

    private void initMissingImage() {
        int[] data = TextureUtil.field_110999_b;
        this.missingImage.func_110966_b(16);
        this.missingImage.func_110969_c(16);
        int[][] mipmapData = new int[][]{data};
        this.missingImage.func_110968_a(Collections.singletonList(mipmapData));
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
        this.loadSprites(resourceManager);
    }

    private void loadSprites(IResourceManager resourceManager) {
        this.registeredSprites.clear();
        Gson gson = new Gson();
        try {
            IResource resource = resourceManager.func_110536_a(this.atlasFile);
            try (InputStreamReader reader = new InputStreamReader(resource.func_110527_b());){
                JsonObject object = (JsonObject)gson.fromJson((Reader)reader, JsonObject.class);
                if (object != null) {
                    JsonArray sprites = object.getAsJsonArray("sprites");
                    for (int i = 0; i < sprites.size(); ++i) {
                        String name = sprites.get(i).getAsString();
                        this.registerSprite(new ResourceLocation(name));
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.initMissingImage();
        this.func_147631_c();
        this.loadAtlas(resourceManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAtlas(IResourceManager resourceManager) {
        ResourceLocation fullLocation;
        ResourceLocation location;
        this.uploadedSprites.clear();
        this.animatedSprites.clear();
        int maxTextureSize = Minecraft.func_71369_N();
        Stitcher stitcher = new Stitcher(maxTextureSize, maxTextureSize, 0, 0);
        ProgressManager.ProgressBar bar = ProgressManager.push((String)"GUI Texture stitching", (int)this.registeredSprites.size());
        for (Map.Entry<String, TextureAtlasRegion> entry : this.registeredSprites.entrySet()) {
            TextureAtlasSprite sprite = entry.getValue();
            location = new ResourceLocation(sprite.func_94215_i());
            fullLocation = this.completeResourceLocation(location);
            bar.step(fullLocation.func_110623_a());
            IResource resource = null;
            if (sprite.hasCustomLoader(resourceManager, location)) {
                if (sprite.load(resourceManager, location)) {
                    continue;
                }
            } else {
                try {
                    resource = resourceManager.func_110536_a(fullLocation);
                    PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)resource);
                    boolean isAnimated = resource.func_110526_a("animation") != null;
                    sprite.func_188538_a(pngSizeInfo, isAnimated);
                }
                catch (RuntimeException e) {
                    FMLClientHandler.instance().trackBrokenTexture(fullLocation, e.getMessage());
                    continue;
                }
                catch (IOException e) {
                    FMLClientHandler.instance().trackMissingTexture(fullLocation);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly((Closeable)resource);
                    continue;
                }
            }
            stitcher.func_110934_a(sprite);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        stitcher.func_110934_a((TextureAtlasSprite)this.missingImage);
        bar = ProgressManager.push((String)"GUI Texture creation", (int)2);
        bar.step("Stitching");
        stitcher.func_94305_f();
        logger.info("Created: {}x{} {}-atlas", new Object[]{stitcher.func_110935_a(), stitcher.func_110936_b(), this.basePath});
        bar.step("Allocating GL texture");
        TextureUtil.func_180600_a((int)this.func_110552_b(), (int)0, (int)stitcher.func_110935_a(), (int)stitcher.func_110936_b());
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
        HashMap map = Maps.newHashMap(this.registeredSprites);
        bar = ProgressManager.push((String)"GUI Texture upload", (int)stitcher.func_94309_g().size());
        for (TextureAtlasSprite sprite : stitcher.func_94309_g()) {
            bar.step(sprite.func_94215_i());
            location = new ResourceLocation(sprite.func_94215_i());
            fullLocation = this.completeResourceLocation(location);
            if (sprite != this.missingImage && !sprite.hasCustomLoader(resourceManager, location)) {
                try {
                    sprite.func_188539_a(resourceManager.func_110536_a(fullLocation), 1);
                }
                catch (RuntimeException e) {
                    logger.error("Unable to parse metadata from {}", new Object[]{fullLocation, e});
                }
                catch (IOException e) {
                    logger.error("Using missing texture, unable to load {}", new Object[]{fullLocation, e});
                }
            }
            String name = sprite.func_94215_i();
            map.remove(name);
            this.uploadedSprites.put(name, (TextureAtlasRegion)sprite);
            try {
                TextureUtil.func_147955_a((int[][])sprite.func_147965_a(0), (int)sprite.func_94211_a(), (int)sprite.func_94216_b(), (int)sprite.func_130010_a(), (int)sprite.func_110967_i(), (boolean)false, (boolean)false);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReport.func_85055_a((Throwable)throwable, (String)"Stitching texture atlas");
                CrashReportCategory category = report.func_85058_a("Texture being stitched together");
                category.func_71507_a("Atlas path", (Object)this.basePath);
                category.func_71507_a("Sprite", (Object)sprite);
                throw new ReportedException(report);
            }
            if (!sprite.func_130098_m()) continue;
            this.animatedSprites.add((TextureAtlasRegion)sprite);
        }
        for (TextureAtlasSprite sprite : map.values()) {
            sprite.func_94217_a((TextureAtlasSprite)this.missingImage);
        }
        ProgressManager.pop((ProgressManager.ProgressBar)bar);
    }

    public TextureAtlasRegion registerSprite(@Nonnull ResourceLocation location) {
        TextureAtlasRegion sprite = this.registeredSprites.get(location.toString());
        if (sprite == null) {
            sprite = new TextureAtlasRegion(this, location);
            this.registeredSprites.put(location.toString(), sprite);
        }
        return sprite;
    }

    public TextureAtlasRegion getSprite(String name) {
        TextureAtlasRegion sprite = this.uploadedSprites.get(name);
        if (sprite == null) {
            sprite = this.missingImage;
        }
        return sprite;
    }

    public void func_110550_d() {
        GlStateManager.func_179144_i((int)this.func_110552_b());
        for (TextureAtlasSprite textureAtlasSprite : this.animatedSprites) {
            textureAtlasSprite.func_94219_l();
        }
    }

    private ResourceLocation completeResourceLocation(ResourceLocation resource) {
        return new ResourceLocation(resource.func_110624_b(), String.format("%s/%s%s", this.basePath, resource.func_110623_a(), ".png"));
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.loadSprites(resourceManager);
    }
}

