/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiRootNode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public abstract class GuiContainerMod<T extends Container>
extends GuiContainer
implements IParentScreen {
    protected final T container;
    protected final GuiRootNode rootNode = new GuiRootNode(this);
    private final List<String> tooltip = Lists.newArrayList();
    private GuiElement mouseElement;
    protected boolean shouldKeyRepeat;

    public GuiContainerMod(T container) {
        super(container);
        this.container = container;
    }

    @OverridingMethodsMustInvokeSuper
    public void func_73866_w_() {
        super.func_73866_w_();
        this.rootNode.setPosition(this.field_147003_i, this.field_147009_r);
        this.rootNode.setSize(this.field_146999_f, this.field_147000_g);
        this.rootNode.initGui(this);
        if (this.shouldKeyRepeat) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
    }

    public boolean onGuiAboutToClose() {
        return true;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.shouldKeyRepeat) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta != 0) {
            int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            this.rootNode.getElementAt(mouseX, mouseY).mouseWheelMoved(mouseX, mouseY, delta);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.shouldKeyRepeat) {
            Keyboard.enableRepeatEvents((boolean)true);
        }
        if (!this.rootNode.getElementAt(mouseX, mouseY).mouseClicked(mouseX, mouseY, mouseButton)) {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.rootNode.mouseReleased(mouseX, mouseY, state);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.rootNode.keyTyped(typedChar, keyCode)) {
            if (keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
                if (this.onGuiAboutToClose()) {
                    this.field_146297_k.field_71439_g.func_71053_j();
                }
                return;
            }
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void func_73876_c() {
        super.func_73876_c();
        this.rootNode.update();
    }

    @OverridingMethodsMustInvokeSuper
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.rootNode.drawBackground(this, mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.mouseElement = this.rootNode.getElementAt(mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.rootNode.drawForeground(this, mouseX, mouseY);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
        this.tooltip.clear();
        GuiElement tooltipElement = this.rootNode.getElementAt(mouseX, mouseY);
        tooltipElement.addTooltip(this.tooltip);
        if (!this.tooltip.isEmpty()) {
            this.func_146283_a(this.tooltip, mouseX, mouseY);
        }
    }

    public T getContainer() {
        return this.container;
    }

    @Override
    public GuiElement getMouseElement() {
        return this.mouseElement;
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public Minecraft getMinecraft() {
        return this.field_146297_k;
    }

    @Override
    public int getLeft() {
        return this.field_147003_i;
    }

    @Override
    public int getTop() {
        return this.field_147009_r;
    }

    @Override
    public int getWidth() {
        return this.field_146999_f;
    }

    @Override
    public int getHeight() {
        return this.field_147000_g;
    }
}

