/*
 * Decompiled with CFR 0.152.
 */
package com.sb205.missing_pieces.MpBlocks;

import com.google.common.base.Predicate;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCandelabra
extends Block {
    public static final PropertyDirection PROPERTYFACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyDirection PROPERTYCEILING = PropertyDirection.func_177712_a((String)"ceiling", (Predicate)EnumFacing.Plane.VERTICAL);

    public BlockCandelabra(Material material) {
        super(material);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149715_a(1.0f);
        this.func_149711_c(0.5f);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = EnumFacing.NORTH;
        EnumFacing ceiling = EnumFacing.UP;
        switch (blockFaceClickedOn) {
            case DOWN: {
                enumfacing = EnumFacing.NORTH;
                ceiling = EnumFacing.UP;
                break;
            }
            case NORTH: {
                ceiling = EnumFacing.DOWN;
                enumfacing = EnumFacing.SOUTH;
                break;
            }
            case SOUTH: {
                ceiling = EnumFacing.DOWN;
                enumfacing = EnumFacing.NORTH;
                break;
            }
            case EAST: {
                ceiling = EnumFacing.DOWN;
                enumfacing = EnumFacing.WEST;
                break;
            }
            case WEST: {
                ceiling = EnumFacing.DOWN;
                enumfacing = EnumFacing.EAST;
                break;
            }
            default: {
                enumfacing = EnumFacing.SOUTH;
                ceiling = EnumFacing.UP;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)enumfacing).func_177226_a((IProperty)PROPERTYCEILING, (Comparable)ceiling);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getAxisAlignedBBFromFacing(this.getFacingFromState(state), this.getCeilingFromState(state));
    }

    private AxisAlignedBB getAxisAlignedBBFromFacing(EnumFacing facing, EnumFacing ceiling) {
        double maxY;
        double maxX;
        double maxZ;
        double minX;
        double minY;
        double minZ;
        block0 : switch (ceiling) {
            case UP: {
                if (facing == EnumFacing.NORTH) {
                    minZ = 0.0;
                    minY = 0.0;
                    minX = 0.0;
                    maxZ = 1.0;
                    maxX = 1.0;
                    maxY = 1.0;
                    break;
                }
                minZ = 0.0;
                minY = 0.0;
                minX = 0.0;
                maxZ = 1.0;
                maxX = 1.0;
                maxY = 1.0;
                break;
            }
            default: {
                switch (facing) {
                    default: {
                        minX = 0.09375;
                        minY = 0.125;
                        minZ = 0.0;
                        maxX = 0.90625;
                        maxY = 0.9375;
                        maxZ = 0.75;
                        break block0;
                    }
                    case EAST: {
                        minZ = 0.09375;
                        minY = 0.125;
                        minX = 0.25;
                        maxZ = 0.90625;
                        maxY = 0.9375;
                        maxX = 1.0;
                        break block0;
                    }
                    case SOUTH: {
                        minX = 0.09375;
                        minY = 0.125;
                        minZ = 0.25;
                        maxX = 0.90625;
                        maxY = 0.9375;
                        maxZ = 1.0;
                        break block0;
                    }
                    case WEST: 
                }
                minZ = 0.09375;
                minY = 0.125;
                minX = 0.0;
                maxZ = 0.90625;
                maxY = 0.9375;
                maxX = 0.75;
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        return facing;
    }

    public EnumFacing getCeilingFromState(IBlockState state) {
        EnumFacing ceiling = (EnumFacing)state.func_177229_b((IProperty)PROPERTYCEILING);
        return ceiling;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        EnumFacing ceiling = (meta & 4) == 0 ? EnumFacing.UP : EnumFacing.DOWN;
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)facing).func_177226_a((IProperty)PROPERTYCEILING, (Comparable)ceiling);
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)PROPERTYFACING);
        EnumFacing ceiling = (EnumFacing)state.func_177229_b((IProperty)PROPERTYCEILING);
        int facingbits = facing.func_176736_b() + (ceiling == EnumFacing.DOWN ? 4 : 0);
        return facingbits;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTYFACING, PROPERTYCEILING});
    }

    public String getOredictName() {
        String name = this.func_149739_a().substring(5);
        String[] parts = name.split("_");
        String firstLetter = parts[1].substring(0, 1);
        return parts[0] + ":" + firstLetter.toUpperCase(Locale.ENGLISH) + ":" + parts[1].substring(1);
    }

    public String getName() {
        return this.func_149739_a().substring(5);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }
}

