/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.gui.GuiManual;
import com.google.common.collect.ArrayListMultimap;
import net.minecraft.client.gui.FontRenderer;

public abstract class ManualInstance {
    public FontRenderer fontRenderer;
    public String texture;
    public ArrayListMultimap<String, ManualEntry> manualContents = ArrayListMultimap.create();

    public ManualInstance(FontRenderer fontRenderer, String texture) {
        this.fontRenderer = fontRenderer;
        this.texture = texture;
    }

    public abstract String getManualName();

    public abstract String[] getSortedCategoryList();

    public abstract String formatCategoryName(String var1);

    public abstract String formatEntryName(String var1);

    public abstract String formatEntrySubtext(String var1);

    public abstract String formatText(String var1);

    public abstract boolean showCategoryInList(String var1);

    public abstract boolean showEntryInList(ManualEntry var1);

    public abstract int getTitleColour();

    public abstract int getSubTitleColour();

    public abstract int getTextColour();

    public abstract int getHighlightColour();

    public abstract int getPagenumberColour();

    public abstract boolean allowGuiRescale();

    public abstract boolean improveReadability();

    public void openManual() {
    }

    public void closeManual() {
    }

    public void openEntry(String entry) {
    }

    public void titleRenderPre() {
    }

    public void titleRenderPost() {
    }

    public void entryRenderPre() {
    }

    public void entryRenderPost() {
    }

    public void tooltipRenderPre() {
    }

    public void tooltipRenderPost() {
    }

    public GuiManual getGui() {
        return new GuiManual(this, this.texture);
    }

    public void addEntry(String name, String category, IManualPage ... pages) {
        this.manualContents.put((Object)category, (Object)new ManualEntry(name, category, pages));
    }

    public ManualEntry getEntry(String name) {
        for (ManualEntry e : this.manualContents.values()) {
            if (!e.name.equalsIgnoreCase(name)) continue;
            return e;
        }
        return null;
    }

    public void recalculateAllRecipes() {
        for (ManualEntry entry : this.manualContents.values()) {
            for (IManualPage p : entry.getPages()) {
                p.recalculateCraftingRecipes();
            }
        }
    }

    public static class ManualEntry {
        String name;
        String category;
        IManualPage[] pages;

        public ManualEntry(String name, String category, IManualPage ... pages) {
            this.name = name;
            this.category = category;
            this.pages = pages;
        }

        public String getName() {
            return this.name;
        }

        public String getCategory() {
            return this.category;
        }

        public IManualPage[] getPages() {
            return this.pages;
        }

        public void setPages(IManualPage[] pages) {
            this.pages = pages;
        }
    }
}

