/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.models.ModelShaderMinecart;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageMinecartShaderSync
implements IMessage {
    int dimension;
    int entityID;
    boolean request = false;
    ItemStack shader;

    public MessageMinecartShaderSync(Entity entity, Object o) {
        this.dimension = entity.field_70170_p.field_73011_w.getDimension();
        this.entityID = entity.func_145782_y();
        if (o instanceof CapabilityShader.ShaderWrapper) {
            this.shader = ((CapabilityShader.ShaderWrapper)o).getShaderItem();
        } else {
            this.request = true;
        }
    }

    public MessageMinecartShaderSync() {
    }

    public void fromBytes(ByteBuf buf) {
        this.dimension = buf.readInt();
        this.entityID = buf.readInt();
        this.request = buf.readBoolean();
        if (!this.request) {
            this.shader = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimension);
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.request);
        if (!this.request) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.shader);
        }
    }

    public static class HandlerClient
    implements IMessageHandler<MessageMinecartShaderSync, IMessage> {
        public IMessage onMessage(MessageMinecartShaderSync message, MessageContext ctx) {
            Entity entity;
            World world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (entity = world.func_73045_a(message.entityID)) instanceof EntityMinecart) {
                ModelShaderMinecart.shadedCarts.put(message.entityID, message.shader);
            }
            return null;
        }
    }

    public static class HandlerServer
    implements IMessageHandler<MessageMinecartShaderSync, IMessage> {
        public IMessage onMessage(MessageMinecartShaderSync message, MessageContext ctx) {
            CapabilityShader.ShaderWrapper handler;
            Entity entity;
            WorldServer world = DimensionManager.getWorld((int)message.dimension);
            if (world != null && (entity = world.func_73045_a(message.entityID)) != null && entity.hasCapability(CapabilityShader.SHADER_CAPABILITY, null) && (handler = (CapabilityShader.ShaderWrapper)entity.getCapability(CapabilityShader.SHADER_CAPABILITY, null)) != null) {
                ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMinecartShaderSync(entity, handler));
            }
            return null;
        }
    }
}

