/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ChestChangerType;
import cpw.mods.ironchest.CommonProxy;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemIronChest;
import cpw.mods.ironchest.OcelotsSitOnChestsHandler;
import java.util.Properties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

@Mod(modid="ironchest", name="Iron Chests", dependencies="required-after:Forge@[12.17.0.1909,)", acceptedMinecraftVersions="[1.9.4, 1.11)")
public class IronChest {
    public static final String MOD_ID = "ironchest";
    @Mod.Instance(value="ironchest")
    public static IronChest instance;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.CommonProxy")
    public static CommonProxy proxy;
    public static BlockIronChest ironChestBlock;
    public static ItemIronChest ironChestItemBlock;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Properties properties = event.getVersionProperties();
        if (properties != null) {
            String major = properties.getProperty("IronChest.build.major.number");
            String minor = properties.getProperty("IronChest.build.minor.number");
            String rev = properties.getProperty("IronChest.build.revision.number");
            String build = properties.getProperty("IronChest.build.number");
            event.getModMetadata().version = String.format("%s.%s.%s build %s", major, minor, rev, build);
        }
        ChestChangerType.buildItems();
        ironChestBlock = (BlockIronChest)GameRegistry.register((IForgeRegistryEntry)new BlockIronChest());
        ironChestItemBlock = (ItemIronChest)GameRegistry.register((IForgeRegistryEntry)new ItemIronChest(ironChestBlock));
        for (IronChestType typ : IronChestType.VALUES) {
            GameRegistry.registerTileEntity(typ.clazz, (String)("IronChest." + typ.name()));
        }
        IronChestType.registerBlocksAndRecipes(ironChestBlock);
        ChestChangerType.generateRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        MinecraftForge.EVENT_BUS.register((Object)new OcelotsSitOnChestsHandler());
    }
}

