/*
 * Decompiled with CFR 0.152.
 */
package com.mrdimka.solarfluxreborn.te.cable;

import cofh.api.energy.IEnergyConnection;
import com.mrdimka.hammercore.ext.TeslaAPI;
import com.mrdimka.hammercore.vec.Cuboid6;
import com.mrdimka.solarfluxreborn.te.cable.TileAbstractCable;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileCustomCable
extends TileAbstractCable {
    public double capacityAdded;
    public ResourceLocation tier;
    public Cuboid6[] cubs = null;
    private int connectionTimer = 0;

    public TileCustomCable() {
    }

    public TileCustomCable(double cap, ResourceLocation tier) {
        this.tier = tier;
        this.capacityAdded = cap;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.connectionTimer++ % 20 == 0) {
            this.cubs = this.bake();
        }
    }

    @Override
    public double getCapacityAddedToNet() {
        return this.capacityAdded;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        nbt.func_74780_a("CapacityAdded", this.capacityAdded);
        nbt.func_74778_a("CapTier", this.tier.toString());
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.capacityAdded = nbt.func_74769_h("CapacityAdded");
        this.tier = new ResourceLocation(nbt.func_74779_i("CapTier"));
    }

    @Override
    public String getResourceConnection() {
        return this.tier.toString();
    }

    public Cuboid6[] bake() {
        ArrayList<Cuboid6> c = new ArrayList<Cuboid6>();
        c.add(new Cuboid6(0.375, 0.375, 0.375, 0.625, 0.625, 0.625));
        for (EnumFacing f : EnumFacing.field_82609_l) {
            boolean conn = false;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
            if (te == null) continue;
            if (te != null && TileCustomCable.class.isAssignableFrom(te.getClass())) {
                conn = true;
            } else if (te instanceof IEnergyConnection && ((IEnergyConnection)te).canConnectEnergy(f.func_176734_d())) {
                conn = true;
            } else if (te.hasCapability(CapabilityEnergy.ENERGY, f.func_176734_d())) {
                conn = true;
            } else if (TeslaAPI.isTeslaConsumer((TileEntity)te)) {
                conn = true;
            }
            if (!conn) continue;
            if (f == EnumFacing.UP) {
                c.add(new Cuboid6(0.375, 0.625, 0.375, 0.625, 1.0, 0.625));
            }
            if (f == EnumFacing.DOWN) {
                c.add(new Cuboid6(0.375, 0.0, 0.375, 0.625, 0.375, 0.625));
            }
            if (f == EnumFacing.EAST) {
                c.add(new Cuboid6(0.625, 0.375, 0.375, 1.0, 0.625, 0.625));
            }
            if (f == EnumFacing.WEST) {
                c.add(new Cuboid6(0.0, 0.375, 0.375, 0.375, 0.625, 0.625));
            }
            if (f == EnumFacing.SOUTH) {
                c.add(new Cuboid6(0.375, 0.375, 0.625, 0.625, 0.625, 1.0));
            }
            if (f != EnumFacing.NORTH) continue;
            c.add(new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 0.375));
        }
        return c.toArray(new Cuboid6[c.size()]);
    }

    public Cuboid6[] getCuboids() {
        if (this.cubs == null) {
            this.cubs = this.bake();
        }
        return this.cubs;
    }
}

