/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import appeng.api.config.ViewItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.api.IThEWirelessEssentiaTerminal;
import thaumicenergistics.api.gui.IAspectSelectorContainer;
import thaumicenergistics.api.gui.IAspectSelectorGui;
import thaumicenergistics.api.storage.IAspectStack;
import thaumicenergistics.client.gui.ThEGuiHelper;
import thaumicenergistics.client.gui.abstraction.GuiConstants_ECT;
import thaumicenergistics.client.gui.abstraction.ThEScrollbarGui;
import thaumicenergistics.client.gui.buttons.GuiButtonSortingMode;
import thaumicenergistics.client.gui.buttons.GuiButtonViewType;
import thaumicenergistics.client.gui.widget.ThEWidget;
import thaumicenergistics.client.gui.widget.WidgetAspectSelector;
import thaumicenergistics.client.textures.GuiTextureManager;
import thaumicenergistics.common.container.ContainerEssentiaCell;
import thaumicenergistics.common.container.ContainerEssentiaCellTerminalBase;
import thaumicenergistics.common.container.ContainerEssentiaTerminal;
import thaumicenergistics.common.container.ContainerWirelessEssentiaTerminal;
import thaumicenergistics.common.inventory.HandlerWirelessEssentiaTerminal;
import thaumicenergistics.common.network.packet.server.Packet_S_EssentiaCellTerminal;
import thaumicenergistics.common.parts.PartEssentiaTerminal;
import thaumicenergistics.common.registries.ThEStrings;
import thaumicenergistics.common.storage.AspectStackComparator;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaCellTerminal
extends GuiConstants_ECT
implements IAspectSelectorGui {
    private final String guiTitle;
    private final String selectedInfoNamePrefix;
    private final String selectedInfoAmountPrefix;
    protected EntityPlayer player;
    protected int currentScroll = 0;
    protected GuiTextField searchBar;
    protected final WidgetAspectSelector[] aspectWidgets;
    protected ArrayList<IAspectStack> matchingSearchStacks = new ArrayList();
    protected String searchTerm = "";
    protected ContainerEssentiaCellTerminalBase baseContainer;
    protected AspectStackComparator.AspectStackComparatorMode sortMode = AspectStackComparator.AspectStackComparatorMode.MODE_ALPHABETIC;
    protected boolean flagWidgetsNeedUpdate = false;
    protected GuiButtonSortingMode buttonSortingMode = null;
    protected GuiButtonViewType buttonViewMode;
    private long cacheAmountSelected = -1L;
    private String cacheAmountDisplay = "0";
    private int previousOverflowRows = 0;
    private final AspectStackComparator stackComparator;
    private ViewItems viewMode = ViewItems.ALL;
    public IAspectStack selectedAspectStack;

    protected GuiEssentiaCellTerminal(EntityPlayer player, ContainerEssentiaCellTerminalBase container, String title) {
        super(container);
        this.baseContainer = container;
        this.player = player;
        this.field_146999_f = 195;
        this.field_147000_g = 204;
        this.guiTitle = title;
        this.selectedInfoNamePrefix = ThEStrings.Gui_SelectedAspect.getLocalized() + ": ";
        this.selectedInfoAmountPrefix = ThEStrings.Gui_SelectedAmount.getLocalized() + ": ";
        this.aspectWidgets = new WidgetAspectSelector[36];
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                WidgetAspectSelector widget;
                this.aspectWidgets[y * 9 + x] = widget = new WidgetAspectSelector(this, null, 7 + x * ThEWidget.WIDGET_SIZE, 17 + y * ThEWidget.WIDGET_SIZE, player);
            }
        }
        this.stackComparator = new AspectStackComparator();
    }

    public static GuiEssentiaCellTerminal NewEssentiaCellGui(EntityPlayer player, World world, int x, int y, int z) {
        return new GuiEssentiaCellTerminal(player, new ContainerEssentiaCell(player, world, x, y, z), ThEStrings.Gui_TitleEssentiaCell.getLocalized());
    }

    public static GuiEssentiaCellTerminal NewEssentiaTerminalGui(PartEssentiaTerminal terminal, EntityPlayer player) {
        return new GuiEssentiaCellTerminal(player, new ContainerEssentiaTerminal(terminal, player), ThEStrings.Part_EssentiaTerminal.getLocalized());
    }

    public static GuiEssentiaCellTerminal NewWirelessEssentiaTerminalGui(EntityPlayer player) {
        if (player == null || player instanceof FakePlayer) {
            return null;
        }
        ItemStack wirelessTerminal = player.func_70694_bm();
        if (wirelessTerminal == null) {
            return null;
        }
        if (!(wirelessTerminal.func_77973_b() instanceof IThEWirelessEssentiaTerminal)) {
            return null;
        }
        IThEWirelessEssentiaTerminal terminalInterface = (IThEWirelessEssentiaTerminal)wirelessTerminal.func_77973_b();
        HandlerWirelessEssentiaTerminal handler = new HandlerWirelessEssentiaTerminal(player, null, terminalInterface, wirelessTerminal);
        return new GuiEssentiaCellTerminal(player, new ContainerWirelessEssentiaTerminal(player, handler), ThEStrings.Part_EssentiaTerminal.getLocalized());
    }

    private boolean isMouseOverWidgetArea(int mouseX, int mouseY) {
        return ThEGuiHelper.INSTANCE.isPointInGuiRegion(17, 7, 4 * ThEWidget.WIDGET_SIZE, 9 * ThEWidget.WIDGET_SIZE, mouseX, mouseY, this.field_147003_i, this.field_147009_r);
    }

    private void onListUpdate() {
        this.updateScrollMaximum();
        this.updateView();
        this.updateSelectedAspect();
        this.flagWidgetsNeedUpdate = true;
    }

    private void updateScrollMaximum() {
        double overflowWidgets = Math.max(0, this.matchingSearchStacks.size() - 36);
        int overflowRows = (int)Math.ceil(overflowWidgets / 9.0);
        if (overflowRows != this.previousOverflowRows) {
            this.scrollBar.setRange(0, overflowRows, 1);
            this.onScrollbarMoved();
            this.previousOverflowRows = overflowRows;
        }
        this.flagWidgetsNeedUpdate = true;
    }

    private void updateSelectedAspect() {
        this.selectedAspectStack = null;
        for (IAspectStack aspectStack : this.baseContainer.getAspectStackList()) {
            if (aspectStack.getAspect() != this.baseContainer.getSelectedAspect()) continue;
            this.selectedAspectStack = aspectStack;
            return;
        }
    }

    private void updateView() {
        this.matchingSearchStacks.clear();
        Collection<IAspectStack> stacks = this.baseContainer.getAspectStackList();
        boolean hideCraftable = this.viewMode == ViewItems.STORED;
        boolean hideStored = this.viewMode == ViewItems.CRAFTABLE;
        for (IAspectStack stack : stacks) {
            if (hideStored && !stack.getCraftable() || hideCraftable && stack.isEmpty() || this.searchTerm != "" && !stack.getAspectName().contains(this.searchTerm) && !stack.getAspectTag().contains(this.searchTerm)) continue;
            this.matchingSearchStacks.add(stack);
        }
        this.stackComparator.setMode(this.sortMode);
        Collections.sort(this.matchingSearchStacks, this.stackComparator);
        this.updateScrollMaximum();
        this.flagWidgetsNeedUpdate = true;
    }

    private void updateWidgets() {
        int numberOfSearchMatches = this.matchingSearchStacks.size();
        int rowOffset = this.currentScroll * 9;
        int matchIndex = -1;
        for (int widgetIndex = 0; widgetIndex < this.aspectWidgets.length; ++widgetIndex) {
            matchIndex = widgetIndex + rowOffset;
            if (matchIndex >= numberOfSearchMatches) {
                this.aspectWidgets[widgetIndex].clearWidget();
                continue;
            }
            this.aspectWidgets[widgetIndex].setAspect(this.matchingSearchStacks.get(matchIndex));
            this.aspectWidgets[widgetIndex].setHideAmount(this.viewMode == ViewItems.CRAFTABLE);
        }
        this.flagWidgetsNeedUpdate = false;
    }

    protected void func_146976_a(float alpha, int sizeX, int sizeY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_TERMINAL.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.searchBar.func_146194_f();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 7, 6, 0);
        this.drawWidgets(mouseX, mouseY);
        if (this.selectedAspectStack != null) {
            if (this.selectedAspectStack.getStackSize() != this.cacheAmountSelected) {
                this.cacheAmountDisplay = Long.toString(this.selectedAspectStack.getStackSize());
                this.cacheAmountSelected = this.selectedAspectStack.getStackSize();
            }
            String aspectName = this.selectedAspectStack.getAspectName(this.player);
            this.field_146289_q.func_78276_b(this.selectedInfoNamePrefix + aspectName, 45, 91, 0);
            this.field_146289_q.func_78276_b(this.selectedInfoAmountPrefix + this.cacheAmountDisplay, 45, 101, 0);
        }
    }

    @Override
    protected ThEScrollbarGui.ScrollbarParams getScrollbarParameters() {
        return new ThEScrollbarGui.ScrollbarParams(this, 175, 18, 70);
    }

    @Override
    protected void func_73869_a(char key, int keyID) {
        this.searchBar.func_146201_a(key, keyID);
        if (keyID == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (this.searchBar.func_146206_l()) {
            this.searchTerm = this.searchBar.func_146179_b().trim().toLowerCase();
            this.updateView();
        } else if (!Character.isDigit(key)) {
            super.func_73869_a(key, keyID);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        boolean mouseOverSearchBar;
        boolean isMiddleClick;
        boolean isLeftClick = mouseBtn == 0;
        boolean isRightClick = mouseBtn == 1;
        boolean bl = isMiddleClick = mouseBtn == 2;
        if (this.isMouseOverWidgetArea(mouseX, mouseY)) {
            boolean viewingCraftable = this.viewMode == ViewItems.CRAFTABLE;
            boolean playerHoldingItem = this.player.field_71071_by.func_70445_o() != null;
            for (WidgetAspectSelector widget : this.aspectWidgets) {
                if (!widget.isMouseOverWidget(mouseX, mouseY)) continue;
                if (playerHoldingItem) {
                    Packet_S_EssentiaCellTerminal.sendInteractWithHeldItem(this.player, widget.getAspect());
                } else {
                    if (!isRightClick && widget.hasAspect() && widget.getCraftable() && (viewingCraftable || isMiddleClick || isLeftClick && widget.getAmount() == 0L)) {
                        Packet_S_EssentiaCellTerminal.sendAutoCraft(this.player, widget.getAspect());
                    }
                    widget.onMouseClicked();
                }
                return;
            }
        }
        boolean bl2 = mouseOverSearchBar = mouseX >= this.searchBar.field_146209_f && mouseX < this.searchBar.field_146209_f + this.searchBar.field_146218_h && mouseY >= this.searchBar.field_146210_g && mouseY < this.searchBar.field_146210_g + this.searchBar.field_146219_i;
        if (mouseOverSearchBar) {
            if (isLeftClick) {
                this.searchBar.func_146192_a(mouseX, mouseY, mouseBtn);
                return;
            }
            if (isRightClick) {
                this.searchTerm = "";
                this.searchBar.func_146180_a(this.searchTerm);
                this.updateView();
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseBtn);
    }

    @Override
    protected void onButtonClicked(GuiButton button, int mouseButton) {
        if (mouseButton == 2) {
            return;
        }
        if (button == this.buttonSortingMode) {
            Packet_S_EssentiaCellTerminal.sendChangeSorting(this.player, mouseButton == 1);
        } else if (button == this.buttonViewMode) {
            Packet_S_EssentiaCellTerminal.sendChangeView(this.player, mouseButton == 1);
        }
    }

    @Override
    protected void onMouseWheel(int deltaZ, int mouseX, int mouseY) {
        if (mouseX > this.field_147003_i + 195) {
            return;
        }
        if (!GuiScreen.func_146272_n()) {
            this.scrollBar.wheel(deltaZ);
            this.onScrollbarMoved();
        }
    }

    @Override
    protected void onScrollbarMoved() {
        this.currentScroll = this.scrollBar.getCurrentScroll();
        this.flagWidgetsNeedUpdate = true;
    }

    public void drawWidgets(int mouseX, int mouseY) {
        if (this.flagWidgetsNeedUpdate) {
            this.updateWidgets();
        }
        if (!this.matchingSearchStacks.isEmpty()) {
            WidgetAspectSelector widget;
            for (int widgetIndex = 0; widgetIndex < this.aspectWidgets.length && (widget = this.aspectWidgets[widgetIndex]).hasAspect(); ++widgetIndex) {
                widget.drawWidget();
                if (!this.tooltip.isEmpty() || !widget.isMouseOverWidget(mouseX, mouseY)) continue;
                widget.getTooltip(this.tooltip);
            }
        } else {
            this.currentScroll = 0;
        }
    }

    @Override
    public IAspectSelectorContainer getContainer() {
        return this.baseContainer;
    }

    @Override
    public Aspect getSelectedAspect() {
        return this.selectedAspectStack != null ? this.selectedAspectStack.getAspect() : null;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Mouse.getDWheel();
        Keyboard.enableRepeatEvents((boolean)true);
        this.onListUpdate();
        this.searchBar = new GuiTextField(this.field_146289_q, this.field_147003_i + 98, this.field_147009_r + 6, 69, 10);
        this.searchBar.func_146185_a(false);
        this.searchBar.func_146195_b(false);
        this.searchBar.func_146203_f(14);
        this.field_146292_n.clear();
        this.buttonSortingMode = new GuiButtonSortingMode(0, this.field_147003_i + -18, this.field_147009_r + 9, 16, 16);
        this.field_146292_n.add(this.buttonSortingMode);
        this.buttonViewMode = new GuiButtonViewType(1, this.field_147003_i + -18, this.field_147009_r + 29, 16, 16);
        this.field_146292_n.add(this.buttonViewMode);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void onReceiveAspectList(Collection<IAspectStack> aspectStackList) {
        this.baseContainer.onReceivedAspectList(aspectStackList);
        this.onListUpdate();
    }

    public void onReceiveAspectListChange(IAspectStack change) {
        this.baseContainer.onReceivedAspectListChange(change);
        this.onListUpdate();
    }

    public void onReceiveSelectedAspect(Aspect selectedAspect) {
        this.baseContainer.onReceivedSelectedAspect(selectedAspect);
        this.updateSelectedAspect();
    }

    public void onViewingModesChanged(AspectStackComparator.AspectStackComparatorMode sortMode, ViewItems viewMode) {
        this.sortMode = sortMode;
        this.buttonSortingMode.setSortMode(this.sortMode);
        this.viewMode = viewMode;
        this.buttonViewMode.setViewMode(this.viewMode);
        this.updateView();
    }

    public void onViewModeChanged(ViewItems mode) {
        this.viewMode = mode;
        this.updateView();
        this.flagWidgetsNeedUpdate = true;
    }
}

