/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.Binnie;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.SetList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class ComponentIndexerInventory<T>
extends ComponentInventory
implements IInventory {
    int indexerSize = -1;
    public int guiRefreshCounter = 0;
    List<ItemStack> indexerInventory = new SetList<ItemStack>();
    public List<Integer> sortedInventory = new SetList<Integer>();
    T sortingMode;
    boolean needsSorting = true;

    public ComponentIndexerInventory(Machine machine) {
        super(machine);
    }

    public int func_70302_i_() {
        if (this.indexerSize > 0) {
            return this.indexerSize + 1;
        }
        return this.indexerInventory.size() + 1;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.indexerInventory.size()) {
            return this.indexerInventory.get(index);
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (index >= 0) {
            ItemStack returnStack = this.func_70301_a(index).func_77946_l();
            this.func_70299_a(index, null);
            return returnStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        ++this.guiRefreshCounter;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (index >= 0 && index < this.indexerInventory.size()) {
            this.indexerInventory.set(index, itemStack);
        } else if (itemStack != null) {
            this.indexerInventory.add(itemStack);
        }
        this.needsSorting = true;
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void setMode(T mode) {
        this.sortingMode = mode;
        this.needsSorting = true;
    }

    public T getMode() {
        return this.sortingMode;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList indexerNBT = new NBTTagList();
        for (ItemStack item : this.indexerInventory) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            item.func_77955_b(itemNBT);
            indexerNBT.func_74742_a((NBTBase)itemNBT);
        }
        nbttagcompound.func_74782_a("indexer", (NBTBase)indexerNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList indexerNBT = nbttagcompound.func_150295_c("indexer", 10);
        this.indexerInventory.clear();
        for (int i = 0; i < indexerNBT.func_74745_c(); ++i) {
            NBTTagCompound itemNBT = indexerNBT.func_150305_b(i);
            this.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)itemNBT));
        }
        this.needsSorting = true;
        this.func_70296_d();
    }

    public abstract void Sort();

    public static class ComponentApiaristIndexerInventory
    extends ComponentIndexerInventory<Mode>
    implements IInventory {
        public ComponentApiaristIndexerInventory(Machine machine) {
            super(machine);
        }

        @Override
        public void Sort() {
            int i = 0;
            while (i < this.indexerInventory.size()) {
                if (this.indexerInventory.get(i) == null) {
                    this.indexerInventory.remove(i);
                    continue;
                }
                ++i;
            }
            if (!this.needsSorting) {
                return;
            }
            this.needsSorting = false;
            ++this.guiRefreshCounter;
            block0 : switch ((Mode)((Object)this.sortingMode)) {
                case Species: 
                case Type: {
                    class SpeciesList {
                        public List<Integer> drones = new ArrayList<Integer>();
                        public List<Integer> queens = new ArrayList<Integer>();
                        public List<Integer> princesses = new ArrayList<Integer>();
                        public List<ItemStack> bees = new ArrayList<ItemStack>();

                        SpeciesList() {
                        }

                        public void add(ItemStack stack) {
                            this.bees.add(stack);
                        }
                    }
                    HashMap<Integer, SpeciesList> speciesList = new HashMap<Integer, SpeciesList>();
                    for (ItemStack itemStack : this.indexerInventory) {
                        int species = itemStack.func_77960_j();
                        if (!speciesList.containsKey(species)) {
                            speciesList.put(species, new SpeciesList());
                        }
                        ((SpeciesList)speciesList.get(species)).add(itemStack);
                    }
                    for (SpeciesList sortableList : speciesList.values()) {
                        for (ItemStack beeStack : sortableList.bees) {
                            if (Binnie.Genetics.getBeeRoot().isDrone(beeStack)) {
                                sortableList.drones.add(this.indexerInventory.indexOf(beeStack));
                                continue;
                            }
                            if (Binnie.Genetics.getBeeRoot().isMated(beeStack)) {
                                sortableList.queens.add(this.indexerInventory.indexOf(beeStack));
                                continue;
                            }
                            sortableList.princesses.add(this.indexerInventory.indexOf(beeStack));
                        }
                    }
                    this.sortedInventory = new SetList();
                    switch ((Mode)((Object)this.sortingMode)) {
                        case Species: {
                            for (int i2 = 0; i2 < 1024; ++i2) {
                                if (!speciesList.containsKey(i2)) continue;
                                this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)Integer.valueOf((int)i2))).queens);
                                this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)Integer.valueOf((int)i2))).princesses);
                                this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)Integer.valueOf((int)i2))).drones);
                            }
                            break block0;
                        }
                        case Type: {
                            int i3;
                            for (i3 = 0; i3 < 1024; ++i3) {
                                if (!speciesList.containsKey(i3)) continue;
                                this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)Integer.valueOf((int)i3))).queens);
                            }
                            for (i3 = 0; i3 < 1024; ++i3) {
                                if (!speciesList.containsKey(i3)) continue;
                                this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)Integer.valueOf((int)i3))).princesses);
                            }
                            for (i3 = 0; i3 < 1024; ++i3) {
                                if (!speciesList.containsKey(i3)) continue;
                                this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)Integer.valueOf((int)i3))).drones);
                            }
                            break block0;
                        }
                    }
                    break;
                }
                default: {
                    this.sortedInventory.clear();
                    for (i = 0; i < this.indexerInventory.size(); ++i) {
                        this.sortedInventory.add(i);
                    }
                }
            }
        }

        public boolean func_145818_k_() {
            return false;
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return true;
        }

        public static enum Mode {
            None,
            Species,
            Type;

        }
    }
}

