/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.Binnie;
import binnie.core.util.UniqueItemStackSet;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.minecraft.control.ControlItemDisplay;
import binnie.genetics.gui.AnalystPageProduce;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.ISpeciesRoot;
import forestry.arboriculture.FruitProviderPod;
import java.lang.reflect.Field;
import java.util.Collection;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class AnalystPageFruit
extends AnalystPageProduce {
    public AnalystPageFruit(IWidget parent, IArea area, ITree ind) {
        super(parent, area);
        this.setColour(0xCC3300);
        ITreeGenome genome = ind.getGenome();
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nFruit").setColour(this.getColour());
        new ControlTextCentered((IWidget)this, y += 12, "\u00a7oYield: " + Binnie.Genetics.treeBreedingSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.YIELD, ind.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD))).setColour(this.getColour());
        y += 20;
        UniqueItemStackSet products = new UniqueItemStackSet();
        UniqueItemStackSet specialties = new UniqueItemStackSet();
        UniqueItemStackSet wiid = new UniqueItemStackSet();
        for (ItemStack stack : ind.getProduceList()) {
            products.add(stack);
        }
        for (ItemStack stack : ind.getSpecialtyList()) {
            specialties.add(stack);
        }
        try {
            if (ind.getGenome().getFruitProvider() instanceof FruitProviderPod) {
                FruitProviderPod pod = (FruitProviderPod)ind.getGenome().getFruitProvider();
                Field f = FruitProviderPod.class.getDeclaredField("drop");
                f.setAccessible(true);
                for (ItemStack stack : (ItemStack[])f.get(pod)) {
                    products.add(stack);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (products.size() > 0) {
            new ControlTextCentered((IWidget)this, y, "Natural Fruit").setColour(this.getColour());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : products) {
                ControlItemDisplay d = new ControlItemDisplay(this, (this.w() - (float)w) / 2.0f + (float)(18 * i), y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        if (specialties.size() > 0) {
            new ControlTextCentered((IWidget)this, y, "Specialty Fruit").setColour(this.getColour());
            y += 10;
            int w = products.size() * 18 - 2;
            int i = 0;
            for (ItemStack stack : specialties) {
                ControlItemDisplay d = new ControlItemDisplay(this, (this.w() - (float)w) / 2.0f + (float)(18 * i), y);
                d.setTooltip();
                d.setItemStack(stack);
            }
            y += 26;
        }
        UniqueItemStackSet allProducts = new UniqueItemStackSet();
        for (ItemStack stack : products) {
            allProducts.add(stack);
        }
        for (ItemStack stack : specialties) {
            allProducts.add(stack);
        }
        UniqueItemStackSet refinedProducts = new UniqueItemStackSet();
        refinedProducts.addAll(this.getAllProductsAndFluids(allProducts));
        if (refinedProducts.size() > 0) {
            y = this.getRefined("Refined Products", y, refinedProducts);
            y += 8;
        }
        if (products.size() == 0 && specialties.size() == 0) {
            new ControlTextCentered((IWidget)this, y, "This tree has no \nfruits or nuts").setColour(this.getColour());
            y += 28;
        }
        new ControlTextCentered((IWidget)this, y, "Possible Fruits").setColour(this.getColour());
        y += 12;
        Collection fruitAlleles = Binnie.Genetics.getChromosomeMap((ISpeciesRoot)Binnie.Genetics.getTreeRoot()).get(EnumTreeChromosome.FRUITS);
        for (IFruitFamily fam : ind.getGenome().getPrimary().getSuitableFruit()) {
            UniqueItemStackSet stacks = new UniqueItemStackSet();
            for (IAllele a : fruitAlleles) {
                if (((IAlleleFruit)a).getProvider().getFamily() != fam) continue;
                for (ItemStack p : ((IAlleleFruit)a).getProvider().getProducts()) {
                    stacks.add(p);
                }
                for (ItemStack p : ((IAlleleFruit)a).getProvider().getSpecialty()) {
                    stacks.add(p);
                }
                try {
                    if (a.getUID().contains("fruitCocoa")) {
                        stacks.add(new ItemStack(Items.field_151100_aR, 1, 3));
                        continue;
                    }
                    if (!(((IAlleleFruit)a).getProvider() instanceof FruitProviderPod)) continue;
                    FruitProviderPod pod = (FruitProviderPod)((IAlleleFruit)a).getProvider();
                    Field field = FruitProviderPod.class.getDeclaredField("drop");
                    field.setAccessible(true);
                    for (ItemStack stack : (ItemStack[])field.get(pod)) {
                        stacks.add(stack);
                    }
                }
                catch (Exception e) {
                }
            }
            y = this.getRefined("\u00a7o" + fam.getName(), y, stacks);
            y += 2;
        }
        this.setSize(new IPoint(this.w(), y + 8));
    }

    @Override
    public String getTitle() {
        return "Fruit";
    }
}

