/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui;

import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.api.IFlower;
import binnie.core.genetics.Tolerance;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.ControlTextCentered;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPoint;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.genetics.gui.ControlAnalystPage;
import binnie.genetics.gui.ControlBiome;
import binnie.genetics.gui.ControlToleranceBar;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBee;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IButterfly;
import java.util.ArrayList;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class AnalystPageClimate
extends ControlAnalystPage {
    public AnalystPageClimate(IWidget parent, IArea area, IIndividual ind) {
        super(parent, area);
        this.setColour(26163);
        EnumTemperature temp = ind.getGenome().getPrimary().getTemperature();
        EnumTolerance tempTol = EnumTolerance.NONE;
        EnumHumidity humid = ind.getGenome().getPrimary().getHumidity();
        EnumTolerance humidTol = EnumTolerance.NONE;
        if (ind instanceof IBee) {
            tempTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.TEMPERATURE_TOLERANCE)).getValue();
            humidTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumBeeChromosome.HUMIDITY_TOLERANCE)).getValue();
        }
        if (ind instanceof IFlower) {
            tempTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumFlowerChromosome.TEMPERATURE_TOLERANCE)).getValue();
            humidTol = EnumTolerance.BOTH_5;
        }
        if (ind instanceof IButterfly) {
            tempTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.TEMPERATURE_TOLERANCE)).getValue();
            humidTol = ((IAlleleTolerance)ind.getGenome().getActiveAllele((IChromosomeType)EnumButterflyChromosome.HUMIDITY_TOLERANCE)).getValue();
        }
        int y = 4;
        new ControlTextCentered((IWidget)this, y, "\u00a7nClimate").setColour(this.getColour());
        new ControlText(this, new IArea(4.0f, y += 16, this.w() - 8.0f, 14.0f), "Temp. Tolerance", TextJustification.MiddleCenter).setColour(this.getColour());
        this.createTemperatureBar(this, (this.w() - 100.0f) / 2.0f, y += 12, 100.0f, 10.0f, temp, tempTol);
        y += 16;
        if (!(ind instanceof IFlower)) {
            new ControlText(this, new IArea(4.0f, y, this.w() - 8.0f, 14.0f), "Humidity Tolerance", TextJustification.MiddleCenter).setColour(this.getColour());
            this.createHumidity(this, (this.w() - 100.0f) / 2.0f, y += 12, 100.0f, 10.0f, humid, humidTol);
            y += 16;
        }
        new ControlText(this, new IArea(4.0f, y, this.w() - 8.0f, 14.0f), "Biomes", TextJustification.MiddleCenter).setColour(this.getColour());
        y += 12;
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
            if (biome == null || !BiomeDictionary.isBiomeRegistered((BiomeGenBase)biome) || biome == BiomeGenBase.field_76776_l || !Tolerance.canTolerate(temp, EnumTemperature.getFromBiome((BiomeGenBase)biome), tempTol) || !Tolerance.canTolerate(humid, EnumHumidity.getFromValue((float)biome.field_76751_G), humidTol)) continue;
            boolean match = false;
            for (BiomeGenBase eBiome : biomes) {
                if (!biome.field_76791_y.contains(eBiome.field_76791_y) || EnumHumidity.getFromValue((float)eBiome.field_76751_G) != EnumHumidity.getFromValue((float)biome.field_76751_G) || EnumTemperature.getFromBiome((BiomeGenBase)eBiome) != EnumTemperature.getFromBiome((BiomeGenBase)biome)) continue;
                match = true;
            }
            if (match) continue;
            biomes.add(biome);
        }
        int maxBiomePerLine = (int)((this.w() + 2.0f - 16.0f) / 18.0f);
        float biomeListX = (this.w() - (float)(Math.min(maxBiomePerLine, biomes.size()) * 18 - 2)) / 2.0f;
        int dx = 0;
        int dy = 0;
        for (BiomeGenBase biome : biomes) {
            new ControlBiome(this, biomeListX + (float)dx, y + dy, 16.0f, 16.0f, biome);
            if ((dx += 18) < 18 * maxBiomePerLine) continue;
            dx = 0;
            dy += 18;
        }
        this.setSize(new IPoint(this.w(), y + dy + 18 + 8));
    }

    protected void createTemperatureBar(IWidget parent, float x, float y, float w, float h, EnumTemperature value, EnumTolerance tol) {
        new ControlToleranceBar<EnumTemperature>(parent, x, y, w, h, EnumTemperature.class){

            @Override
            protected String getName(EnumTemperature value) {
                return value.name;
            }

            @Override
            protected int getColour(EnumTemperature value) {
                return (new int[]{65531, 7912447, 5242672, 0xFFFF00, 16753152, 0xFF0000})[value.ordinal() - 1];
            }
        }.setValues(value, tol);
    }

    protected void createHumidity(IWidget parent, float x, float y, float w, float h, EnumHumidity value, EnumTolerance tol) {
        new ControlToleranceBar<EnumHumidity>(parent, x, y, w, h, EnumHumidity.class){

            @Override
            protected String getName(EnumHumidity value) {
                return value.name;
            }

            @Override
            protected int getColour(EnumHumidity value) {
                return (new int[]{16770979, 1769216, 3177727})[value.ordinal()];
            }
        }.setValues(value, tol);
    }

    @Override
    public String getTitle() {
        return "Climate";
    }
}

