/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class Press {
    public static int slotFruit = 0;
    public static int slotCurrent = 1;
    public static int tankWater = 0;
    private static Map<ItemStack, FluidStack> pressRecipes = new HashMap<ItemStack, FluidStack>();

    public static boolean isInput(ItemStack itemstack) {
        return Press.getOutput(itemstack) != null;
    }

    public static FluidStack getOutput(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        for (Map.Entry<ItemStack, FluidStack> entry : pressRecipes.entrySet()) {
            if (!itemstack.func_77969_a(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addRecipe(ItemStack stack, FluidStack fluid) {
        if (Press.getOutput(stack) != null) {
            return;
        }
        pressRecipes.put(stack, fluid);
    }

    public static class SlotValidatorSqueezable
    extends SlotValidator {
        public SlotValidatorSqueezable() {
            super(SlotValidator.IconBlock);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return Press.isInput(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Fruit";
        }
    }

    public static class ComponentFruitPressLogic
    extends ComponentProcessSetCost
    implements IProcess {
        int lastProgress = 0;

        public ComponentFruitPressLogic(Machine machine) {
            super(machine, 1000, 50);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(slotCurrent)) {
                return new ErrorState.NoItem("No Fruit", slotCurrent);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!this.getUtil().spaceInTank(tankWater, 5)) {
                return new ErrorState.TankSpace("No room in tank", tankWater);
            }
            if (this.getUtil().getFluid(tankWater) != null && !this.getUtil().getFluid(tankWater).isFluidEqual(Press.getOutput(this.getUtil().getStack(slotCurrent)))) {
                return new ErrorState.TankSpace("Different fluid in tank", tankWater);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            this.getUtil().decreaseStack(slotCurrent, 1);
        }

        @Override
        protected void onTickTask() {
        }

        @Override
        public void onUpdate() {
            super.onUpdate();
            FluidStack output = Press.getOutput(this.getUtil().getStack(slotCurrent));
            if (output == null) {
                return;
            }
            int newProgress = (int)this.getProgress();
            while (this.lastProgress + 4 <= newProgress) {
                int change = newProgress - this.lastProgress;
                int amount = output.amount * change / 100;
                FluidStack tank = new FluidStack(output, amount);
                this.getUtil().fillTank(tankWater, tank);
                this.lastProgress += 4;
            }
            if (this.lastProgress > newProgress) {
                this.lastProgress = 0;
            }
        }

        @Override
        protected void onStartTask() {
            super.onStartTask();
            this.lastProgress = 0;
        }
    }

    public static class PackagePress
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackagePress() {
            super("press", ExtraTreeTexture.pressTexture, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Press);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotFruit, "input");
            inventory.getSlot(slotFruit).setValidator((Validator)new SlotValidatorSqueezable());
            inventory.getSlot(slotFruit).forbidExtraction();
            inventory.addSlot(slotCurrent, "process");
            inventory.getSlot(slotCurrent).setValidator((Validator)new SlotValidatorSqueezable());
            inventory.getSlot(slotCurrent).forbidInteraction();
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(tankWater, "output", 5000);
            new ComponentPowerReceptor(machine);
            new ComponentInventoryTransfer(machine).addRestock(new int[]{slotFruit}, slotCurrent, 1);
            new ComponentFruitPressLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

