/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.WorldGenTree;
import forestry.api.arboriculture.ITree;

public class WorldGenApple {

    public static class PrairieCrabapple
    extends WorldGenTree {
        public PrairieCrabapple(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            int leafSpawn = this.height;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.5f, 1, this.leaf, false);
            while (leafSpawn > 3) {
                this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 3.0f, 1, this.leaf, false);
            }
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 3.0f, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.0f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 4);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class FloweringCrabapple
    extends WorldGenTree {
        public FloweringCrabapple(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            int leafSpawn = this.height;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 3.0f, 1, this.leaf, false);
            while (leafSpawn > 3) {
                this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, this.leaf, false);
            }
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.0f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(3, 6);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class SweetCrabapple
    extends WorldGenTree {
        public SweetCrabapple(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            int leafSpawn = this.height;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.5f, 1, this.leaf, false);
            while (leafSpawn > 3) {
                this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 3.0f, 1, this.leaf, false);
            }
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 3.5f, 1, this.leaf, false);
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(4, 4);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }

    public static class OrchardApple
    extends WorldGenTree {
        public OrchardApple(ITree tree) {
            super(tree);
        }

        @Override
        public void generate() {
            this.generateTreeTrunk(this.height, this.girth);
            int leafSpawn = this.height;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
            while (leafSpawn > 2) {
                this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.5f, 1, this.leaf, false);
            }
            this.generateCylinder(new WorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), 2.0f, 1, this.leaf, false);
        }

        @Override
        public void preGenerate() {
            this.height = this.determineHeight(3, 6);
            this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
        }
    }
}

