/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.apiary;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.TileEntityMachine;
import binnie.extrabees.apiary.machine.AlvearyMachine;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.core.IStructureLogic;
import forestry.api.core.ITileStructure;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileExtraBeeAlveary
extends TileEntityMachine
implements IAlvearyComponent,
IBeeModifier,
IBeeListener {
    boolean init = false;
    IStructureLogic structureLogic;
    private boolean isMaster;
    protected int masterX;
    protected int masterZ;
    protected int masterY = -99;
    List<TileEntity> tiles = new ArrayList<TileEntity>();

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!BinnieCore.proxy.isSimulating(this.field_145850_b)) {
            return;
        }
        if (this.field_145850_b.func_72820_D() % 200L == 0L) {
            ITileStructure master;
            if (!this.isIntegratedIntoStructure() || this.isMaster()) {
                this.validateStructure();
            }
            if ((master = this.getCentralTE()) == null) {
                return;
            }
            if (this.getBeeListener() != null) {
                ((IAlvearyComponent)master).registerBeeListener(this.getBeeListener());
            }
            if (this.getBeeModifier() != null) {
                ((IAlvearyComponent)master).registerBeeModifier(this.getBeeModifier());
            }
            this.init = true;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.isMaster = nbttagcompound.func_74767_n("IsMaster");
        this.masterX = nbttagcompound.func_74762_e("MasterX");
        this.masterY = nbttagcompound.func_74762_e("MasterY");
        this.masterZ = nbttagcompound.func_74762_e("MasterZ");
        if (this.isMaster) {
            this.makeMaster();
        }
        this.structureLogic.readFromNBT(nbttagcompound);
        this.updateAlvearyBlocks();
        this.init = false;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsMaster", this.isMaster);
        nbttagcompound.func_74768_a("MasterX", this.masterX);
        nbttagcompound.func_74768_a("MasterY", this.masterY);
        nbttagcompound.func_74768_a("MasterZ", this.masterZ);
        this.structureLogic.writeToNBT(nbttagcompound);
    }

    AlvearyMachine.AlvearyPackage getAlvearyPackage() {
        return (AlvearyMachine.AlvearyPackage)this.getMachine().getPackage();
    }

    public TileExtraBeeAlveary() {
        this.structureLogic = Binnie.Genetics.getBeeRoot().createAlvearyStructureLogic((IAlvearyComponent)this);
    }

    public TileExtraBeeAlveary(AlvearyMachine.AlvearyPackage alvearyPackage) {
        super(alvearyPackage);
        this.structureLogic = Binnie.Genetics.getBeeRoot().createAlvearyStructureLogic((IAlvearyComponent)this);
    }

    public String getTypeUID() {
        return this.structureLogic.getTypeUID();
    }

    public void makeMaster() {
    }

    public void onStructureReset() {
        this.setCentralTE(null);
        this.isMaster = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.updateAlvearyBlocks();
    }

    public ITileStructure getCentralTE() {
        if (this.field_145850_b == null || !this.isIntegratedIntoStructure()) {
            return null;
        }
        if (!this.isMaster()) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
            if (tile instanceof ITileStructure) {
                ITileStructure master = (ITileStructure)this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ);
                if (master.isMaster()) {
                    return master;
                }
                return null;
            }
            return null;
        }
        return this;
    }

    public void validateStructure() {
        this.structureLogic.validateStructure();
        this.updateAlvearyBlocks();
    }

    private boolean isSameTile(TileEntity tile) {
        return tile.field_145851_c == this.field_145851_c && tile.field_145848_d == this.field_145848_d && tile.field_145849_e == this.field_145849_e;
    }

    public void setCentralTE(TileEntity tile) {
        if (tile == null || tile == this || this.isSameTile(tile)) {
            this.masterZ = 0;
            this.masterX = 0;
            this.masterY = -99;
            this.updateAlvearyBlocks();
            return;
        }
        this.isMaster = false;
        this.masterX = tile.field_145851_c;
        this.masterY = tile.field_145848_d;
        this.masterZ = tile.field_145849_e;
        this.func_70296_d();
        if (this.getBeeListener() != null) {
            ((IAlvearyComponent)tile).registerBeeListener(this.getBeeListener());
        }
        if (this.getBeeModifier() != null) {
            ((IAlvearyComponent)tile).registerBeeModifier(this.getBeeModifier());
        }
        this.updateAlvearyBlocks();
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    protected boolean hasMaster() {
        return this.masterY >= 0;
    }

    public boolean isIntegratedIntoStructure() {
        return this.isMaster || this.masterY >= 0;
    }

    public void registerBeeModifier(IBeeModifier modifier) {
    }

    public void removeBeeModifier(IBeeModifier modifier) {
    }

    public void addTemperatureChange(float change, float boundaryDown, float boundaryUp) {
    }

    public void addHumidityChange(float change, float boundaryDown, float boundaryUp) {
    }

    public boolean hasFunction() {
        return true;
    }

    public IBeeModifier getBeeModifier() {
        return this.getMachine().getInterface(IBeeModifier.class);
    }

    public IBeeListener getBeeListener() {
        return this.getMachine().getInterface(IBeeListener.class);
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getTerritoryModifier(genome, currentModifier);
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getMutationModifier(genome, mate, currentModifier);
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getLifespanModifier(genome, mate, currentModifier);
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getProductionModifier(genome, currentModifier);
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return this.getBeeModifier() == null ? 1.0f : this.getBeeModifier().getFloweringModifier(genome, currentModifier);
    }

    public boolean isSealed() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isSealed();
    }

    public boolean isSelfLighted() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isSelfLighted();
    }

    public boolean isSunlightSimulated() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isSunlightSimulated();
    }

    public boolean isHellish() {
        return this.getBeeModifier() == null ? false : this.getBeeModifier().isHellish();
    }

    public void registerBeeListener(IBeeListener event) {
    }

    public void removeBeeListener(IBeeListener event) {
    }

    public void onQueenChange(ItemStack queen) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onQueenChange(queen);
        }
    }

    public void wearOutEquipment(int amount) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().wearOutEquipment(amount);
        }
    }

    public void onQueenDeath(IBee queen) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onQueenDeath(queen);
        }
    }

    public void onPostQueenDeath(IBee queen) {
        if (this.getBeeListener() != null) {
            this.getBeeListener().onPostQueenDeath(queen);
        }
    }

    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    public boolean onEggLaid(IBee queen) {
        return false;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    public IBeeHousing getBeeHousing() {
        return this.getCentralTE() == null ? null : (IBeeHousing)this.getCentralTE();
    }

    public List<TileEntity> getAlvearyBlocks() {
        this.updateAlvearyBlocks();
        return this.tiles;
    }

    private void updateAlvearyBlocks() {
        this.tiles.clear();
        if (this.getCentralTE() != null) {
            ITileStructure struct = this.getCentralTE();
            if (!struct.isIntegratedIntoStructure()) {
                return;
            }
            TileEntity central = (TileEntity)struct;
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    for (int y = -2; y <= 2; ++y) {
                        TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z);
                        if (tile == null || !(tile instanceof ITileStructure) || ((ITileStructure)tile).getCentralTE() != struct) continue;
                        this.tiles.add(tile);
                    }
                }
            }
        }
    }

    public ISidedInventory getStructureInventory() {
        return this.getMachine().getInterface(ISidedInventory.class);
    }
}

