/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.machines.BlockMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.ItemMachine;
import binnie.core.machines.MachinePackage;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;

public class MachineGroup {
    private AbstractMod mod;
    private String blockName;
    private String uid;
    private Map<String, MachinePackage> packages = new LinkedHashMap<String, MachinePackage>();
    private Map<Integer, MachinePackage> packagesID = new LinkedHashMap<Integer, MachinePackage>();
    private BlockMachine block;
    public boolean customRenderer = true;
    private boolean renderedTileEntity = true;

    public MachineGroup(AbstractMod mod, String uid, String blockName, IMachineType[] types) {
        this.mod = mod;
        this.uid = uid;
        this.blockName = blockName;
        for (IMachineType type : types) {
            if (type.getPackageClass() == null || !type.isActive()) continue;
            try {
                MachinePackage pack = type.getPackageClass().newInstance();
                pack.assignMetadata(type.ordinal());
                pack.setActive(type.isActive());
                this.addPackage(pack);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create machine package " + type.toString(), e);
            }
        }
        Binnie.Machine.registerMachineGroup(this);
        this.block = new BlockMachine(this, blockName);
        if (this.block != null) {
            GameRegistry.registerBlock((Block)this.block, ItemMachine.class, (String)blockName);
            for (MachinePackage pack : this.getPackages()) {
                pack.register();
            }
        }
    }

    private void addPackage(MachinePackage pack) {
        this.packages.put(pack.getUID(), pack);
        this.packagesID.put(pack.getMetadata(), pack);
        pack.setGroup(this);
    }

    public Collection<MachinePackage> getPackages() {
        return this.packages.values();
    }

    public BlockMachine getBlock() {
        return this.block;
    }

    public MachinePackage getPackage(int metadata) {
        return this.packagesID.get(metadata);
    }

    public MachinePackage getPackage(String name) {
        return this.packages.get(name);
    }

    public String getUID() {
        return this.mod.getModID() + "." + this.uid;
    }

    public String getShortUID() {
        return this.uid;
    }

    boolean isTileEntityRenderered() {
        return this.renderedTileEntity;
    }

    public void renderAsBlock() {
        this.renderedTileEntity = false;
    }

    public void setCreativeTab(CreativeTabs tab) {
        this.block.func_149647_a(tab);
    }

    public AbstractMod getMod() {
        return this.mod;
    }
}

