/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import openmods.calc.IValueParser;
import openmods.calc.PositionalNotationParser;
import openmods.calc.Token;
import org.apache.commons.lang3.tuple.Pair;

public class DoubleParser
implements IValueParser<Double> {
    private static final PositionalNotationParser<Double> PARSER = new PositionalNotationParser<Double>(){

        public PositionalNotationParser.Accumulator<Double> createIntegerAccumulator(int radix) {
            final double doubleRadix = radix;
            return new PositionalNotationParser.Accumulator<Double>(){
                private double value = 0.0;

                @Override
                public void add(int digit) {
                    this.value = this.value * doubleRadix + (double)digit;
                }

                @Override
                public Double get() {
                    return this.value;
                }
            };
        }

        protected PositionalNotationParser.Accumulator<Double> createFractionalAccumulator(int radix) {
            final double inverseRadix = 1.0 / (double)radix;
            return new PositionalNotationParser.Accumulator<Double>(){
                private double value = 0.0;
                private double weight = inverseRadix;

                @Override
                public void add(int digit) {
                    this.value += (double)digit * this.weight;
                    this.weight *= inverseRadix;
                }

                @Override
                public Double get() {
                    return this.value;
                }
            };
        }
    };

    public Double parseToken(Token token) {
        Pair result = PARSER.parseToken(token);
        Double left = (Double)result.getLeft();
        Double right = (Double)result.getRight();
        return right != null ? left + right : left;
    }
}

