/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;

public class ChemthrowerHandler {
    public static HashMap<String, ChemthrowerEffect> effectMap = new HashMap();
    public static HashSet<String> flammableList = new HashSet();
    public static HashSet<String> gasList = new HashSet();

    public static void registerEffect(Fluid fluid, ChemthrowerEffect effect) {
        if (fluid != null) {
            ChemthrowerHandler.registerEffect(fluid.getName(), effect);
        }
    }

    public static void registerEffect(String fluidName, ChemthrowerEffect effect) {
        effectMap.put(fluidName, effect);
    }

    public static ChemthrowerEffect getEffect(Fluid fluid) {
        if (fluid != null) {
            return ChemthrowerHandler.getEffect(fluid.getName());
        }
        return null;
    }

    public static ChemthrowerEffect getEffect(String fluidName) {
        return effectMap.get(fluidName);
    }

    public static void registerFlammable(Fluid fluid) {
        if (fluid != null) {
            ChemthrowerHandler.registerFlammable(fluid.getName());
        }
    }

    public static void registerFlammable(String fluidName) {
        flammableList.add(fluidName);
    }

    public static boolean isFlammable(Fluid fluid) {
        if (fluid != null) {
            return flammableList.contains(fluid.getName());
        }
        return false;
    }

    public static boolean isFlammable(String fluidName) {
        return flammableList.contains(fluidName);
    }

    public static void registerGas(Fluid fluid) {
        if (fluid != null) {
            ChemthrowerHandler.registerGas(fluid.getName());
        }
    }

    public static void registerGas(String fluidName) {
        gasList.add(fluidName);
    }

    public static boolean isGas(Fluid fluid) {
        if (fluid != null) {
            return gasList.contains(fluid.getName());
        }
        return false;
    }

    public static boolean isGas(String fluidName) {
        return gasList.contains(fluidName);
    }

    public static class ChemthrowerEffect_Extinguish
    extends ChemthrowerEffect {
        @Override
        public void applyToEntity(EntityLivingBase target, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            if (target.func_70027_ad()) {
                target.func_70066_B();
            }
            if ((target instanceof EntityBlaze || target instanceof EntityEnderman) && target.func_70097_a(DamageSource.field_76369_e, 3.0f)) {
                target.field_70172_ad = (int)((double)target.field_70172_ad * 0.75);
            }
        }

        @Override
        public void applyToBlock(World worldObj, MovingObjectPosition mop, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            ForgeDirection fd = ForgeDirection.getOrientation((int)mop.field_72310_e);
            Block b = worldObj.func_147439_a(mop.field_72311_b + fd.offsetX, mop.field_72312_c + fd.offsetY, mop.field_72309_d + fd.offsetZ);
            if (b instanceof BlockFire) {
                worldObj.func_147468_f(mop.field_72311_b + fd.offsetX, mop.field_72312_c + fd.offsetY, mop.field_72309_d + fd.offsetZ);
            }
        }
    }

    public static class ChemthrowerEffect_Potion
    extends ChemthrowerEffect_Damage {
        PotionEffect[] potionEffects;
        float[] effectChances;

        public ChemthrowerEffect_Potion(DamageSource source, float damage, PotionEffect ... effects) {
            super(source, damage);
            this.potionEffects = effects;
            this.effectChances = new float[this.potionEffects.length];
            for (int i = 0; i < this.effectChances.length; ++i) {
                this.effectChances[i] = 1.0f;
            }
        }

        public ChemthrowerEffect_Potion(DamageSource source, float damage, Potion potion, int duration, int amplifier) {
            this(source, damage, new PotionEffect(potion.field_76415_H, duration, amplifier));
        }

        public ChemthrowerEffect_Potion setEffectChance(int effectIndex, float chance) {
            if (effectIndex >= 0 && effectIndex < this.effectChances.length) {
                this.effectChances[effectIndex] = chance;
            }
            return this;
        }

        @Override
        public void applyToEntity(EntityLivingBase target, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            super.applyToEntity(target, shooter, thrower, fluid);
            if (this.potionEffects != null && this.potionEffects.length > 0) {
                for (int iEffect = 0; iEffect < this.potionEffects.length; ++iEffect) {
                    if (!(target.func_70681_au().nextFloat() < this.effectChances[iEffect])) continue;
                    PotionEffect e = this.potionEffects[iEffect];
                    PotionEffect newEffect = new PotionEffect(e.func_76456_a(), e.func_76459_b(), e.func_76458_c());
                    newEffect.setCurativeItems(new ArrayList(e.getCurativeItems()));
                    target.func_70690_d(newEffect);
                }
            }
        }
    }

    public static class ChemthrowerEffect_Damage
    extends ChemthrowerEffect {
        DamageSource source;
        float damage;

        public ChemthrowerEffect_Damage(DamageSource source, float damage) {
            this.source = source;
            this.damage = damage;
        }

        @Override
        public void applyToEntity(EntityLivingBase target, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            if (this.source != null && target.func_70097_a(this.source, this.damage)) {
                target.field_70172_ad = (int)((double)target.field_70172_ad * 0.75);
                if (this.source.func_76347_k() && !target.func_70045_F()) {
                    target.func_70015_d(fluid.isGaseous() ? 2 : 5);
                }
            }
        }

        @Override
        public void applyToBlock(World worldObj, MovingObjectPosition mop, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
        }
    }

    public static abstract class ChemthrowerEffect {
        public abstract void applyToEntity(EntityLivingBase var1, EntityPlayer var2, ItemStack var3, Fluid var4);

        public abstract void applyToBlock(World var1, MovingObjectPosition var2, EntityPlayer var3, ItemStack var4, Fluid var5);
    }
}

