/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.biometweaker.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import me.superckl.api.superscript.util.ParameterTypes;
import me.superckl.biometweaker.common.handler.BiomeEventHandler;
import me.superckl.biometweaker.common.world.gen.feature.WorldGenDoublePlantBlank;
import me.superckl.biometweaker.config.Config;
import me.superckl.biometweaker.util.LogHelper;
import net.minecraft.block.Block;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.feature.WorldGenDoublePlant;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;

public class BiomeHelper {
    private static Field oceanTopBlock;
    private static Field oceanFillerBlock;
    private static Field grassColor;
    private static Field foliageColor;
    private static Field waterColor;
    private static Field fillerBlockMeta;
    private static Field biomeList;
    private static Field typeInfoList;
    private static Field typeList;
    private static Field biomes;
    private static Field isModded;
    private static Set<BiomeManager.BiomeType> logged;
    private static boolean loggedSpawn;
    private static boolean hasModded;

    public static JsonObject fillJsonObject(BiomeGenBase gen, int ... coords) {
        JsonObject object;
        BiomeHelper.checkFields();
        JsonObject obj = new JsonObject();
        obj.addProperty("ID", (Number)gen.field_76756_M);
        obj.addProperty("Name", gen.field_76791_y);
        obj.addProperty("Class", gen.getClass().getName());
        obj.addProperty("Color", (Number)gen.field_76790_z);
        obj.addProperty("Root Height", (Number)Float.valueOf(gen.field_76748_D));
        obj.addProperty("Height Variation", (Number)Float.valueOf(gen.field_76749_E));
        obj.addProperty("Top Block", gen.field_76752_A.delegate.name());
        obj.addProperty("Filler Block", gen.field_76753_B.delegate.name());
        try {
            int i = -1;
            boolean hasCoords = coords != null && coords.length == 3;
            int x = 0;
            int y = 0;
            int z = 0;
            if (hasCoords) {
                x = coords[0];
                y = coords[1];
                z = coords[2];
            }
            obj.addProperty("Grass Color", "" + (hasCoords ? Integer.valueOf(gen.func_150558_b(x, y, z)) : ((i = grassColor.getInt(gen)) == -1 ? "Not set. Check in-game." : Integer.valueOf(i))));
            obj.addProperty("Foliage Color", "" + (hasCoords ? Integer.valueOf(gen.func_150571_c(x, y, z)) : ((i = foliageColor.getInt(gen)) == -1 ? "Not set. Check in-game." : Integer.valueOf(i))));
            obj.addProperty("Water Color", "" + gen.getWaterColorMultiplier());
        }
        catch (Exception e) {
            LogHelper.error("Failed to retrieve inserted fields!");
            e.printStackTrace();
        }
        obj.addProperty("Temperature", (Number)Float.valueOf(gen.field_76750_F));
        obj.addProperty("Humidity", (Number)Float.valueOf(gen.field_76751_G));
        obj.addProperty("Water Tint", (Number)gen.field_76759_H);
        obj.addProperty("Enable Rain", Boolean.valueOf(gen.field_76765_S));
        obj.addProperty("Enable Snow", Boolean.valueOf(gen.field_76766_R));
        JsonArray array = new JsonArray();
        for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((BiomeGenBase)gen)) {
            array.add((JsonElement)new JsonPrimitive(type.toString()));
        }
        obj.add("Dictionary Types", (JsonElement)array);
        JsonObject managerWeights = new JsonObject();
        for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
            JsonArray subArray = new JsonArray();
            ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
            for (BiomeManager.BiomeEntry entry : entries) {
                if (entry.biome != gen) continue;
                subArray.add((JsonElement)new JsonPrimitive((Number)entry.field_76292_a));
            }
            if (subArray.size() <= 0) continue;
            managerWeights.add(type.name() + " Weights", (JsonElement)subArray);
        }
        obj.add("BiomeManager Entries", (JsonElement)managerWeights);
        array = new JsonArray();
        for (Object entity : gen.field_76762_K) {
            BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Creatures", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : gen.field_76761_J) {
            BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Monsters", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : gen.field_76755_L) {
            BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Water Creatures", (JsonElement)array);
        array = new JsonArray();
        for (Object entity : gen.field_82914_M) {
            BiomeGenBase.SpawnListEntry entry = (BiomeGenBase.SpawnListEntry)entity;
            object = new JsonObject();
            object.addProperty("Entity Class", entry.field_76300_b.getName());
            object.addProperty("Weight", (Number)entry.field_76292_a);
            object.addProperty("Min Group Count", (Number)entry.field_76301_c);
            object.addProperty("Max Group Count", (Number)entry.field_76299_d);
            array.add((JsonElement)object);
        }
        obj.add("Spawnable Cave Creatures", (JsonElement)array);
        obj.add("Spawn Biome", (JsonElement)new JsonPrimitive(Boolean.valueOf(WorldChunkManager.allowedBiomes.contains(gen))));
        obj.addProperty("Tweaked", Boolean.valueOf(Config.INSTANCE.getTweakedBiomes().contains(-1) || Config.INSTANCE.getTweakedBiomes().contains(gen.field_76756_M)));
        return obj;
    }

    public static void setBiomeProperty(String prop, JsonElement value, BiomeGenBase biome) throws Exception {
        BiomeHelper.checkFields();
        if (prop.equals("name")) {
            String toSet;
            biome.field_76791_y = toSet = (String)ParameterTypes.STRING.tryParse(value.getAsString());
        } else if (prop.equals("color")) {
            int toSet;
            biome.field_76790_z = toSet = value.getAsInt();
        } else if (prop.equals("height")) {
            float toSet;
            biome.field_76748_D = toSet = value.getAsFloat();
        } else if (prop.equals("heightVariation")) {
            float toSet;
            biome.field_76749_E = toSet = value.getAsFloat();
        } else if (prop.equals("topBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                biome.field_76752_A = block;
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("fillerBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                biome.field_76753_B = block;
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("temperature")) {
            float toSet;
            biome.field_76750_F = toSet = value.getAsFloat();
        } else if (prop.equals("humidity")) {
            float toSet;
            biome.field_76751_G = toSet = value.getAsFloat();
        } else if (prop.equals("waterTint")) {
            int toSet;
            biome.field_76759_H = toSet = value.getAsInt();
        } else if (prop.equals("enableRain")) {
            boolean toSet;
            biome.field_76765_S = toSet = value.getAsBoolean();
        } else if (prop.equals("enableSnow")) {
            boolean toSet;
            biome.field_76766_R = toSet = value.getAsBoolean();
        } else if (prop.equals("grassColor")) {
            int toSet = value.getAsInt();
            grassColor.set(biome, toSet);
        } else if (prop.equals("foliageColor")) {
            int toSet = value.getAsInt();
            foliageColor.set(biome, toSet);
        } else if (prop.equals("waterColor")) {
            int toSet = value.getAsInt();
            waterColor.set(biome, toSet);
        } else if (prop.equals("fillerBlockMeta")) {
            byte toSet = value.getAsByte();
            fillerBlockMeta.set(biome, toSet);
        } else if (prop.equals("topBlockMeta")) {
            biome.field_150604_aj = value.getAsInt();
        } else if (prop.equals("waterliliesPerChunk")) {
            BiomeEventHandler.getWaterlilyPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("treesPerChunk")) {
            BiomeEventHandler.getTreesPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("flowersPerChunk")) {
            BiomeEventHandler.getFlowersPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("grassPerChunk")) {
            BiomeEventHandler.getGrassPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("deadbushesPerChunk")) {
            BiomeEventHandler.getDeadBushPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("mushroomsPerChunk")) {
            BiomeEventHandler.getMushroomPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("reedsPerChunk")) {
            BiomeEventHandler.getReedsPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("cactiPerChunk")) {
            BiomeEventHandler.getCactiPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("sandPerChunk")) {
            BiomeEventHandler.getSandPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("clayPerChunk")) {
            BiomeEventHandler.getClayPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("bigMushroomsPerChunk")) {
            BiomeEventHandler.getBigMushroomsPerChunk().put(biome.field_76756_M, value.getAsInt());
        } else if (prop.equals("contiguousReplacement")) {
            BiomeEventHandler.getContigReplaces()[biome.field_76756_M] = value.getAsBoolean();
        } else if (prop.equals("genWeight")) {
            int weight = value.getAsInt();
            for (BiomeManager.BiomeType type : BiomeManager.BiomeType.values()) {
                ImmutableList entries = BiomeManager.getBiomes((BiomeManager.BiomeType)type);
                for (BiomeManager.BiomeEntry entry : entries) {
                    if (entry.biome.field_76756_M != biome.field_76756_M) continue;
                    entry.field_76292_a = weight;
                }
                if (type == BiomeManager.BiomeType.DESERT || logged.contains(type) || WeightedRandom.func_76272_a((Collection)entries) > 0) continue;
                LogHelper.warn("Sum of biome generation weights for type " + type + " is zero! This will cause Vanilla generation to crash! You have been warned!");
                logged.add(type);
            }
            BiomeHelper.modTypeLists();
        } else if (prop.equals("genVillages")) {
            if (value.getAsBoolean()) {
                BiomeManager.addVillageBiome((BiomeGenBase)biome, (boolean)true);
            } else {
                BiomeManager.removeVillageBiome((BiomeGenBase)biome);
            }
        } else if (prop.equals("genStrongholds")) {
            if (value.getAsBoolean()) {
                BiomeManager.removeStrongholdBiome((BiomeGenBase)biome);
            } else {
                BiomeManager.addStrongholdBiome((BiomeGenBase)biome);
            }
        } else if (prop.equals("isSpawnBiome")) {
            if (value.getAsBoolean()) {
                BiomeManager.addSpawnBiome((BiomeGenBase)biome);
            } else {
                BiomeManager.removeSpawnBiome((BiomeGenBase)biome);
                if (!loggedSpawn && WorldChunkManager.allowedBiomes.size() == 0) {
                    LogHelper.warn("Upon removal of biome " + biome.field_76756_M + " the allowed spawn list appears to be empty. If you aren't adding one later, this will cause a crash.");
                    loggedSpawn = true;
                }
            }
        } else if (prop.equals("genTallPlants")) {
            BiomeGenBase.field_150610_ae = value.getAsBoolean() ? new WorldGenDoublePlant() : new WorldGenDoublePlantBlank();
        } else if (prop.equals("oceanTopBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                oceanTopBlock.set(biome, block);
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else if (prop.equals("oceanFillerBlock")) {
            String blockName = (String)ParameterTypes.STRING.tryParse(value.getAsString());
            try {
                Block block = Block.func_149684_b((String)blockName);
                if (block == null) {
                    throw new IllegalArgumentException("Failed to find block " + blockName + "! Tweak will not be applied.");
                }
                oceanFillerBlock.set(biome, block);
            }
            catch (Exception e) {
                LogHelper.info("Failed to parse block: " + blockName);
            }
        } else {
            LogHelper.warn("Attempted to set property " + prop + " but corresponding property was not found for biomes. Value: " + value.getAsString());
        }
    }

    private static void checkFields() {
        try {
            if (oceanTopBlock == null) {
                oceanTopBlock = BiomeGenBase.class.getDeclaredField("oceanTopBlock");
            }
            if (oceanFillerBlock == null) {
                oceanFillerBlock = BiomeGenBase.class.getDeclaredField("oceanFillerBlock");
            }
            if (grassColor == null) {
                grassColor = BiomeGenBase.class.getDeclaredField("grassColor");
            }
            if (foliageColor == null) {
                foliageColor = BiomeGenBase.class.getDeclaredField("foliageColor");
            }
            if (waterColor == null) {
                waterColor = BiomeGenBase.class.getDeclaredField("waterColor");
            }
            if (fillerBlockMeta == null) {
                fillerBlockMeta = BiomeGenBase.class.getDeclaredField("fillerBlockMeta");
            }
            if (biomeList == null) {
                biomeList = BiomeDictionary.class.getDeclaredField("biomeList");
                biomeList.setAccessible(true);
            }
            if (typeInfoList == null) {
                typeInfoList = BiomeDictionary.class.getDeclaredField("typeInfoList");
                typeInfoList.setAccessible(true);
            }
            if (biomes == null) {
                biomes = BiomeManager.class.getDeclaredField("biomes");
                biomes.setAccessible(true);
            }
        }
        catch (Exception e) {
            LogHelper.error("Failed to find inserted fields!");
            e.printStackTrace();
        }
    }

    public static int callGrassColorEvent(int color, BiomeGenBase gen) {
        BiomeEvent.GetGrassColor e = new BiomeEvent.GetGrassColor(gen, color);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.newColor;
    }

    public static int callFoliageColorEvent(int color, BiomeGenBase gen) {
        BiomeEvent.GetFoliageColor e = new BiomeEvent.GetFoliageColor(gen, color);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.newColor;
    }

    public static int callWaterColorEvent(int color, BiomeGenBase gen) {
        BiomeEvent.GetWaterColor e = new BiomeEvent.GetWaterColor(gen, color);
        MinecraftForge.EVENT_BUS.post((Event)e);
        return e.newColor;
    }

    public static void modifyBiomeDicType(BiomeGenBase gen, BiomeDictionary.Type type, boolean remove) throws Exception {
        BiomeHelper.checkFields();
        if (gen == null) {
            return;
        }
        List[] listArray = (List[])typeInfoList.get(null);
        if (listArray.length > type.ordinal()) {
            List list = listArray[type.ordinal()];
            if (list == null) {
                listArray[type.ordinal()] = list = Lists.newArrayList();
            }
            if (remove) {
                list.remove(gen);
            } else if (!list.contains(gen)) {
                list.add(gen);
            }
        }
        Object array = biomeList.get(null);
        Object biomeInfo = Array.get(array, gen.field_76756_M);
        if (typeList == null) {
            typeList = biomeInfo.getClass().getDeclaredField("typeList");
            typeList.setAccessible(true);
        }
        EnumSet set = (EnumSet)typeList.get(biomeInfo);
        if (remove) {
            set.remove(type);
        } else if (!set.contains(type)) {
            EnumSet<BiomeDictionary.Type> set2 = EnumSet.noneOf(BiomeDictionary.Type.class);
            set2.addAll(set);
            set2.add(type);
            typeList.set(biomeInfo, set2);
        }
    }

    public static void removeAllBiomeDicType(BiomeGenBase gen) throws Exception {
        BiomeHelper.checkFields();
        if (gen == null) {
            return;
        }
        Object array = biomeList.get(null);
        Object biomeInfo = Array.get(array, gen.field_76756_M);
        if (typeList == null) {
            typeList = biomeInfo.getClass().getDeclaredField("typeList");
            typeList.setAccessible(true);
        }
        EnumSet set = (EnumSet)typeList.get(biomeInfo);
        List[] listArray = (List[])typeInfoList.get(null);
        for (BiomeDictionary.Type type : set) {
            listArray[type.ordinal()].remove(gen);
        }
        set.clear();
    }

    public static void modTypeLists() throws Exception {
        BiomeHelper.checkFields();
        if (hasModded) {
            return;
        }
        Object array = biomes.get(null);
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object list = Array.get(array, i);
            if (isModded == null) {
                isModded = list.getClass().getDeclaredField("isModded");
                isModded.setAccessible(true);
            }
            isModded.setBoolean(list, true);
        }
        hasModded = true;
    }

    static {
        logged = EnumSet.noneOf(BiomeManager.BiomeType.class);
    }
}

