/*
 * Decompiled with CFR 0.152.
 */
package me.superckl.api.superscript;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import me.superckl.api.superscript.APIInfo;
import me.superckl.api.superscript.ScriptParser;
import me.superckl.api.superscript.object.ScriptObject;

public class ScriptHandler {
    private static final Map<String, ScriptObject> staticObjects = Maps.newHashMap();
    private final List<String> lines;
    private Iterator<String> it;
    private final Map<String, String> shortcuts = new HashMap<String, String>();
    private final Map<String, ScriptObject> objects = new HashMap<String, ScriptObject>();

    public ScriptHandler(List<String> lines) {
        this.lines = lines;
        this.objects.putAll(staticObjects);
    }

    public void parse() throws Exception {
        this.it = this.lines.iterator();
        if (!this.it.hasNext()) {
            return;
        }
        while (this.it.hasNext()) {
            String s = this.it.next().trim().split("#", 2)[0];
            try {
                if (s.contains("=")) {
                    Map<String, Object> map = ScriptParser.parseAssignment(s, this);
                    if (map == null) continue;
                    for (Map.Entry<String, Object> entry : map.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            this.shortcuts.put(entry.getKey(), (String)entry.getValue());
                            continue;
                        }
                        if (!(entry.getValue() instanceof ScriptObject)) continue;
                        this.objects.put(entry.getKey(), (ScriptObject)entry.getValue());
                    }
                    continue;
                }
                if (!s.contains(".")) continue;
                String[] split = s.split("[.]", 2);
                if (split.length != 2) {
                    APIInfo.log.error("Found operator '.' in invalid context: " + s);
                    continue;
                }
                if (!this.objects.containsKey(split[0])) {
                    APIInfo.log.error("Object not found: " + split[0]);
                    continue;
                }
                ScriptObject obj = this.objects.get(split[0]);
                obj.handleCall(split[1], this);
            }
            catch (Exception e) {
                APIInfo.log.error("Failed to handle a script line! " + s);
                e.printStackTrace();
            }
        }
    }

    public static void registerStaticObject(String name, ScriptObject object) {
        staticObjects.put(name, object);
    }

    public List<String> getLines() {
        return this.lines;
    }

    public Iterator<String> getIt() {
        return this.it;
    }

    public Map<String, String> getShortcuts() {
        return this.shortcuts;
    }

    public Map<String, ScriptObject> getObjects() {
        return this.objects;
    }
}

