/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.blocks;

import com.rwtema.funkylocomotion.EntityMovingEventHandler;
import com.rwtema.funkylocomotion.Proxy;
import cpw.mods.fml.relauncher.Side;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileMovingBase
extends TileEntity {
    private static final AxisAlignedBB[] blank = new AxisAlignedBB[0];
    public AxisAlignedBB[] collisions = blank;
    public final Side side;
    public boolean isAir = true;
    public int time = 0;
    public int maxTime = 0;
    public NBTTagCompound block;
    public NBTTagCompound desc;
    public ForgeDirection dir = ForgeDirection.UNKNOWN;
    public int lightLevel = 0;
    public int lightOpacity = 255;
    public int scheduledTickTime = -1;
    public int scheduledTickPriority;

    public TileMovingBase(Side side) {
        this.side = side;
    }

    public static boolean _Immovable() {
        return true;
    }

    private static NBTTagCompound NBTAxis(AxisAlignedBB bb) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("a", (float)bb.field_72340_a);
        tag.func_74776_a("b", (float)bb.field_72338_b);
        tag.func_74776_a("c", (float)bb.field_72339_c);
        tag.func_74776_a("d", (float)bb.field_72336_d);
        tag.func_74776_a("e", (float)bb.field_72337_e);
        tag.func_74776_a("f", (float)bb.field_72334_f);
        return tag;
    }

    private static AxisAlignedBB AxisNBT(NBTTagCompound tag) {
        return AxisAlignedBB.func_72330_a((double)tag.func_74760_g("a"), (double)tag.func_74760_g("b"), (double)tag.func_74760_g("c"), (double)tag.func_74760_g("d"), (double)tag.func_74760_g("e"), (double)tag.func_74760_g("f"));
    }

    protected static AxisAlignedBB[] AxisTags(NBTTagList tagList) {
        int n = tagList.func_74745_c();
        AxisAlignedBB[] bbs = new AxisAlignedBB[n];
        for (int i = 0; i < n; ++i) {
            bbs[i] = TileMovingBase.AxisNBT(tagList.func_150305_b(i));
        }
        return bbs;
    }

    protected static NBTTagList TagsAxis(AxisAlignedBB[] bbs) {
        NBTTagList tagList = new NBTTagList();
        for (AxisAlignedBB bb : bbs) {
            tagList.func_74742_a((NBTBase)TileMovingBase.NBTAxis(bb));
        }
        return tagList;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.block = tag.func_74775_l("BlockTag");
        this.desc = tag.func_74775_l("DescTag");
        this.time = tag.func_74762_e("Time");
        this.maxTime = tag.func_74762_e("MaxTime");
        this.dir = ForgeDirection.getOrientation((int)tag.func_74771_c("Dir"));
        this.isAir = this.block.func_82582_d();
        if (tag.func_150297_b("Collisions", 10)) {
            this.collisions = TileMovingBase.AxisTags(tag.func_150295_c("Collisions", 10));
        }
        this.lightLevel = tag.func_74771_c("Light");
        this.lightOpacity = tag.func_74765_d("Opacity");
        if (tag.func_150297_b("TimeTime", 3)) {
            this.scheduledTickTime = tag.func_74762_e("TickTime");
            this.scheduledTickPriority = tag.func_74762_e("TickPriority");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("BlockTag", (NBTBase)this.block);
        tag.func_74782_a("DescTag", (NBTBase)this.desc);
        tag.func_74768_a("Time", this.time);
        tag.func_74768_a("MaxTime", this.maxTime);
        tag.func_74774_a("Dir", (byte)this.dir.ordinal());
        if (this.collisions.length > 0) {
            tag.func_74782_a("Collisions", (NBTBase)TileMovingBase.TagsAxis(this.collisions));
        }
        if (this.lightLevel != 0) {
            tag.func_74774_a("Light", (byte)this.lightLevel);
        }
        if (this.lightOpacity != 0) {
            tag.func_74777_a("Opacity", (short)this.lightOpacity);
        }
        if (this.scheduledTickTime != -1) {
            tag.func_74768_a("TickTime", this.scheduledTickTime);
            tag.func_74768_a("TickPriority", this.scheduledTickPriority);
        }
    }

    public Vec3 getMovVec() {
        double d = 1.0 / (double)this.maxTime;
        return Vec3.func_72443_a((double)((double)this.dir.offsetX * d), (double)((double)this.dir.offsetY * d), (double)((double)this.dir.offsetZ * d));
    }

    public void func_145845_h() {
        if (this.maxTime == 0) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.time = this.time + 1 - 1;
        }
        Vec3 mov = this.getMovVec();
        HashSet<Entity> entityList = new HashSet<Entity>();
        ++this.time;
        for (AxisAlignedBB bb : this.getTransformedColisions()) {
            List entities = this.field_145850_b.func_72872_a(Entity.class, bb.func_72314_b(0.0, 0.1, 0.0));
            for (Entity entity : entities) {
                entityList.add(entity);
            }
        }
        for (Entity a : entityList) {
            WeakHashMap<Entity, Vec3> map;
            if (a.field_70128_L || (map = EntityMovingEventHandler.getMovementMap(this.side)).containsKey(a)) continue;
            for (AxisAlignedBB bb : this.getTransformedColisions()) {
                if (a.field_70121_D.func_72326_a(bb)) {
                    if (!(a.field_70121_D.field_72338_b > bb.field_72337_e - 0.2)) continue;
                    a.field_70121_D.func_72317_d(0.0, bb.field_72337_e - a.field_70121_D.field_72338_b, 0.0);
                    continue;
                }
                if (this.dir != ForgeDirection.DOWN || !(a.field_70181_x <= 0.0) || !a.field_70121_D.func_72326_a(bb.func_72317_d(0.0, 0.2, 0.0))) continue;
                a.field_70121_D.func_72317_d(0.0, bb.field_72337_e - a.field_70121_D.field_72338_b, 0.0);
            }
            EntityMovingEventHandler.moveEntity(a, mov.field_72450_a, mov.field_72448_b, mov.field_72449_c);
            map.put(a, null);
        }
    }

    public AxisAlignedBB getCombinedCollisions() {
        AxisAlignedBB bb = null;
        for (AxisAlignedBB collision : this.collisions) {
            if (bb == null) {
                bb = collision.func_72329_c();
                continue;
            }
            bb.func_111270_a(collision);
        }
        TileEntity other = this.field_145850_b.func_147438_o(this.field_145851_c + this.dir.offsetX, this.field_145848_d + this.dir.offsetY, this.field_145849_e + this.dir.offsetZ);
        if (other instanceof TileMovingBase) {
            AxisAlignedBB[] bbs1;
            for (AxisAlignedBB bb1 : bbs1 = ((TileMovingBase)other).collisions) {
                if (bb == null) {
                    bb = bb1.func_72325_c((double)this.dir.offsetX, (double)this.dir.offsetY, (double)this.dir.offsetZ);
                    continue;
                }
                bb.func_111270_a(bb1.func_72325_c((double)this.dir.offsetX, (double)this.dir.offsetY, (double)this.dir.offsetZ));
            }
        }
        if (bb == null) {
            return null;
        }
        double h = this.offset(false);
        bb.func_72317_d(h * (double)this.dir.offsetX, h * (double)this.dir.offsetY, h * (double)this.dir.offsetZ);
        return bb;
    }

    public AxisAlignedBB[] getTransformedColisions() {
        AxisAlignedBB[] tbbs = new AxisAlignedBB[this.collisions.length];
        double h = this.offset(false);
        for (int i = 0; i < this.collisions.length; ++i) {
            tbbs[i] = this.collisions[i].func_72325_c(h * (double)this.dir.offsetX, h * (double)this.dir.offsetY, h * (double)this.dir.offsetZ).func_72317_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        }
        return tbbs;
    }

    public float progress() {
        return this.time >= this.maxTime ? 1.0f : ((float)this.time + Proxy.renderTimeOffset) / (float)this.maxTime;
    }

    public double offset(boolean t) {
        if (this.time >= this.maxTime) {
            return 0.0;
        }
        float f = t ? Proxy.renderTimeOffset : 0.0f;
        return ((float)this.time + f) / (float)this.maxTime - 1.0f;
    }
}

