/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.ClientModifiable;
import ic2.core.network.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Facing;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.IRotation;
import shedar.mods.ic2.nuclearcontrol.ISlotItemFilter;
import shedar.mods.ic2.nuclearcontrol.ITextureHelper;
import shedar.mods.ic2.nuclearcontrol.api.CardState;
import shedar.mods.ic2.nuclearcontrol.api.ICardWrapper;
import shedar.mods.ic2.nuclearcontrol.api.IPanelDataSource;
import shedar.mods.ic2.nuclearcontrol.api.IRangeTriggerable;
import shedar.mods.ic2.nuclearcontrol.api.IRemoteSensor;
import shedar.mods.ic2.nuclearcontrol.items.ItemUpgrade;
import shedar.mods.ic2.nuclearcontrol.panel.CardWrapperImpl;

public class TileEntityRangeTrigger
extends TileEntity
implements ISlotItemFilter,
INetworkDataProvider,
INetworkUpdateListener,
IWrenchable,
ITextureHelper,
IRotation,
IInventory,
INetworkClientTileEntityEventListener {
    public static final int SLOT_CARD = 0;
    public static final int SLOT_UPGRADE = 1;
    private static final int LOCATION_RANGE = 8;
    private static final int STATE_UNKNOWN = -1;
    private static final int STATE_PASSIVE = 0;
    private static final int STATE_ACTIVE = 1;
    protected int updateTicker;
    protected int tickRate;
    protected boolean init = false;
    private ItemStack[] inventory = new ItemStack[2];
    @ClientModifiable
    private ItemStack card = null;
    private int prevRotation;
    public int rotation;
    private short prevFacing;
    public short facing;
    private int prevOnFire;
    private int onFire;
    private boolean prevInvertRedstone;
    @ClientModifiable
    private boolean invertRedstone;
    private double prevLevelStart;
    @ClientModifiable
    public double levelStart;
    private double prevLevelEnd;
    @ClientModifiable
    public double levelEnd;

    @Override
    public short getFacing() {
        return (short)Facing.field_71588_a[this.facing];
    }

    public void setFacing(short f) {
        this.setSide((short)Facing.field_71588_a[f]);
    }

    public boolean isInvertRedstone() {
        return this.invertRedstone;
    }

    public void setInvertRedstone(boolean value) {
        this.invertRedstone = value;
        if (this.prevInvertRedstone != value) {
            this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "invertRedstone");
        }
        this.prevInvertRedstone = value;
    }

    private void setCard(ItemStack value) {
        this.card = value;
        ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "card");
    }

    private void setSide(short f) {
        this.facing = f;
        if (this.init && this.prevFacing != f) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = f;
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("facing") && this.prevFacing != this.facing) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevFacing = this.facing;
        } else if (field.equals("card")) {
            this.inventory[0] = this.card;
        } else if (field.equals("rotation") && this.prevRotation != this.rotation) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevRotation = this.rotation;
        } else if (field.equals("onFire") && this.prevOnFire != this.onFire) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.prevOnFire = this.onFire;
        } else if (field.equals("invertRedstone") && this.prevInvertRedstone != this.invertRedstone) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.prevInvertRedstone = this.invertRedstone;
        }
    }

    public void onNetworkEvent(EntityPlayer entityplayer, int i) {
        if (i < 0) {
            switch (i) {
                case -1: {
                    this.setInvertRedstone(false);
                    break;
                }
                case -2: {
                    this.setInvertRedstone(true);
                    break;
                }
            }
        }
    }

    public void setOnFire(int f) {
        this.onFire = f;
        if (this.prevOnFire != f) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "onFire");
        }
        this.prevOnFire = this.onFire;
    }

    public void setLevelStart(double start) {
        this.levelStart = start;
        if (this.prevLevelStart != start) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "levelStart");
        }
        this.prevLevelStart = this.levelStart;
    }

    public void setLevelEnd(double end) {
        this.levelEnd = end;
        if (this.prevLevelEnd != end) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "levelEnd");
        }
        this.prevLevelEnd = this.levelEnd;
    }

    public int getOnFire() {
        return this.onFire;
    }

    public TileEntityRangeTrigger() {
        this.updateTicker = this.tickRate = IC2NuclearControl.instance.rangeTriggerRefreshPeriod;
        this.facing = 0;
        this.prevFacing = 0;
        this.prevRotation = 0;
        this.rotation = 0;
        this.prevOnFire = 0;
        this.onFire = 0;
        this.invertRedstone = false;
        this.prevInvertRedstone = false;
        this.levelStart = 1.0E7;
        this.levelEnd = 9000000.0;
    }

    public List<String> getNetworkedFields() {
        ArrayList<String> list = new ArrayList<String>(7);
        list.add("facing");
        list.add("rotation");
        list.add("card");
        list.add("onFire");
        list.add("invertRedstone");
        list.add("levelStart");
        list.add("levelEnd");
        return list;
    }

    protected void initData() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
        }
        this.init = true;
    }

    public void func_145845_h() {
        if (!this.init) {
            this.initData();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.func_70296_d();
        }
        super.func_145845_h();
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.prevRotation = this.rotation = nbttagcompound.func_74762_e("rotation");
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
        this.prevInvertRedstone = this.invertRedstone = nbttagcompound.func_74767_n("invert");
        this.levelStart = nbttagcompound.func_74769_h("levelStart");
        this.levelEnd = nbttagcompound.func_74769_h("levelEnd");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound compound = nbttaglist.func_150305_b(i);
            byte slotNum = compound.func_74771_c("Slot");
            if (slotNum < 0 || slotNum >= this.inventory.length) continue;
            this.inventory[slotNum] = ItemStack.func_77949_a((NBTTagCompound)compound);
            if (slotNum != 0) continue;
            this.card = this.inventory[slotNum];
        }
        this.func_70296_d();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74768_a("rotation", this.rotation);
        nbttagcompound.func_74757_a("invert", this.isInvertRedstone());
        nbttagcompound.func_74780_a("levelStart", this.levelStart);
        nbttagcompound.func_74780_a("levelEnd", this.levelEnd);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(compound);
            nbttaglist.func_74742_a((NBTBase)compound);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slotNum) {
        return this.inventory[slotNum];
    }

    public ItemStack func_70298_a(int slotNum, int amount) {
        if (this.inventory[slotNum] != null) {
            if (this.inventory[slotNum].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slotNum];
                this.inventory[slotNum] = null;
                if (slotNum == 0) {
                    this.setCard(null);
                }
                return itemStack;
            }
            ItemStack taken = this.inventory[slotNum].func_77979_a(amount);
            if (this.inventory[slotNum].field_77994_a == 0) {
                this.inventory[slotNum] = null;
                if (slotNum == 0) {
                    this.setCard(null);
                }
            }
            return taken;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slotNum, ItemStack itemStack) {
        this.inventory[slotNum] = itemStack;
        if (slotNum == 0) {
            this.setCard(itemStack);
        }
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "block.RangeTrigger";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            Item item;
            int upgradeCountRange = 0;
            ItemStack itemStack = this.inventory[1];
            if (itemStack != null && itemStack.func_77973_b() instanceof ItemUpgrade && itemStack.func_77960_j() == 0) {
                upgradeCountRange = itemStack.field_77994_a;
            }
            ItemStack card = this.inventory[0];
            int fire = -1;
            if (card != null && (item = card.func_77973_b()) instanceof IPanelDataSource && item instanceof IRangeTriggerable) {
                boolean needUpdate = true;
                if (upgradeCountRange > 7) {
                    upgradeCountRange = 7;
                }
                int range = 8 * (int)Math.pow(2.0, upgradeCountRange);
                CardWrapperImpl cardHelper = new CardWrapperImpl(card, 0);
                if (item instanceof IRemoteSensor) {
                    ChunkCoordinates target = cardHelper.getTarget();
                    if (target == null) {
                        needUpdate = false;
                        cardHelper.setState(CardState.INVALID_CARD);
                    } else {
                        int dx = target.field_71574_a - this.field_145851_c;
                        int dy = target.field_71572_b - this.field_145848_d;
                        int dz = target.field_71573_c - this.field_145849_e;
                        if (Math.abs(dx) > range || Math.abs(dy) > range || Math.abs(dz) > range) {
                            needUpdate = false;
                            cardHelper.setState(CardState.OUT_OF_RANGE);
                            fire = -1;
                        }
                    }
                }
                if (needUpdate) {
                    CardState state = ((IPanelDataSource)item).update(this, (ICardWrapper)cardHelper, range);
                    cardHelper.setState(state);
                    if (state == CardState.OK) {
                        double min = Math.min(this.levelStart, this.levelEnd);
                        double max = Math.max(this.levelStart, this.levelEnd);
                        double cur = cardHelper.getDouble("range_trigger_amount");
                        fire = cur > max ? 1 : (cur < min ? 1 : (this.onFire == -1 ? 0 : 0));
                    } else {
                        fire = -1;
                    }
                }
            }
            if (fire != this.getOnFire()) {
                this.setOnFire(fire);
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
        }
    }

    @Override
    public boolean isItemValid(int slotIndex, ItemStack itemstack) {
        switch (slotIndex) {
            case 0: {
                return itemstack.func_77973_b() instanceof IRangeTriggerable;
            }
        }
        return itemstack.func_77973_b() instanceof ItemUpgrade && itemstack.func_77960_j() == 0;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int face) {
        return !entityPlayer.func_70093_af() && this.getFacing() != face;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return !entityPlayer.func_70093_af();
    }

    private int modifyTextureIndex(int texture, int x, int y, int z) {
        if (texture != 2) {
            return texture;
        }
        switch (this.getOnFire()) {
            case 1: {
                texture = 4;
                break;
            }
            case 0: {
                texture = 3;
            }
        }
        return texture;
    }

    @Override
    public int modifyTextureIndex(int texture) {
        return this.modifyTextureIndex(texture, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.field_145851_c;
        result = 31 * result + this.field_145848_d;
        result = 31 * result + this.field_145849_e;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TileEntityRangeTrigger other = (TileEntityRangeTrigger)obj;
        if (this.field_145851_c != other.field_145851_c) {
            return false;
        }
        if (this.field_145848_d != other.field_145848_d) {
            return false;
        }
        if (this.field_145849_e != other.field_145849_e) {
            return false;
        }
        return this.field_145850_b == other.field_145850_b;
    }

    @Override
    public void rotate() {
        int r;
        switch (this.rotation) {
            case 0: {
                r = 1;
                break;
            }
            case 1: {
                r = 3;
                break;
            }
            case 3: {
                r = 2;
                break;
            }
            case 2: {
                r = 0;
                break;
            }
            default: {
                r = 0;
            }
        }
        this.setRotation(r);
    }

    @Override
    public int getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(int value) {
        this.rotation = value;
        if (this.rotation != this.prevRotation) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "rotation");
        }
        this.prevRotation = this.rotation;
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 8);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.isItemValid(slot, itemstack);
    }
}

