/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.parsing;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import cpw.mods.fml.relauncher.ReflectionHelper;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.SaveHelper;
import hardcorequesting.parsing.MinecraftAdapter;
import hardcorequesting.quests.ItemPrecision;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestLine;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.quests.QuestTask;
import hardcorequesting.quests.QuestTaskDeath;
import hardcorequesting.quests.QuestTaskItems;
import hardcorequesting.quests.QuestTaskLocation;
import hardcorequesting.quests.QuestTaskMob;
import hardcorequesting.quests.QuestTaskReputation;
import hardcorequesting.quests.QuestTaskReputationKill;
import hardcorequesting.quests.RepeatInfo;
import hardcorequesting.quests.RepeatType;
import hardcorequesting.quests.TriggerType;
import hardcorequesting.reputation.Reputation;
import hardcorequesting.reputation.ReputationBar;
import hardcorequesting.reputation.ReputationMarker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class QuestAdapter {
    public static Quest QUEST;
    public static QuestTask TASK;
    public static int QUEST_ID;
    private static List<ReputationBar> reputationBarList;
    private static Map<Quest, List<Integer>> requirementMapping;
    private static Map<Quest, List<String>> prerequisiteMapping;
    private static Map<Quest, List<Integer>> optionMapping;
    private static Map<Quest, List<String>> optionLinkMapping;
    private static Map<Quest.ReputationReward, Integer> reputationRewardMapping;
    private static Map<QuestTaskReputation, List<ReputationSettingConstructor>> taskReputationListMap;
    private static final TypeAdapter<QuestTaskItems.ItemRequirement> ITEM_REQUIREMENT_ADAPTER;
    private static final TypeAdapter<QuestTaskLocation.Location> LOCATION_ADAPTER;
    private static final TypeAdapter<QuestTaskMob.Mob> MOB_ADAPTER;
    private static final TypeAdapter<QuestTaskReputation.ReputationSetting> REPUTATION_TASK_ADAPTER;
    private static final TypeAdapter<QuestTask> TASK_ADAPTER;
    private static final TypeAdapter<RepeatInfo> REPEAT_INFO_ADAPTER;
    private static final TypeAdapter<Quest.ReputationReward> REPUTATION_REWARD_ADAPTER;
    public static final TypeAdapter<Quest> QUEST_ADAPTER;
    public static final TypeAdapter<QuestSet> QUEST_SET_ADAPTER;
    private static final TypeAdapter<ReputationBar> REPUTATION_BAR_ADAPTER;
    private static final Pattern OTHER_QUEST_SET;

    public static void postLoad() throws IOException {
        Quest quest;
        for (Map.Entry<Quest, List<String>> entry : prerequisiteMapping.entrySet()) {
            for (String link : entry.getValue()) {
                quest = QuestAdapter.getQuest(link, entry.getKey().getQuestSet());
                if (quest == null) continue;
                entry.getKey().addRequirement(quest.getId());
            }
        }
        for (Map.Entry<Quest, List<String>> entry : optionLinkMapping.entrySet()) {
            for (String link : entry.getValue()) {
                quest = QuestAdapter.getQuest(link, entry.getKey().getQuestSet());
                if (quest == null) continue;
                entry.getKey().addOptionLink(quest.getId());
            }
        }
        for (Map.Entry<Object, Object> entry : reputationRewardMapping.entrySet()) {
            int rep = (Integer)entry.getValue();
            if (rep >= 0 && rep < Reputation.getReputationList().size()) {
                Reputation reputation = Reputation.getReputationList().get(rep);
                if (reputation == null) {
                    throw new IOException("Failed to load reputation value " + rep);
                }
                ((Quest.ReputationReward)entry.getKey()).setReputation(reputation);
                continue;
            }
            throw new IOException("Missing reputation value " + rep);
        }
        for (Map.Entry<Object, Object> entry : taskReputationListMap.entrySet()) {
            ArrayList<QuestTaskReputation.ReputationSetting> reputationSettingList = new ArrayList<QuestTaskReputation.ReputationSetting>();
            for (ReputationSettingConstructor constructor : (List)entry.getValue()) {
                QuestTaskReputation.ReputationSetting setting = constructor.constructReuptationSetting();
                if (setting == null) continue;
                reputationSettingList.add(setting);
            }
            ReflectionHelper.setPrivateValue(QuestTaskReputation.class, (Object)entry.getKey(), (Object)reputationSettingList.toArray(new QuestTaskReputation.ReputationSetting[reputationSettingList.size()]), (String[])new String[]{"settings"});
        }
    }

    private static Quest getQuest(String string, QuestSet defaultSet) {
        QuestSet set = defaultSet;
        String questName = string;
        Matcher matcher = OTHER_QUEST_SET.matcher(string);
        if (matcher.find()) {
            for (QuestSet questSet : Quest.getQuestSets()) {
                if (!questSet.getName().equalsIgnoreCase(matcher.group(1))) continue;
                set = questSet;
                break;
            }
            questName = matcher.group(2);
        }
        if (set != null) {
            for (Quest quest : set.getQuests()) {
                if (!quest.getName().equalsIgnoreCase(questName)) continue;
                return quest;
            }
        }
        return null;
    }

    static {
        reputationBarList = new ArrayList<ReputationBar>();
        requirementMapping = new HashMap<Quest, List<Integer>>();
        prerequisiteMapping = new HashMap<Quest, List<String>>();
        optionMapping = new HashMap<Quest, List<Integer>>();
        optionLinkMapping = new HashMap<Quest, List<String>>();
        reputationRewardMapping = new HashMap<Quest.ReputationReward, Integer>();
        taskReputationListMap = new HashMap<QuestTaskReputation, List<ReputationSettingConstructor>>();
        ITEM_REQUIREMENT_ADAPTER = new TypeAdapter<QuestTaskItems.ItemRequirement>(){
            private final String ITEM = "item";
            private final String FLUID = "fluid";
            private final String REQUIRED = "required";
            private final String PRECISION = "precision";

            public void write(JsonWriter out, QuestTaskItems.ItemRequirement value) throws IOException {
                ItemStack item = value.getItem();
                Fluid fluid = value.fluid;
                int required = value.required;
                ItemPrecision precision = value.getPrecision();
                out.beginObject();
                if (item != null) {
                    MinecraftAdapter.ITEM_STACK.write(out.name("item"), (Object)item);
                } else if (fluid != null) {
                    MinecraftAdapter.FLUID.write(out.name("fluid"), (Object)fluid);
                } else {
                    out.nullValue();
                    out.endObject();
                    return;
                }
                if (required != 1) {
                    out.name("required").value((long)required);
                }
                if (precision != ItemPrecision.PRECISE) {
                    out.name("precision").value(ItemPrecision.getUniqueID(precision));
                }
                out.endObject();
            }

            public QuestTaskItems.ItemRequirement read(JsonReader in) throws IOException {
                in.beginObject();
                ItemStack item = null;
                Fluid fluid = null;
                int required = 1;
                ItemPrecision precision = ItemPrecision.PRECISE;
                while (in.hasNext()) {
                    ItemPrecision itemPrecision;
                    String next = in.nextName();
                    if (next.equalsIgnoreCase("item")) {
                        item = (ItemStack)MinecraftAdapter.ITEM_STACK.read(in);
                        continue;
                    }
                    if (next.equalsIgnoreCase("fluid")) {
                        fluid = (Fluid)MinecraftAdapter.FLUID.read(in);
                        continue;
                    }
                    if (next.equalsIgnoreCase("required")) {
                        required = Math.max(in.nextInt(), required);
                        continue;
                    }
                    if (!next.equalsIgnoreCase("precision") || (itemPrecision = ItemPrecision.getPrecisionType(in.nextString())) == null) continue;
                    precision = itemPrecision;
                }
                in.endObject();
                QuestTaskItems.ItemRequirement result = null;
                if (item != null) {
                    result = new QuestTaskItems.ItemRequirement(item, required);
                } else if (fluid != null) {
                    result = new QuestTaskItems.ItemRequirement(fluid, required);
                } else {
                    return null;
                }
                result.setPrecision(precision);
                return result;
            }
        };
        LOCATION_ADAPTER = new TypeAdapter<QuestTaskLocation.Location>(){
            private final String X = "x";
            private final String Y = "y";
            private final String Z = "z";
            private final String DIM = "dim";
            private final String ICON = "icon";
            private final String RADIUS = "radius";
            private final String VISIBLE = "visible";
            private final String NAME = "name";

            public void write(JsonWriter out, QuestTaskLocation.Location value) throws IOException {
                out.beginObject();
                out.name("name").value(value.getName());
                ItemStack stack = value.getIcon();
                if (stack != null) {
                    MinecraftAdapter.ITEM_STACK.write(out.name("icon"), (Object)stack);
                }
                out.name("x").value((long)value.getX());
                out.name("y").value((long)value.getY());
                out.name("z").value((long)value.getZ());
                out.name("dim").value((long)value.getDimension());
                out.name("radius").value((long)value.getRadius());
                if (value.getVisible() != QuestTaskLocation.Visibility.LOCATION) {
                    out.name("visible").value(value.getVisible().name());
                }
                out.endObject();
            }

            public QuestTaskLocation.Location read(JsonReader in) throws IOException {
                in.beginObject();
                QuestTaskLocation.Location result = new QuestTaskLocation.Location();
                while (in.hasNext()) {
                    String name = in.nextName();
                    if (name.equalsIgnoreCase("name")) {
                        result.setName(in.nextString());
                        continue;
                    }
                    if (name.equalsIgnoreCase("x")) {
                        result.setX(in.nextInt());
                        continue;
                    }
                    if (name.equalsIgnoreCase("y")) {
                        result.setY(in.nextInt());
                        continue;
                    }
                    if (name.equalsIgnoreCase("z")) {
                        result.setZ(in.nextInt());
                        continue;
                    }
                    if (name.equalsIgnoreCase("dim")) {
                        result.setDimension(in.nextInt());
                        continue;
                    }
                    if (name.equalsIgnoreCase("radius")) {
                        result.setRadius(in.nextInt());
                        continue;
                    }
                    if (name.equalsIgnoreCase("icon")) {
                        result.setIcon((ItemStack)MinecraftAdapter.ITEM_STACK.read(in));
                        continue;
                    }
                    if (!name.equalsIgnoreCase("visible")) continue;
                    result.setVisible(QuestTaskLocation.Visibility.valueOf(in.nextString()));
                }
                in.endObject();
                return result;
            }
        };
        MOB_ADAPTER = new TypeAdapter<QuestTaskMob.Mob>(){
            private final String KILLS = "kills";
            private final String EXACT = "exact";
            private final String MOB = "mob";
            private final String ICON = "icon";
            private final String NAME = "name";

            public void write(JsonWriter out, QuestTaskMob.Mob value) throws IOException {
                out.beginObject();
                out.name("name").value(value.getName());
                ItemStack stack = value.getIcon();
                if (stack != null) {
                    MinecraftAdapter.ITEM_STACK.write(out.name("icon"), (Object)stack);
                }
                out.name("mob").value(value.getMob());
                out.name("kills").value((long)value.getCount());
                out.name("exact").value(value.isExact());
                out.endObject();
            }

            public QuestTaskMob.Mob read(JsonReader in) throws IOException {
                in.beginObject();
                QuestTaskMob.Mob result = new QuestTaskMob.Mob((QuestTaskMob)TASK);
                while (in.hasNext()) {
                    String name = in.nextName();
                    if (name.equalsIgnoreCase("name")) {
                        result.setName(in.nextString());
                        continue;
                    }
                    if (name.equalsIgnoreCase("icon")) {
                        result.setIcon((ItemStack)MinecraftAdapter.ITEM_STACK.read(in));
                        continue;
                    }
                    if (name.equalsIgnoreCase("mob")) {
                        result.setMob(in.nextString());
                        continue;
                    }
                    if (name.equalsIgnoreCase("exact")) {
                        result.setExact(in.nextBoolean());
                        continue;
                    }
                    if (!name.equalsIgnoreCase("kills")) continue;
                    result.setCount(in.nextInt());
                }
                in.endObject();
                return result;
            }
        };
        REPUTATION_TASK_ADAPTER = new TypeAdapter<QuestTaskReputation.ReputationSetting>(){
            private final String REPUTATION = "reputation";
            private final String LOWER = "lower";
            private final String UPPER = "upper";
            private final String INVERTED = "inverted";

            public void write(JsonWriter out, QuestTaskReputation.ReputationSetting value) throws IOException {
                out.beginObject();
                out.name("reputation").value((long)value.getReputation().getId());
                if (value.getLower() != null) {
                    out.name("lower").value((long)value.getLower().getId());
                }
                if (value.getUpper() != null) {
                    out.name("upper").value((long)value.getUpper().getId());
                }
                out.name("inverted").value(value.isInverted());
                out.endObject();
            }

            public QuestTaskReputation.ReputationSetting read(JsonReader in) throws IOException {
                return null;
            }
        };
        TASK_ADAPTER = new TypeAdapter<QuestTask>(){
            private final String TYPE = "type";
            private final String DESCRIPTION = "description";
            private final String LONG_DESCRIPTION = "longDescription";
            private final String ITEMS = "items";
            private final String DEATHS = "deaths";
            private final String LOCATIONS = "locations";
            private final String MOBS = "mobs";
            private final String REPUTATION = "reputation";
            private final String KILLS = "kills";

            public void write(JsonWriter out, QuestTask value) throws IOException {
                out.beginObject();
                Quest.TaskType type = Quest.TaskType.getType(value.getClass());
                out.name("type").value(type.name());
                if (!value.getDescription().equals(type.getName())) {
                    out.name("description").value(value.getDescription());
                }
                if (!value.getLongDescription().equals(type.getDescription())) {
                    out.name("longDescription").value(value.getLongDescription());
                }
                if (value instanceof QuestTaskItems) {
                    out.name("items").beginArray();
                    for (QuestTaskItems.ItemRequirement requirement : ((QuestTaskItems)value).getItems()) {
                        ITEM_REQUIREMENT_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                } else if (value instanceof QuestTaskDeath) {
                    out.name("deaths").value((long)((QuestTaskDeath)value).getDeaths());
                } else if (value instanceof QuestTaskLocation) {
                    out.name("locations").beginArray();
                    for (QuestTaskLocation.Location requirement : ((QuestTaskLocation)value).locations) {
                        LOCATION_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                } else if (value instanceof QuestTaskMob) {
                    out.name("mobs").beginArray();
                    for (QuestTaskMob.Mob requirement : ((QuestTaskMob)value).mobs) {
                        MOB_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                } else if (value instanceof QuestTaskReputation) {
                    out.name("reputation").beginArray();
                    for (QuestTaskReputation.ReputationSetting requirement : ((QuestTaskReputation)value).getSettings()) {
                        REPUTATION_TASK_ADAPTER.write(out, (Object)requirement);
                    }
                    out.endArray();
                    if (value instanceof QuestTaskReputationKill) {
                        out.name("kills").value((long)((QuestTaskReputationKill)value).getKills());
                    }
                }
                out.endObject();
            }

            public QuestTask read(JsonReader in) throws IOException {
                in.beginObject();
                if (!in.nextName().equalsIgnoreCase("type")) {
                    throw new IOException("Tasks *MUST* start with the type");
                }
                String task = in.nextString();
                Quest.TaskType type = Quest.TaskType.valueOf(task);
                if (type == null) {
                    throw new IOException("Invalid Task Type: " + task);
                }
                TASK = type.addTask(QUEST);
                while (in.hasNext()) {
                    Object entry;
                    ArrayList<Object> list;
                    String name = in.nextName();
                    if (name.equalsIgnoreCase("description")) {
                        QuestAdapter.TASK.description = in.nextString();
                        continue;
                    }
                    if (name.equalsIgnoreCase("longDescription")) {
                        TASK.setLongDescription(in.nextString());
                        continue;
                    }
                    if (TASK instanceof QuestTaskItems && name.equalsIgnoreCase("items")) {
                        list = new ArrayList<Object>();
                        in.beginArray();
                        while (in.hasNext()) {
                            entry = (QuestTaskItems.ItemRequirement)ITEM_REQUIREMENT_ADAPTER.read(in);
                            if (entry == null) continue;
                            list.add(entry);
                        }
                        in.endArray();
                        ((QuestTaskItems)TASK).setItems(list.toArray(new QuestTaskItems.ItemRequirement[list.size()]));
                        continue;
                    }
                    if (TASK instanceof QuestTaskDeath && name.equalsIgnoreCase("deaths")) {
                        int death = in.nextInt();
                        ((QuestTaskDeath)TASK).setDeaths(death);
                        continue;
                    }
                    if (TASK instanceof QuestTaskLocation && name.equalsIgnoreCase("locations")) {
                        list = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            entry = (QuestTaskLocation.Location)LOCATION_ADAPTER.read(in);
                            if (entry == null) continue;
                            list.add(entry);
                        }
                        in.endArray();
                        ((QuestTaskLocation)QuestAdapter.TASK).locations = list.toArray(new QuestTaskLocation.Location[list.size()]);
                        continue;
                    }
                    if (TASK instanceof QuestTaskMob && name.equalsIgnoreCase("mobs")) {
                        list = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            entry = (QuestTaskMob.Mob)MOB_ADAPTER.read(in);
                            if (entry == null) continue;
                            list.add(entry);
                        }
                        in.endArray();
                        ((QuestTaskMob)QuestAdapter.TASK).mobs = list.toArray(new QuestTaskMob.Mob[list.size()]);
                        continue;
                    }
                    if (TASK instanceof QuestTaskReputation && name.equalsIgnoreCase("reputation")) {
                        list = new ArrayList();
                        in.beginArray();
                        while (in.hasNext()) {
                            ReputationSettingConstructor constructor = ReputationSettingConstructor.read(in);
                            if (constructor == null) continue;
                            list.add(constructor);
                        }
                        in.endArray();
                        taskReputationListMap.put((QuestTaskReputation)TASK, list);
                        continue;
                    }
                    if (!name.equalsIgnoreCase("kills") || !(TASK instanceof QuestTaskReputationKill)) continue;
                    ((QuestTaskReputationKill)TASK).setKills(in.nextInt());
                }
                in.endObject();
                return null;
            }
        };
        REPEAT_INFO_ADAPTER = new TypeAdapter<RepeatInfo>(){
            private final String TYPE = "type";
            private final String HOURS = "hours";
            private final String DAYS = "days";

            public void write(JsonWriter out, RepeatInfo value) throws IOException {
                out.beginObject();
                out.name("type").value(value.getType().name());
                if (value.getType().isUseTime()) {
                    out.name("days").value((long)value.getDays());
                    out.name("hours").value((long)value.getHours());
                }
                out.endObject();
            }

            public RepeatInfo read(JsonReader in) throws IOException {
                RepeatType type = RepeatType.NONE;
                int days = 0;
                int hours = 0;
                in.beginObject();
                while (in.hasNext()) {
                    switch (in.nextName().toLowerCase()) {
                        case "type": {
                            type = RepeatType.valueOf(in.nextString());
                            break;
                        }
                        case "hours": {
                            hours = in.nextInt();
                            break;
                        }
                        case "days": {
                            days = in.nextInt();
                        }
                    }
                }
                in.endObject();
                return new RepeatInfo(type, days, hours);
            }
        };
        REPUTATION_REWARD_ADAPTER = new TypeAdapter<Quest.ReputationReward>(){
            private final String REPUTATION = "reputation";
            private final String VALUE = "value";

            public void write(JsonWriter out, Quest.ReputationReward value) throws IOException {
                out.beginObject();
                out.name("reputation").value((long)value.getReputation().getId());
                out.name("value").value((long)value.getValue());
                out.endObject();
            }

            public Quest.ReputationReward read(JsonReader in) throws IOException {
                in.beginObject();
                int rep = 0;
                int val = 0;
                while (in.hasNext()) {
                    switch (in.nextName().toLowerCase()) {
                        case "reputation": {
                            rep = in.nextInt();
                            break;
                        }
                        case "value": {
                            val = in.nextInt();
                        }
                    }
                }
                in.endObject();
                Quest.ReputationReward result = new Quest.ReputationReward(null, val);
                reputationRewardMapping.put(result, rep);
                return result;
            }
        };
        QUEST_ADAPTER = new TypeAdapter<Quest>(){
            private final String NAME = "name";
            private final String DESCRIPTION = "description";
            private final String X = "x";
            private final String Y = "y";
            private final String ICON = "icon";
            private final String BIG_ICON = "bigicon";
            private final String REQUIREMENTS = "requirements";
            private final String PREREQUISITES = "prerequisites";
            private final String OPTIONS = "options";
            private final String OPTIONLINKS = "optionlinks";
            private final String REPEAT = "repeat";
            private final String TRIGGER = "trigger";
            private final String TRIGGER_TASKS = "triggertasks";
            private final String PARENT_REQUIREMENT = "parentrequirement";
            private final String TASKS = "tasks";
            private final String REWARDS = "reward";
            private final String REWARDS_CHOICE = "rewardchoice";
            private final String REWARDS_REPUTATION = "reputationrewards";

            public void write(JsonWriter out, Quest value) throws IOException {
                out.beginObject();
                out.name("name").value(value.getName());
                if (!value.getDescription().equals("Unnamed quest")) {
                    out.name("description").value(value.getDescription());
                }
                out.name("x").value((long)value.getGuiX());
                out.name("y").value((long)value.getGuiY());
                if (value.useBigIcon()) {
                    out.name("bigicon").value(true);
                }
                if (value.getIcon() != null) {
                    MinecraftAdapter.ITEM_STACK.write(out.name("icon"), (Object)value.getIcon());
                }
                this.writeQuestList(out, value.getRequirement(), value.getQuestSet(), "prerequisites");
                this.writeQuestList(out, value.getOptionLinks(), value.getQuestSet(), "optionlinks");
                if (value.getRepeatInfo().getType() != RepeatType.NONE) {
                    REPEAT_INFO_ADAPTER.write(out.name("repeat"), (Object)value.getRepeatInfo());
                }
                if (value.getTriggerType() != TriggerType.NONE) {
                    out.name("trigger").value(value.getTriggerType().name());
                }
                if (value.getTriggerType().isUseTaskCount()) {
                    out.name("triggertasks").value((long)value.getTriggerTasks());
                }
                if (value.getUseModifiedParentRequirement()) {
                    out.name("parentrequirement").value((long)value.getParentRequirementCount());
                }
                if (!value.getTasks().isEmpty()) {
                    out.name("tasks").beginArray();
                    for (QuestTask task : value.getTasks()) {
                        TASK_ADAPTER.write(out, (Object)task);
                    }
                    out.endArray();
                }
                this.writeItemStackArray(out, value.getReward(), "reward");
                this.writeItemStackArray(out, value.getRewardChoice(), "rewardchoice");
                if (value.getReputationRewards() != null && !value.getReputationRewards().isEmpty()) {
                    out.name("reputationrewards").beginArray();
                    for (Quest.ReputationReward reward : value.getReputationRewards()) {
                        REPUTATION_REWARD_ADAPTER.write(out, (Object)reward);
                    }
                    out.endArray();
                }
                out.endObject();
            }

            private String getQuestSaveString(Quest quest, QuestSet set) {
                if (quest.getQuestSet() == set) {
                    return quest.getName();
                }
                return "{" + quest.getQuestSet().getName() + "}[" + quest.getName() + "]";
            }

            private void writeQuestList(JsonWriter out, List<Quest> quests, QuestSet set, String name) throws IOException {
                if (!quests.isEmpty()) {
                    out.name(name).beginArray();
                    for (Quest quest : quests) {
                        out.value(this.getQuestSaveString(quest, set));
                    }
                    out.endArray();
                }
            }

            private void writeItemStackArray(JsonWriter out, ItemStack[] stacks, String name) throws IOException {
                if (stacks != null) {
                    out.name(name).beginArray();
                    for (ItemStack stack : stacks) {
                        if (stack == null) continue;
                        MinecraftAdapter.ITEM_STACK.write(out, (Object)stack);
                    }
                    out.endArray();
                }
            }

            public Quest read(JsonReader in) throws IOException {
                int ID_OFFSET = Quest.size();
                QUEST = new Quest(ID_OFFSET, "", "Unnamed quest", 0, 0, false);
                ArrayList<Integer> requirement = new ArrayList<Integer>();
                ArrayList<Integer> options = new ArrayList<Integer>();
                ArrayList<String> prerequisites = new ArrayList<String>();
                ArrayList<String> optionLinks = new ArrayList<String>();
                in.beginObject();
                block42: while (in.hasNext()) {
                    switch (in.nextName().toLowerCase()) {
                        case "name": {
                            QUEST.setName(in.nextString());
                            continue block42;
                        }
                        case "description": {
                            QUEST.setDescription(in.nextString());
                            continue block42;
                        }
                        case "x": {
                            QUEST.setX(in.nextInt());
                            continue block42;
                        }
                        case "y": {
                            QUEST.setY(in.nextInt());
                            continue block42;
                        }
                        case "triggertasks": {
                            QUEST.setTriggerTasks(in.nextInt());
                            continue block42;
                        }
                        case "parentrequirement": {
                            QUEST.setParentRequirementCount(in.nextInt());
                            continue block42;
                        }
                        case "bigicon": {
                            QUEST.setBigIcon(in.nextBoolean());
                            continue block42;
                        }
                        case "icon": {
                            QUEST.setIcon((ItemStack)MinecraftAdapter.ITEM_STACK.read(in));
                            continue block42;
                        }
                        case "requirements": {
                            this.readIntArray(requirement, in);
                            continue block42;
                        }
                        case "options": {
                            this.readIntArray(options, in);
                            continue block42;
                        }
                        case "prerequisites": {
                            this.readStringArray(prerequisites, in);
                            continue block42;
                        }
                        case "optionlinks": {
                            this.readStringArray(optionLinks, in);
                            continue block42;
                        }
                        case "repeat": {
                            QUEST.setRepeatInfo((RepeatInfo)REPEAT_INFO_ADAPTER.read(in));
                            continue block42;
                        }
                        case "trigger": {
                            QUEST.setTriggerType(TriggerType.valueOf(in.nextString()));
                            continue block42;
                        }
                        case "tasks": {
                            in.beginArray();
                            while (in.hasNext()) {
                                QuestTask task = (QuestTask)TASK_ADAPTER.read(in);
                                if (task == null) continue;
                                QUEST.getTasks().add(task);
                            }
                            in.endArray();
                            continue block42;
                        }
                        case "reward": {
                            QUEST.setReward(this.readItemStackArray(in));
                            continue block42;
                        }
                        case "rewardchoice": {
                            QUEST.setRewardChoice(this.readItemStackArray(in));
                            continue block42;
                        }
                        case "reputationrewards": {
                            in.beginArray();
                            ArrayList<Quest.ReputationReward> reputationRewards = new ArrayList<Quest.ReputationReward>();
                            while (in.hasNext()) {
                                Quest.ReputationReward reward = (Quest.ReputationReward)REPUTATION_REWARD_ADAPTER.read(in);
                                if (reward == null) continue;
                                reputationRewards.add(reward);
                            }
                            QUEST.setReputationRewards(reputationRewards);
                            in.endArray();
                            continue block42;
                        }
                    }
                    QuestLine.getActiveQuestLine().quests.remove(QUEST.getId());
                    return null;
                }
                in.endObject();
                if (!QUEST.getName().isEmpty()) {
                    this.optionalAdd(requirementMapping, requirement);
                    this.optionalAdd(optionMapping, options);
                    this.optionalAdd(prerequisiteMapping, prerequisites);
                    this.optionalAdd(optionLinkMapping, optionLinks);
                    try {
                        if (HardcoreQuesting.getPlayer() != null) {
                            QUEST.addTaskData(QUEST.getQuestData(HardcoreQuesting.getPlayer()));
                        } else {
                            QUEST.addTaskData(QUEST.getQuestData("lorddusk"));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return QUEST;
                }
                QuestLine.getActiveQuestLine().quests.remove(QUEST.getId());
                return null;
            }

            private void optionalAdd(Map map, List list) {
                if (!list.isEmpty()) {
                    map.put(QUEST, list);
                }
            }

            private void readIntArray(List<Integer> list, JsonReader in) throws IOException {
                in.beginArray();
                while (in.hasNext()) {
                    list.add(in.nextInt() + QUEST_ID);
                }
                in.endArray();
            }

            private void readStringArray(List<String> list, JsonReader in) throws IOException {
                in.beginArray();
                while (in.hasNext()) {
                    list.add(in.nextString());
                }
                in.endArray();
            }

            private ItemStack[] readItemStackArray(JsonReader in) throws IOException {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                in.beginArray();
                while (in.hasNext()) {
                    ItemStack stack = (ItemStack)MinecraftAdapter.ITEM_STACK.read(in);
                    if (stack == null) continue;
                    stacks.add(stack);
                }
                in.endArray();
                return stacks.toArray(new ItemStack[stacks.size()]);
            }
        };
        QUEST_SET_ADAPTER = new TypeAdapter<QuestSet>(){
            private final String NAME = "name";
            private final String DESCRIPTION = "description";
            private final String QUESTS = "quests";
            private final String REPUTATION_BAR = "reputationBar";

            public void write(JsonWriter out, QuestSet value) throws IOException {
                reputationBarList.clear();
                out.beginObject();
                out.name("name").value(value.getName());
                if (!value.getDescription().equalsIgnoreCase("No description")) {
                    out.name("description").value(value.getDescription());
                }
                out.name("quests").beginArray();
                for (Quest quest : value.getQuests()) {
                    QUEST_ADAPTER.write(out, (Object)quest);
                }
                out.endArray();
                out.name("reputationBar").beginArray();
                for (ReputationBar reputationBar : value.getReputationBars()) {
                    REPUTATION_BAR_ADAPTER.write(out, (Object)reputationBar);
                }
                out.endArray().endObject();
            }

            public QuestSet read(JsonReader in) throws IOException {
                String name = null;
                String description = "No description";
                requirementMapping.clear();
                optionMapping.clear();
                optionLinkMapping.clear();
                prerequisiteMapping.clear();
                reputationBarList.clear();
                taskReputationListMap.clear();
                ArrayList<Quest> quests = new ArrayList<Quest>();
                in.beginObject();
                while (in.hasNext()) {
                    String next = in.nextName();
                    if (next.equalsIgnoreCase("name")) {
                        name = in.nextString();
                        continue;
                    }
                    if (next.equalsIgnoreCase("description")) {
                        description = in.nextString();
                        continue;
                    }
                    if (next.equalsIgnoreCase("quests")) {
                        in.beginArray();
                        QUEST_ID = Quest.size();
                        while (in.hasNext()) {
                            Quest quest = (Quest)QUEST_ADAPTER.read(in);
                            if (quest == null) continue;
                            quests.add(quest);
                        }
                        in.endArray();
                        continue;
                    }
                    if (!next.equalsIgnoreCase("reputationBar")) continue;
                    in.beginArray();
                    while (in.hasNext()) {
                        reputationBarList.add(REPUTATION_BAR_ADAPTER.read(in));
                    }
                    in.endArray();
                }
                in.endObject();
                QuestSet set = null;
                for (QuestSet questSet : Quest.getQuestSets()) {
                    if (!questSet.getName().equals(name)) continue;
                    set = questSet;
                    set.setDescription(description);
                    this.questReplace(set.getQuests(), quests);
                    break;
                }
                if (name != null && description != null && set == null) {
                    set = new QuestSet(name, description);
                    Quest.getQuestSets().add(set);
                    SaveHelper.add(SaveHelper.EditType.SET_CREATE);
                }
                if (set != null) {
                    int i;
                    Iterator<Object> iterator;
                    for (Quest quest : quests) {
                        quest.setQuestSet(set);
                    }
                    for (Map.Entry entry : requirementMapping.entrySet()) {
                        iterator = ((List)entry.getValue()).iterator();
                        while (iterator.hasNext()) {
                            i = (Integer)iterator.next();
                            ((Quest)entry.getKey()).addRequirement(i);
                        }
                    }
                    for (Map.Entry entry : optionMapping.entrySet()) {
                        iterator = ((List)entry.getValue()).iterator();
                        while (iterator.hasNext()) {
                            i = (Integer)iterator.next();
                            ((Quest)entry.getKey()).addOptionLink(i);
                        }
                    }
                    for (ReputationBar reputationBar : reputationBarList) {
                        for (ReputationBar r : new ArrayList<ReputationBar>(set.getReputationBars())) {
                            if (!r.sameLocation(reputationBar)) continue;
                            set.removeRepBar(r);
                        }
                        set.addRepBar(reputationBar);
                    }
                    return set;
                }
                return this.removeQuestsRaw(quests);
            }

            private QuestSet removeQuestsRaw(List<Quest> quests) {
                for (Quest quest : quests) {
                    QuestLine.getActiveQuestLine().quests.remove(quest.getId());
                }
                return null;
            }

            private void questReplace(List<Quest> existing, List<Quest> replacements) {
                for (Quest current : new ArrayList<Quest>(existing)) {
                    Quest replacement = this.getReplacement(current, replacements);
                    for (Quest requirement : current.getRequirement()) {
                        this.neatSwap(current, replacement, requirement.getReversedRequirement());
                    }
                    for (Quest dependent : current.getReversedRequirement()) {
                        this.neatSwap(current, replacement, dependent.getRequirement());
                    }
                    for (Quest optionLink : current.getOptionLinks()) {
                        this.neatSwap(current, replacement, optionLink.getReversedOptionLinks());
                    }
                    for (Quest optionLink : current.getReversedOptionLinks()) {
                        this.neatSwap(current, replacement, optionLink.getOptionLinks());
                    }
                    for (QuestTask task : current.getTasks()) {
                        task.onDelete();
                    }
                    current.setQuestSet(null);
                    QuestLine.getActiveQuestLine().quests.remove(current.getId());
                }
            }

            private void neatSwap(Quest current, Quest replacement, List<Quest> replaceIn) {
                replaceIn.remove(current);
                if (replacement != null) {
                    replaceIn.add(replacement);
                }
            }

            private Quest getReplacement(Quest quest, List<Quest> replacements) {
                for (Quest replacement : replacements) {
                    if (!quest.getName().equalsIgnoreCase(replacement.getName())) continue;
                    return replacement;
                }
                return null;
            }
        };
        REPUTATION_BAR_ADAPTER = new TypeAdapter<ReputationBar>(){
            private final String X = "x";
            private final String Y = "y";
            private final String REPUTATION_ID = "reputationId";

            public void write(JsonWriter out, ReputationBar value) throws IOException {
                out.beginObject();
                out.name("reputationId").value((long)value.getRepId());
                out.name("x").value((long)value.getX());
                out.name("y").value((long)value.getY());
                out.endObject();
            }

            public ReputationBar read(JsonReader in) throws IOException {
                int y = -1;
                int x = -1;
                int id = -1;
                in.beginObject();
                while (in.hasNext()) {
                    switch (in.nextName()) {
                        case "x": {
                            x = in.nextInt();
                            break;
                        }
                        case "y": {
                            y = in.nextInt();
                            break;
                        }
                        case "reputationId": {
                            id = in.nextInt();
                        }
                    }
                }
                in.endObject();
                if (id * x * y < 0) {
                    return null;
                }
                return new ReputationBar(id, x, y, -1);
            }
        };
        OTHER_QUEST_SET = Pattern.compile("^\\{(.*?)\\}\\[(.*)\\]$");
    }

    private static class ReputationSettingConstructor {
        private int upper;
        private int lower;
        private int reputation;
        boolean inverted;
        private static final String REPUTATION = "reputation";
        private static final String LOWER = "lower";
        private static final String UPPER = "upper";
        private static final String INVERTED = "inverted";

        private ReputationSettingConstructor(int reputation, int lower, int upper, boolean inverted) {
            this.reputation = reputation;
            this.lower = lower;
            this.upper = upper;
            this.inverted = inverted;
        }

        public QuestTaskReputation.ReputationSetting constructReuptationSetting() {
            if (this.reputation >= 0 && this.reputation < Reputation.getReputationList().size()) {
                Reputation reputation = Reputation.getReputationList().get(this.reputation);
                ReputationMarker lower = null;
                ReputationMarker upper = null;
                if (this.lower >= 0 && this.lower < reputation.getMarkerCount()) {
                    lower = reputation.getMarker(this.lower);
                }
                if (this.upper >= 0 && this.upper < reputation.getMarkerCount()) {
                    upper = reputation.getMarker(this.lower);
                }
                return new QuestTaskReputation.ReputationSetting(reputation, lower, upper, this.inverted);
            }
            return null;
        }

        public static ReputationSettingConstructor read(JsonReader in) throws IOException {
            in.beginObject();
            int low = Integer.MIN_VALUE;
            int high = Integer.MIN_VALUE;
            int reputation = -1;
            boolean inverted = false;
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equalsIgnoreCase(REPUTATION)) {
                    reputation = in.nextInt();
                    continue;
                }
                if (name.equalsIgnoreCase(UPPER)) {
                    high = in.nextInt();
                    continue;
                }
                if (name.equalsIgnoreCase(LOWER)) {
                    low = in.nextInt();
                    continue;
                }
                if (!name.equalsIgnoreCase(INVERTED)) continue;
                inverted = in.nextBoolean();
            }
            if (reputation < 0) {
                return null;
            }
            in.endObject();
            return new ReputationSettingConstructor(reputation, low, high, inverted);
        }
    }
}

