/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.sounds;

import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.QuestingData;
import hardcorequesting.client.sounds.ClientSound;
import hardcorequesting.client.sounds.LoreResourcePack;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.network.DataReader;
import hardcorequesting.network.DataWriter;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.network.PacketId;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class SoundHandler {
    private static List<String> paths = new ArrayList<String>();
    private static final String LABEL = "lore";
    private static int loreNumber;
    private static boolean loreMusic;
    @SideOnly(value=Side.CLIENT)
    private static ISound loreSound;
    private static int bitCount;

    private SoundHandler() {
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean loadLoreReading(String path) {
        loreMusic = false;
        loreNumber = -1;
        int index = paths.indexOf(path);
        if (index == -1) {
            if (new File(path + "lore.ogg").exists()) {
                int number = paths.size();
                Map resourceManagers = (Map)ReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()), (int)2);
                FallbackResourceManager resourceManager = (FallbackResourceManager)resourceManagers.get("hqm");
                resourceManager.func_110538_a((IResourcePack)new LoreResourcePack(new File(path)));
                net.minecraft.client.audio.SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
                SoundList list = new SoundList();
                list.func_148571_a(SoundCategory.MASTER);
                SoundList.SoundEntry entry = new SoundList.SoundEntry();
                entry.func_148561_a(LABEL + number);
                list.func_148570_a().add(entry);
                Method method = ReflectionHelper.findMethod(net.minecraft.client.audio.SoundHandler.class, (Object)handler, (String[])new String[]{"loadSoundResource", "func_147693_a", "a"}, (Class[])new Class[]{ResourceLocation.class, SoundList.class});
                if (method == null || handler == null) {
                    return false;
                }
                try {
                    method.invoke((Object)handler, new ResourceLocation("hqm", LABEL + number), list);
                    loreMusic = true;
                    loreNumber = number;
                    paths.add(path);
                    return true;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        } else {
            loreNumber = index;
            loreMusic = true;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playLoreMusic() {
        loreSound = SoundHandler.play(LABEL + loreNumber, 4.0f, 1.0f);
    }

    private static int getBitCount() {
        if (bitCount == -1) {
            bitCount = (int)(Math.log10(Sounds.values().length + 1) / Math.log10(2.0)) + 1;
        }
        return bitCount;
    }

    public static void play(Sounds sound, EntityPlayer player) {
        DataWriter dw = PacketHandler.getWriter(PacketId.SOUND);
        dw.writeData(sound.ordinal(), SoundHandler.getBitCount());
        PacketHandler.sendToRawPlayer(player, dw);
    }

    public static void playToAll(Sounds sound) {
        DataWriter dw = PacketHandler.getWriter(PacketId.SOUND);
        dw.writeData(sound.ordinal(), SoundHandler.getBitCount());
        PacketHandler.sendToAllPlayers(dw);
    }

    @SideOnly(value=Side.CLIENT)
    private static ISound play(String sound, float volume, float pitch) {
        return SoundHandler.play(new ResourceLocation("hqm", sound), volume, pitch);
    }

    @SideOnly(value=Side.CLIENT)
    private static ISound play(ResourceLocation resource, float volume, float pitch) {
        ClientSound soundObj = new ClientSound(resource, volume, pitch);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)soundObj);
        return soundObj;
    }

    public static void stopLoreMusic() {
        if (SoundHandler.isLorePlaying()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SoundHandler.isLorePlaying()) {
                        Minecraft.func_71410_x().func_147118_V().func_147683_b(loreSound);
                    }
                    loreSound = null;
                }
            }).start();
        }
    }

    public static boolean isLorePlaying() {
        boolean value;
        boolean bl = value = loreSound != null && Minecraft.func_71410_x().func_147118_V().func_147692_c(loreSound);
        if (!value) {
            loreSound = null;
        }
        return value;
    }

    public static boolean hasLoreMusic() {
        return loreMusic;
    }

    public static void handleSoundPacket(DataReader dr) {
        int id = dr.readData(SoundHandler.getBitCount());
        SoundHandler.play(Sounds.values()[id].getSound(), 1.0f, 1.0f);
    }

    public static void triggerFirstLore() {
        PacketHandler.sendToServer(PacketHandler.getWriter(PacketId.LORE));
        SoundHandler.playLoreMusic();
    }

    public static void handleLorePacket(EntityPlayer player, DataReader dr) {
        QuestingData.getQuestingData((EntityPlayer)player).playedLore = true;
    }

    static {
        loreMusic = false;
        bitCount = -1;
    }
}

