/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import hardcorequesting.QuestingData;
import hardcorequesting.Translator;
import hardcorequesting.config.ModConfig;
import hardcorequesting.network.PacketHandler;
import hardcorequesting.quests.QuestLine;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class PlayerTracker {
    public PlayerTracker() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public int getRemainingLives(ICommandSender sender) {
        return QuestingData.getQuestingData((EntityPlayer)sender).getLives();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (!QuestingData.hasData(player)) {
            QuestingData.getQuestingData(player).getDeathStat().refreshSync();
        }
        QuestLine.sendServerSync(player);
        if (QuestingData.isHardcoreActive()) {
            this.sendLoginMessage(player);
        } else if (ModConfig.NO_HARDCORE_MESSAGE) {
            player.func_145747_a((IChatComponent)new ChatComponentTranslation("hqm.message.noHardcore", new Object[0]));
        }
        NBTTagCompound tags = player.getEntityData();
        if (tags.func_74764_b("HardcoreQuesting")) {
            if (tags.func_74775_l("HardcoreQuesting").func_74767_n("questBook")) {
                QuestingData.getQuestingData((EntityPlayer)player).receivedBook = true;
            }
            if (QuestingData.isQuestActive()) {
                tags.func_82580_o("HardcoreQuesting");
            }
        }
        QuestingData.spawnBook(player);
    }

    private void sendLoginMessage(EntityPlayer player) {
        player.func_145747_a((IChatComponent)new ChatComponentText(Translator.translate("hqm.message.hardcore") + " " + Translator.translate(this.getRemainingLives((ICommandSender)player) != 1, "hqm.message.livesLeft", this.getRemainingLives((ICommandSender)player))));
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.remove(player);
        }
    }
}

