/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.railcraft;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import java.util.List;
import mods.railcraft.api.crafting.IBlastFurnaceRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerBlastFurnace
extends RecipeHandlerBase {
    private static List<ItemStack> fuels;
    private static Class<? extends GuiContainer> guiClass;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("mods.railcraft.client.gui.GuiBlastFurnace");
        fuels = RailcraftCraftingManager.blastFurnace.getFuels();
    }

    public String getRecipeName() {
        return Utils.translate("railcraft.gui.blast.furnace", false);
    }

    @Override
    public String getRecipeID() {
        return "railcraft.blastfurnace";
    }

    public String getGuiTexture() {
        return "textures/gui/container/furnace.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(74, 23, 24, 18);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawExtras(int recipe) {
        GuiDraw.drawStringC((String)(((CachedBlastFurnaceRecipe)((Object)this.arecipes.get((int)recipe))).cookTime + " " + Utils.translate("ticks")), (int)120, (int)6, (int)0x808080, (boolean)false);
        this.changeToGuiTexture();
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (IBlastFurnaceRecipe recipe : RailcraftCraftingManager.blastFurnace.getRecipes()) {
            if (recipe == null) continue;
            this.arecipes.add(new CachedBlastFurnaceRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (IBlastFurnaceRecipe recipe : RailcraftCraftingManager.blastFurnace.getRecipes()) {
            if (recipe == null || !NEIServerUtils.areStacksSameType((ItemStack)result, (ItemStack)recipe.getOutput())) continue;
            this.arecipes.add(new CachedBlastFurnaceRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingredient) {
        for (IBlastFurnaceRecipe recipe : RailcraftCraftingManager.blastFurnace.getRecipes()) {
            if (recipe == null || !Utils.areStacksSameTypeCraftingSafe(recipe.getInput(), ingredient)) continue;
            this.arecipes.add(new CachedBlastFurnaceRecipe(recipe));
        }
        for (ItemStack fuel : fuels) {
            if (!Utils.areStacksSameTypeCraftingSafe(fuel, ingredient)) continue;
            for (IBlastFurnaceRecipe recipe : RailcraftCraftingManager.blastFurnace.getRecipes()) {
                if (recipe == null) continue;
                this.arecipes.add(new CachedBlastFurnaceRecipe(recipe, ingredient));
            }
        }
    }

    public class CachedBlastFurnaceRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedStack input;
        public PositionedStack output;
        public PositionedStack fuel;
        public int cookTime;

        public CachedBlastFurnaceRecipe(IBlastFurnaceRecipe recipe) {
            if (recipe.getInput() != null) {
                this.input = new PositionedStack((Object)recipe.getInput(), 51, 6);
            }
            if (recipe.getOutput() != null) {
                this.output = new PositionedStack((Object)recipe.getOutput(), 111, 24);
            }
            this.cookTime = recipe.getCookTime();
        }

        public CachedBlastFurnaceRecipe(IBlastFurnaceRecipe recipe, ItemStack fuel) {
            this(recipe);
            this.fuel = new PositionedStack((Object)fuel, 51, 42);
        }

        public PositionedStack getIngredient() {
            this.randomRenderPermutation(this.input, RecipeHandlerBlastFurnace.this.cycleticks / 20);
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getOtherStack() {
            if (this.fuel != null) {
                return this.fuel;
            }
            if (fuels.size() > 0) {
                return new PositionedStack(fuels.get(RecipeHandlerBlastFurnace.this.cycleticks / 48 % fuels.size()), 51, 42);
            }
            return null;
        }
    }
}

