/*
 * Decompiled with CFR 0.152.
 */
package com.cricketcraft.ftbisland;

import com.cricketcraft.ftbisland.FTBIslands;
import com.cricketcraft.ftbisland.IslandCreator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class IslandUtils {
    public static boolean createIsland(World world, String playerName, EntityPlayer player) {
        IslandCreator.reloadIslands();
        if (IslandCreator.islandLocations == null) {
            FTBIslands.logger.info("Island locations are null?? Empty possibly.");
            return false;
        }
        IslandCreator.IslandPos pos = FTBIslands.islandLoc.get(IslandCreator.islandLocations.size() + 1);
        IslandCreator.spawnIslandAt(world, pos.getX(), pos.getY(), pos.getZ(), playerName, (EntityPlayer)(player != null ? player : null));
        return true;
    }

    public static void renameIsland(String oldName, String newName) {
        IslandCreator.IslandPos pos = IslandCreator.islandLocations.get(oldName);
        IslandCreator.islandLocations.remove(oldName);
        IslandCreator.islandLocations.put(newName, pos);
        IslandCreator.save();
    }

    public static void setSpawnForIsland(String s, int x, int y, int z) {
        IslandCreator.IslandPos pos = new IslandCreator.IslandPos(x, y, z);
        IslandCreator.islandLocations.remove(s);
        IslandCreator.islandLocations.put(s, pos);
        IslandCreator.save();
    }

    public static void joinIsland(String islandName, EntityPlayer player) {
        if (player == null) {
            FTBIslands.logger.info("The join command must be run in game.");
        } else {
            IslandCreator.reloadIslands();
            if (IslandCreator.islandLocations.containsKey(islandName)) {
                double xAndZ;
                IslandCreator.IslandPos pos = new IslandCreator.IslandPos(0, 60, 0);
                for (String key : IslandCreator.islandLocations.keySet()) {
                    if (!key.equalsIgnoreCase(islandName)) continue;
                    pos = IslandCreator.islandLocations.get(key);
                }
                if (player.field_71093_bK != 0) {
                    player.func_71027_c(0);
                }
                int x = pos.getX();
                int y = pos.getY();
                int z = pos.getZ();
                int height = FTBIslands.islandType.equalsIgnoreCase("tree") ? 6 : 2;
                double d = xAndZ = FTBIslands.islandType.equalsIgnoreCase("grass") ? 0.5 : 1.5;
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    playerMP.func_70634_a((double)x + xAndZ, (double)(y + height), (double)z + xAndZ);
                }
            } else {
                player.func_146105_b((IChatComponent)new ChatComponentText("Island does not exist!"));
            }
        }
    }

    public static void deleteIsland(String islandName) {
        IslandCreator.islandLocations.remove(islandName);
        IslandCreator.save();
    }
}

