/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.SiftingResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.registry.data.ItemAndMetadata;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class HeavySieveRegistry {
    private static final Multimap<ItemAndMetadata, SiftingResult> siftables = ArrayListMultimap.create();
    private static Configuration config;

    private static void register(Block source, int sourceMeta, Item output, int outputMeta, int rarity) {
        if (source == null || output == null || rarity <= 0) {
            return;
        }
        siftables.put((Object)new ItemAndMetadata(source, sourceMeta), (Object)new SiftingResult(output, outputMeta, rarity));
    }

    public static Collection<SiftingResult> getSiftingOutput(Block block, int metadata) {
        return HeavySieveRegistry.getSiftingOutput(new ItemAndMetadata(block, metadata));
    }

    public static Collection<SiftingResult> getSiftingOutput(ItemStack itemStack) {
        return HeavySieveRegistry.getSiftingOutput(new ItemAndMetadata(itemStack));
    }

    public static Collection<SiftingResult> getSiftingOutput(ItemAndMetadata itemInfo) {
        return siftables.get((Object)itemInfo);
    }

    public static boolean isRegistered(ItemStack itemStack) {
        return siftables.containsKey((Object)new ItemAndMetadata(itemStack));
    }

    public static boolean isRegistered(Block block, int metadata) {
        return siftables.containsKey((Object)new ItemAndMetadata(block, metadata));
    }

    public static void load(Configuration config) {
        HeavySieveRegistry.config = config;
        HeavySieveRegistry.reload();
    }

    public static void reload() {
        String[] siftables;
        String[] generatedSiftables;
        HeavySieveRegistry.siftables.clear();
        for (String siftable : generatedSiftables = config.getStringList("Generate Heavy Siftables", "registries", new String[]{"ExtraUtilities:cobblestone_compressed:8=minecraft:dirt:0:1:6", "excompressum:compressed_dust:4=minecraft:dirt:0:1:6", "ExtraUtilities:cobblestone_compressed:12=minecraft:gravel:0:1:6", "excompressum:compressed_dust:2=minecraft:gravel:0:1:6", "ExtraUtilities:cobblestone_compressed:14=minecraft:sand:0:1:6", "excompressum:compressed_dust:3=minecraft:sand:0:1:6", "excompressum:compressed_dust=exnihilo:dust:0:1:6", "excompressum:compressed_dust:6=minecraft:stone:0:1:6", "excompressum:compressed_dust:7=minecraft:netherrack:0:1:6"}, "Here you can map normal siftables to heavy siftable blocks to automatically generate rewards for them based on ExNihilo's registry. Format: modid:name:meta=modid:name:meta:rarityMultiplier:amountMultiplier")) {
            String[] s = siftable.split("=");
            if (s.length < 2) {
                ExCompressum.logger.error("Skipping heavy siftable mapping " + siftable + " due to invalid format");
                continue;
            }
            String[] source = s[0].split(":");
            if (source[0].equals("ore") && source.length >= 2) {
                String oreName = source[1];
                List ores = OreDictionary.getOres((String)oreName, (boolean)false);
                if (!ores.isEmpty()) {
                    for (ItemStack ore : ores) {
                        if (ore.func_77973_b() instanceof ItemBlock) {
                            HeavySieveRegistry.mapSiftable(((ItemBlock)ore.func_77973_b()).field_150939_a, ore.func_77973_b().func_77647_b(ore.func_77960_j()), s[1]);
                            continue;
                        }
                        ExCompressum.logger.error("Skipping heavy siftable mapping " + siftable + " because the source block is not a block");
                    }
                    continue;
                }
                ExCompressum.logger.error("Skipping heavy siftable mapping " + siftable + " because no ore dictionary entries found");
                continue;
            }
            Block sourceBlock = source.length == 1 ? GameRegistry.findBlock((String)"minecraft", (String)source[0]) : GameRegistry.findBlock((String)source[0], (String)source[1]);
            if (sourceBlock == null) {
                ExCompressum.logger.error("Skipping heavy siftable mapping " + siftable + " because the source block was not found");
            }
            int sourceMeta = 0;
            if (source.length >= 3) {
                sourceMeta = source[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(source[2]);
            }
            HeavySieveRegistry.mapSiftable(sourceBlock, sourceMeta, s[1]);
        }
        for (String siftable : siftables = config.getStringList("Heavy Siftables", "registries", new String[0], "Here you can add additional siftables for the heavy sieve. Format: modid:name:meta=modid:name:meta:rarity")) {
            String[] s = siftable.split("=");
            if (s.length < 2) {
                ExCompressum.logger.error("Skipping siftable " + siftable + " due to invalid format");
                continue;
            }
            String[] source = s[0].split(":");
            if (source[0].equals("ore") && source.length >= 2) {
                String oreName = source[1];
                List ores = OreDictionary.getOres((String)oreName, (boolean)false);
                if (!ores.isEmpty()) {
                    for (ItemStack ore : ores) {
                        if (ore.func_77973_b() instanceof ItemBlock) {
                            HeavySieveRegistry.loadSiftable(((ItemBlock)ore.func_77973_b()).field_150939_a, ore.func_77973_b().func_77647_b(ore.func_77960_j()), s[1]);
                            continue;
                        }
                        ExCompressum.logger.error("Skipping siftable " + siftable + " because the source block is not a block");
                    }
                    continue;
                }
                ExCompressum.logger.error("Skipping siftable " + siftable + " because no ore dictionary entries found");
                continue;
            }
            Block sourceBlock = source.length == 1 ? GameRegistry.findBlock((String)"minecraft", (String)source[0]) : GameRegistry.findBlock((String)source[0], (String)source[1]);
            if (sourceBlock == null) {
                ExCompressum.logger.error("Skipping siftable " + siftable + " because the source block was not found");
                continue;
            }
            int sourceMeta = 0;
            if (source.length >= 3) {
                sourceMeta = source[2].equals("*") ? Short.MAX_VALUE : Integer.parseInt(source[2]);
            }
            HeavySieveRegistry.loadSiftable(sourceBlock, sourceMeta, s[1]);
        }
    }

    private static void loadSiftable(Block sourceBlock, int sourceMeta, String reward) {
        String[] s = reward.split(":");
        if (s.length < 4) {
            ExCompressum.logger.error("Skipping siftable " + reward + " due to invalid format");
            return;
        }
        Item rewardItem = GameRegistry.findItem((String)s[0], (String)s[1]);
        if (rewardItem == null) {
            ExCompressum.logger.error("Skipping siftable " + reward + " due to reward item not found");
            return;
        }
        int rewardMeta = Integer.parseInt(s[2]);
        HeavySieveRegistry.register(sourceBlock, sourceMeta, rewardItem, rewardMeta, Integer.parseInt(s[3]));
    }

    private static void mapSiftable(Block sourceBlock, int sourceMeta, String mapping) {
        String[] s = mapping.split(":");
        if (s.length < 5) {
            ExCompressum.logger.error("Skipping heavy siftable mapping " + mapping + " due to invalid format");
            return;
        }
        Block mappedBlock = GameRegistry.findBlock((String)s[0], (String)s[1]);
        if (mappedBlock == null) {
            ExCompressum.logger.error("Skipping heavy siftable mapping " + mapping + " due to mapped block not found");
            return;
        }
        int mappedMeta = Integer.parseInt(s[2]);
        ArrayList results = SieveRegistry.getSiftingOutput((Block)mappedBlock, (int)mappedMeta);
        if (results == null || results.isEmpty()) {
            ExCompressum.logger.error("Skipping heavy siftable mapping " + mapping + " due to not being registered in Ex Nihilo");
            return;
        }
        float rarityMultiplier = Float.parseFloat(s[3]);
        int amountMultiplier = Integer.parseInt(s[4]);
        for (SiftingResult result : results) {
            for (int i = 0; i < amountMultiplier; ++i) {
                HeavySieveRegistry.register(sourceBlock, sourceMeta, result.item, result.meta, Math.round(Math.max(1.0f, (float)result.rarity / rarityMultiplier)));
            }
        }
    }

    public static Multimap<ItemAndMetadata, SiftingResult> getSiftables() {
        return siftables;
    }
}

