/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.tconstruct;

import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.ArrayList;
import java.util.Random;
import net.blay09.mods.excompressum.ModItems;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.compat.tconstruct.ActiveSmashingMod;
import net.blay09.mods.excompressum.compat.tconstruct.ModSmashingII;
import net.blay09.mods.excompressum.item.ItemDoubleCompressedDiamondHammer;
import net.blay09.mods.excompressum.registry.CompressedHammerRegistry;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.world.BlockEvent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ModifyBuilder;
import tconstruct.library.modifier.ItemModifier;
import tconstruct.library.tools.AbilityHelper;

public class TConstructAddon
implements IAddon {
    private boolean enableModifiers;

    @Override
    public void loadConfig(Configuration config) {
        this.enableModifiers = config.getBoolean("Enable Smashing II Modifier", "compat.tconstruct", true, "If set to true, adding a double compressed diamond hammer will add the Smashing II modifier to a Tinkers Construct tool, which allows smashing of compressed blocks.");
    }

    @Override
    public void postInit() {
        if (this.enableModifiers) {
            ItemDoubleCompressedDiamondHammer.registerRecipes();
            ModifyBuilder.registerModifier((ItemModifier)new ModSmashingII(new ItemStack[]{new ItemStack((Item)ModItems.doubleCompressedDiamondHammer, 1, 0)}));
            TConstructRegistry.registerActiveToolMod((ActiveToolMod)new ActiveSmashingMod());
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void serverStarted(FMLServerStartedEvent event) {
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester == null) {
            return;
        }
        ItemStack itemStack = event.harvester.func_70694_bm();
        if (itemStack == null) {
            return;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return;
        }
        NBTTagCompound tags = tagCompound.func_74775_l("InfiTool");
        if (tags.func_74767_n("Smashing II")) {
            if (event.world.field_72995_K || event.isSilkTouching) {
                return;
            }
            ArrayList rewards = CompressedHammerRegistry.getSmashables(event.block, event.blockMetadata);
            if ((rewards == null || rewards.isEmpty()) && ((rewards = HammerRegistry.getRewards((Block)event.block, (int)event.blockMetadata)) == null || rewards.isEmpty())) {
                return;
            }
            event.drops.clear();
            event.dropChance = 1.0f;
            for (Smashable reward : rewards) {
                if (!(event.world.field_73012_v.nextFloat() <= reward.chance + reward.luckMultiplier * (float)event.fortuneLevel)) continue;
                event.drops.add(new ItemStack(reward.item, 1, reward.meta));
            }
            AbilityHelper.onBlockChanged((ItemStack)itemStack, (World)event.world, (Block)event.block, (int)event.x, (int)event.y, (int)event.z, (EntityLivingBase)event.harvester, (Random)AbilityHelper.random);
        }
    }
}

