/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.Collections;
import java.util.List;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.ExCompressumCreativeTab;
import net.blay09.mods.excompressum.ModBlocks;
import net.blay09.mods.excompressum.ModItems;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.entity.EntityAngryChicken;
import net.blay09.mods.excompressum.handler.ChickenStickHandler;
import net.blay09.mods.excompressum.handler.CompressedEnemyHandler;
import net.blay09.mods.excompressum.handler.GuiHandler;
import net.blay09.mods.excompressum.registry.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.ChickenStickRegistry;
import net.blay09.mods.excompressum.registry.CompressedHammerRegistry;
import net.blay09.mods.excompressum.registry.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.registry.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.WoodenCrucibleRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="excompressum", name="Ex Compressum", dependencies="required-after:exnihilo")
public class ExCompressum {
    public static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "excompressum";
    @Mod.Instance
    public static ExCompressum instance;
    @SidedProxy(serverSide="net.blay09.mods.excompressum.CommonProxy", clientSide="net.blay09.mods.excompressum.client.ClientProxy")
    public static CommonProxy proxy;
    private Configuration config;
    public static float compressedCrookDurabilityMultiplier;
    public static float compressedCrookSpeedMultiplier;
    public static boolean allowHeavySieveAutomation;
    public static boolean woodenCrucibleBarrelRecipes;
    public static float woodenCrucibleSpeed;
    public static boolean woodenCrucibleFillFromRain;
    public static float baitWolfChance;
    public static float baitOcelotChance;
    public static float baitCowChance;
    public static float baitPigChance;
    public static float baitChickenChance;
    public static float baitSheepChance;
    public static float baitSquidChance;
    public static float baitChildChance;
    public static float createChickenStickChance;
    public static float compressedMobChance;
    public static int compressedMobSize;
    public static List<String> compressedMobs;
    public static int autoHammerEnergy;
    public static float autoHammerSpeed;
    public static int autoCompressedHammerEnergy;
    public static float autoCompressedHammerSpeed;
    public static int autoCompressorEnergy;
    public static float autoCompressorSpeed;
    public static int autoHeavySieveEnergy;
    public static float autoHeavySieveSpeed;
    public static int autoSieveEnergy;
    public static float autoSieveSpeed;
    public static float autoSieveBookDecay;
    public static float autoHammerDecay;
    public static boolean skipAutoSieveSkins;
    public static final ExCompressumCreativeTab creativeTab;
    public final List<IAddon> addons = Lists.newArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        compressedCrookDurabilityMultiplier = this.config.getFloat("Compressed Crook Durability Multiplier", "general", 2.0f, 0.1f, 10.0f, "The multiplier applied to the Compressed Crook's durability (based on the normal wooden crook)");
        compressedCrookSpeedMultiplier = this.config.getFloat("Compressed Crook Speed Multiplier", "general", 4.0f, 0.1f, 10.0f, "The multiplier applied to the Compressed Crook's speed (based on the normal wooden crook)");
        allowHeavySieveAutomation = this.config.getBoolean("Allow Heavy Sieve Automation", "general", false, "Set this to true if you want to allow automation of the heavy sieve through fake players (i.e. Autonomous Activator)");
        woodenCrucibleBarrelRecipes = this.config.getBoolean("Allow Barrel Recipes in Wooden Crucible", "general", true, "Set this to true to have barrel recipes work in a Wooden Crucible (e.g. Water + Dust = Clay)");
        woodenCrucibleSpeed = this.config.getFloat("Wooden Crucible Speed", "general", 0.5f, 0.1f, 1.0f, "The speed at which the wooden crucible extracts water. 0.1 is equivalent to a torch below a crucible, 0.3 is equivalent to fire below a crucible.");
        woodenCrucibleFillFromRain = this.config.getBoolean("Allow Wooden Crucible filling from Rain", "general", true, "Set this to true to allow wooden crucibles to fill from rain.");
        baitWolfChance = this.config.getFloat("Wolf Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that a wolf bait will result in a wolf spawn.");
        baitOcelotChance = this.config.getFloat("Ocelot Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that an ocelot bait will result in an ocelot spawn.");
        baitCowChance = this.config.getFloat("Cow Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that a cow bait will result in a cow spawn.");
        baitPigChance = this.config.getFloat("Pig Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that a pig bait will result in a pig spawn.");
        baitChickenChance = this.config.getFloat("Chicken Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that a chicken bait will result in a chicken spawn.");
        baitSheepChance = this.config.getFloat("Sheep Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that a sheep bait will result in a sheep spawn.");
        baitSquidChance = this.config.getFloat("Squid Bait Chance", "baits", 5.0E-4f, 1.0E-4f, 1.0f, "The chance (per tick) that a squid bait will result in a squid spawn.");
        baitChildChance = this.config.getFloat("Bait Child Chance", "baits", 0.5f, 0.0f, 1.0f, "The chance that an animal spawned from a bait will result in a child.");
        createChickenStickChance = this.config.getFloat("Create Chicken Stick Chance", "general", 0.2f, 0.0f, 1.0f, "The chance that hitting a chicken with a stick will create a chicken stick. 0 means disabled.");
        autoHammerSpeed = this.config.getFloat("Auto Hammer Speed", "general", 0.01f, 1.0E-4f, 0.1f, "The speed at which the auto hammer will smash stuff.");
        autoHammerEnergy = this.config.getInt("Auto Hammer Cost", "general", 40, 0, 100000, "The energy cost of the auto hammer per tick.");
        autoCompressedHammerSpeed = this.config.getFloat("Auto Compressed Hammer Speed", "general", 0.005f, 1.0E-4f, 0.1f, "The speed at which the auto compressed hammer will smash stuff.");
        autoCompressedHammerEnergy = this.config.getInt("Auto Compressed Hammer Cost", "general", 120, 0, 100000, "The energy cost of the auto compressed hammer per tick.");
        autoHeavySieveSpeed = this.config.getFloat("Auto Heavy Sieve Speed", "general", 0.005f, 1.0E-4f, 0.1f, "The speed at which the auto heavy sieve will sift stuff.");
        autoHeavySieveEnergy = this.config.getInt("Auto Heavy Sieve Cost", "general", 80, 0, 100000, "The energy cost of the auto heavy sieve per tick.");
        autoSieveSpeed = this.config.getFloat("Auto Sieve Speed", "general", 0.005f, 1.0E-4f, 0.1f, "The speed at which the auto sieve will sift stuff.");
        autoSieveEnergy = this.config.getInt("Auto Sieve Cost", "general", 40, 0, 100000, "The energy cost of the auto sieve per tick.");
        autoCompressorSpeed = this.config.getFloat("Auto Compressor Speed", "general", 0.1f, 1.0E-4f, 1.0f, "The speed at which the auto compressor will compress stuff.");
        autoCompressorEnergy = this.config.getInt("Auto Compressor Cost", "general", 5, 0, 100000, "The energy cost of the auto compressor per tick.");
        autoSieveBookDecay = this.config.getFloat("Auto Sieve Book Decay", "general", 0.003f, 0.0f, 0.1f, "The chance for the enchantment on books in a sieve to lose a level (per operation)");
        autoHammerDecay = this.config.getFloat("Auto Hammer Decay", "general", 0.5f, 0.0f, 0.1f, "The chance for the upgrade hammers in an auto hammer to lose durability (per operation)");
        skipAutoSieveSkins = this.config.getBoolean("Skip Auto Sieve Skins", "general", false, "Set this to true to disable the loading of auto sieve skins from a remote server.");
        compressedMobChance = this.config.getFloat("Compressed Mob Chance", "general", 0.01f, 0.0f, 1.0f, "The chance for mobs to spawn as Compressed Mobs. Set to 0 to disable.");
        compressedMobSize = this.config.getInt("Compressed Mob Size", "general", 9, 1, 9, "The amount of mobs that will spawn upon death of a compressed enemy.");
        Collections.addAll(compressedMobs, this.config.getStringList("Compressed Mobs", "general", new String[]{"Zombie", "Creeper", "Skeleton", "Spider", "CaveSpider", "Silverfish", "Witch", "Enderman", "PigZombie", "Blaze", "Chicken", "Sheep", "Cow", "Pig", "Ghast"}, "A list of entity names that can spawn as compressed entities."));
        ModItems.init();
        ModBlocks.init();
        EntityRegistry.registerModEntity(EntityAngryChicken.class, (String)"AngryChicken", (int)0, (Object)this, (int)64, (int)5, (boolean)true);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedEnemyHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenStickHandler());
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"net.blay09.mods.excompressum.compat.waila.WailaProvider.register");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModItems.registerRecipes(this.config);
        ModBlocks.registerRecipes(this.config);
        boolean easyMode = this.config.getBoolean("Easy Mode", "general", false, "Set this to true to enable easy-mode, which makes compressed smashables work for normal hammers instead.");
        CompressedHammerRegistry.load(this.config, easyMode);
        ChickenStickRegistry.load(this.config);
        HeavySieveRegistry.load(this.config);
        CompressedRecipeRegistry.reload();
        WoodenCrucibleRegistry.load(this.config);
        AutoSieveSkinRegistry.load();
        boolean isLegacyMineTweaker = true;
        try {
            Class<?> mtClass = Class.forName("minetweaker.MineTweakerImplementationAPI");
            mtClass.getMethod("onPostReload", Class.forName("minetweaker.util.IEventHandler"));
            isLegacyMineTweaker = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (isLegacyMineTweaker) {
            this.registerAddon(event, "MineTweaker3", "net.blay09.mods.excompressum.compat.minetweaker.MineTweakerAddonLegacy");
        } else {
            this.registerAddon(event, "MineTweaker3", "net.blay09.mods.excompressum.compat.minetweaker.MineTweakerAddon");
        }
        this.registerAddon(event, "Botania", "net.blay09.mods.excompressum.compat.botania.BotaniaAddon");
        this.registerAddon(event, "TConstruct", "net.blay09.mods.excompressum.compat.tconstruct.TConstructAddon");
        this.registerAddon(event, "IguanaTweaksTConstruct", "net.blay09.mods.excompressum.compat.iguanatweakstconstruct.IguanaTweaksTConstructAddon");
        for (IAddon addon : this.addons) {
            addon.loadConfig(this.config);
            addon.postInit();
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
        proxy.postInit(event);
    }

    private void registerAddon(FMLPostInitializationEvent event, String modid, String className) {
        IAddon addon = (IAddon)event.buildSoftDependProxy(modid, className);
        if (addon != null) {
            this.addons.add(addon);
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        for (IAddon addon : this.addons) {
            addon.serverStarted(event);
        }
    }

    static {
        compressedMobs = Lists.newArrayList();
        creativeTab = new ExCompressumCreativeTab();
    }
}

