/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.renderers.blocks;

import com.InfinityRaider.AgriCraft.AgriCraft;
import com.InfinityRaider.AgriCraft.renderers.TessellatorV2;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityAgricraft;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class RenderBlockBase
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    private static HashMap<Block, Integer> renderIds = new HashMap();
    public static final int COLOR_MULTIPLIER_STANDARD = 0xFFFFFF;
    private final Block block;

    protected RenderBlockBase(Block block, boolean inventory) {
        this(block, null, inventory);
    }

    protected RenderBlockBase(Block block, TileEntity te, boolean inventory) {
        this.block = block;
        if (!renderIds.containsKey(block)) {
            this.registerRenderer(block, te);
        }
        if (inventory) {
            MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)block), (IItemRenderer)this);
        }
    }

    private void registerRenderer(Block block, TileEntity te) {
        if (te != null && this.shouldBehaveAsTESR()) {
            ClientRegistry.bindTileEntitySpecialRenderer(te.getClass(), (TileEntitySpecialRenderer)this);
            renderIds.put(block, -1);
        }
        if (this.shouldBehaveAsISBRH()) {
            int id = RenderingRegistry.getNextAvailableRenderId();
            RenderingRegistry.registerBlockHandler((int)id, (ISimpleBlockRenderingHandler)this);
            renderIds.put(block, id);
        }
    }

    private boolean renderBlock(Tessellator tessellator, IBlockAccess world, double x, double y, double z, Block block, TileEntity tile, float f, int modelId, RenderBlocks renderer, boolean callFromTESR) {
        if (callFromTESR) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
        } else {
            if (tessellator instanceof TessellatorV2) {
                ((TessellatorV2)tessellator).setRotation(0.0, 0.0, 0.0, 0.0);
            }
            tessellator.func_78372_c((float)x, (float)y, (float)z);
        }
        if (tile != null && tile instanceof TileEntityAgricraft) {
            this.rotateMatrix((TileEntityAgricraft)tile, tessellator, false);
        }
        tessellator.func_78380_c(block.func_149677_c(world, (int)x, (int)y, (int)z));
        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        boolean result = this.doWorldRender(tessellator, world, x, y, z, tile, block, f, modelId, renderer, callFromTESR);
        if (tile != null && tile instanceof TileEntityAgricraft) {
            this.rotateMatrix((TileEntityAgricraft)tile, tessellator, true);
        }
        if (callFromTESR) {
            GL11.glTranslated((double)(-x), (double)(-y), (double)(-z));
            GL11.glPopMatrix();
        } else {
            if (tessellator instanceof TessellatorV2) {
                ((TessellatorV2)tessellator).setRotation(0.0, 0.0, 0.0, 0.0);
            }
            tessellator.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        }
        return result;
    }

    public final void func_147500_a(TileEntity tileEntity, double x, double y, double z, float f) {
        this.renderBlock(Tessellator.field_78398_a, (IBlockAccess)tileEntity.func_145831_w(), x, y, z, tileEntity.func_145838_q(), tileEntity, f, 0, RenderBlocks.getInstance(), true);
    }

    public final boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        return this.renderBlock(TessellatorV2.instance, world, x, y, z, block, world.func_147438_o(x, y, z), 0.0f, modelId, renderer, false);
    }

    protected abstract boolean doWorldRender(Tessellator var1, IBlockAccess var2, double var3, double var5, double var7, TileEntity var9, Block var10, float var11, int var12, RenderBlocks var13, boolean var14);

    public final void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public final boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public final boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public final boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public final void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        this.doInventoryRender(type, item, data);
        GL11.glPopMatrix();
    }

    protected abstract void doInventoryRender(IItemRenderer.ItemRenderType var1, ItemStack var2, Object ... var3);

    public final Block getBlock() {
        return this.block;
    }

    public abstract boolean shouldBehaveAsTESR();

    public abstract boolean shouldBehaveAsISBRH();

    public final int getRenderId() {
        return AgriCraft.proxy.getRenderId(this.getBlock());
    }

    public static int getRenderId(Block block) {
        return renderIds.containsKey(block) ? renderIds.get(block) : -1;
    }

    protected void rotateMatrix(TileEntityAgricraft tileEntityAgricraft, Tessellator tessellator, boolean inverse) {
        float dz;
        float angle;
        if (!tileEntityAgricraft.isRotatable()) {
            return;
        }
        switch (tileEntityAgricraft.getOrientation()) {
            case SOUTH: {
                angle = 180.0f;
                break;
            }
            case WEST: {
                angle = 90.0f;
                break;
            }
            case NORTH: {
                angle = 0.0f;
                break;
            }
            case EAST: {
                angle = 270.0f;
                break;
            }
            default: {
                return;
            }
        }
        float dx = angle % 270.0f == 0.0f ? 0.0f : -1.0f;
        float f = dz = angle > 90.0f ? -1.0f : 0.0f;
        if (tessellator instanceof TessellatorV2) {
            TessellatorV2 tessellatorV2 = (TessellatorV2)tessellator;
            if (inverse) {
                tessellatorV2.func_78372_c(-dx, 0.0f, -dz);
                tessellatorV2.addRotation(-angle, 0.0, 1.0, 0.0);
            } else {
                tessellatorV2.addRotation(angle, 0.0, 1.0, 0.0);
                tessellatorV2.func_78372_c(dx, 0.0f, dz);
            }
        } else if (inverse) {
            GL11.glTranslatef((float)(-dx), (float)0.0f, (float)(-dz));
            GL11.glRotatef((float)(-angle), (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)dx, (float)0.0f, (float)dz);
        }
    }

    protected void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v) {
        float unit = 0.0625f;
        tessellator.func_78374_a((double)(x * unit), (double)(y * unit), (double)(z * unit), (double)(u * unit), (double)(v * unit));
    }

    protected void addScaledVertexWithUV(Tessellator tessellator, float x, float y, float z, float u, float v, IIcon icon) {
        float unit = 0.0625f;
        tessellator.func_78374_a((double)(x * unit), (double)(y * unit), (double)(z * unit), (double)icon.func_94214_a((double)u), (double)icon.func_94207_b((double)v));
    }

    protected void drawScaledFaceDoubleXY(Tessellator tessellator, float minX, float minY, float maxX, float maxY, IIcon icon, float z) {
        float minU = 0.0f;
        float maxU = 16.0f;
        float minV = 0.0f;
        float maxV = 16.0f;
        this.addScaledVertexWithUV(tessellator, maxX, maxY, z *= 16.0f, maxU, minV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, minY, z, maxU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, minX, minY, z, minU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, minX, maxY, z, minU, minV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, maxY, z, maxU, minV, icon);
        this.addScaledVertexWithUV(tessellator, minX, maxY, z, minU, minV, icon);
        this.addScaledVertexWithUV(tessellator, minX, minY, z, minU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, minY, z, maxU, maxV, icon);
    }

    protected void drawScaledFaceDoubleXZ(Tessellator tessellator, float minX, float minZ, float maxX, float maxZ, IIcon icon, float y) {
        float minU = 0.0f;
        float maxU = 16.0f;
        float minV = 0.0f;
        float maxV = 16.0f;
        this.addScaledVertexWithUV(tessellator, maxX, y *= 16.0f, maxZ, maxU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, y, minZ, maxU, minV, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, minZ, minU, minV, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, maxZ, minU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, y, maxZ, maxU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, maxZ, minU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, minZ, minU, minV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, y, minZ, maxU, minV, icon);
    }

    protected void drawScaledFaceDoubleYZ(Tessellator tessellator, float minY, float minZ, float maxY, float maxZ, IIcon icon, float x) {
        float minU = 0.0f;
        float maxU = 16.0f;
        float minV = 0.0f;
        float maxV = 16.0f;
        this.addScaledVertexWithUV(tessellator, x *= 16.0f, maxY, maxZ, maxU, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, maxZ, maxU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, minZ, minU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, x, maxY, minZ, minU, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, maxY, maxZ, maxU, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, maxY, minZ, minU, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, minZ, minU, maxV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, maxZ, maxU, maxV, icon);
    }

    protected void drawScaledPrism(Tessellator tessellator, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, IIcon icon, int colorMultiplier, ForgeDirection direction) {
        float[] adj = this.rotatePrism(minX, minY, minZ, maxX, maxY, maxZ, direction);
        this.drawScaledPrism(tessellator, adj[0], adj[1], adj[2], adj[3], adj[4], adj[5], icon, colorMultiplier);
    }

    protected void drawScaledPrism(Tessellator tessellator, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, IIcon icon, int colorMultiplier) {
        this.drawScaledFaceBackXZ(tessellator, minX, minZ, maxX, maxZ, icon, minY / 16.0f, colorMultiplier);
        this.drawScaledFaceFrontXZ(tessellator, minX, minZ, maxX, maxZ, icon, maxY / 16.0f, colorMultiplier);
        this.drawScaledFaceBackXY(tessellator, minX, minY, maxX, maxY, icon, minZ / 16.0f, colorMultiplier);
        this.drawScaledFaceFrontXY(tessellator, minX, minY, maxX, maxY, icon, maxZ / 16.0f, colorMultiplier);
        this.drawScaledFaceBackYZ(tessellator, minY, minZ, maxY, maxZ, icon, minX / 16.0f, colorMultiplier);
        this.drawScaledFaceFrontYZ(tessellator, minY, minZ, maxY, maxZ, icon, maxX / 16.0f, colorMultiplier);
    }

    protected void drawScaledFaceFrontXY(Tessellator tessellator, float minX, float minY, float maxX, float maxY, IIcon icon, float z, int colorMultiplier) {
        float minV = 16.0f - maxY;
        float maxV = 16.0f - minY;
        this.applyColorMultiplier(tessellator, colorMultiplier, ForgeDirection.SOUTH);
        this.addScaledVertexWithUV(tessellator, maxX, maxY, z *= 16.0f, maxX, minV, icon);
        this.addScaledVertexWithUV(tessellator, minX, maxY, z, minX, minV, icon);
        this.addScaledVertexWithUV(tessellator, minX, minY, z, minX, maxV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, minY, z, maxX, maxV, icon);
    }

    protected void drawScaledFaceFrontXZ(Tessellator tessellator, float minX, float minZ, float maxX, float maxZ, IIcon icon, float y, int colorMultiplier) {
        this.applyColorMultiplier(tessellator, colorMultiplier, ForgeDirection.UP);
        this.addScaledVertexWithUV(tessellator, maxX, y *= 16.0f, maxZ, maxX, maxZ, icon);
        this.addScaledVertexWithUV(tessellator, maxX, y, minZ, maxX, minZ, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, minZ, minX, minZ, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, maxZ, minX, maxZ, icon);
    }

    protected void drawScaledFaceFrontYZ(Tessellator tessellator, float minY, float minZ, float maxY, float maxZ, IIcon icon, float x, int colorMultiplier) {
        float minV = 16.0f - maxY;
        float maxV = 16.0f - minY;
        this.applyColorMultiplier(tessellator, colorMultiplier, ForgeDirection.EAST);
        this.addScaledVertexWithUV(tessellator, x *= 16.0f, maxY, maxZ, maxZ, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, maxZ, maxZ, maxV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, minZ, minZ, maxV, icon);
        this.addScaledVertexWithUV(tessellator, x, maxY, minZ, minZ, minV, icon);
    }

    protected void drawScaledFaceBackXY(Tessellator tessellator, float minX, float minY, float maxX, float maxY, IIcon icon, float z, int colorMultiplier) {
        float minV = 16.0f - maxY;
        float maxV = 16.0f - minY;
        this.applyColorMultiplier(tessellator, colorMultiplier, ForgeDirection.NORTH);
        this.addScaledVertexWithUV(tessellator, maxX, maxY, z *= 16.0f, maxX, minV, icon);
        this.addScaledVertexWithUV(tessellator, maxX, minY, z, maxX, maxV, icon);
        this.addScaledVertexWithUV(tessellator, minX, minY, z, minX, maxV, icon);
        this.addScaledVertexWithUV(tessellator, minX, maxY, z, minX, minV, icon);
    }

    protected void drawScaledFaceBackXZ(Tessellator tessellator, float minX, float minZ, float maxX, float maxZ, IIcon icon, float y, int colorMultiplier) {
        this.applyColorMultiplier(tessellator, colorMultiplier, ForgeDirection.DOWN);
        this.addScaledVertexWithUV(tessellator, maxX, y *= 16.0f, maxZ, maxX, maxZ, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, maxZ, minX, maxZ, icon);
        this.addScaledVertexWithUV(tessellator, minX, y, minZ, minX, minZ, icon);
        this.addScaledVertexWithUV(tessellator, maxX, y, minZ, maxX, minZ, icon);
    }

    protected void drawScaledFaceBackYZ(Tessellator tessellator, float minY, float minZ, float maxY, float maxZ, IIcon icon, float x, int colorMultiplier) {
        float minV = 16.0f - maxY;
        float maxV = 16.0f - minY;
        this.applyColorMultiplier(tessellator, colorMultiplier, ForgeDirection.WEST);
        this.addScaledVertexWithUV(tessellator, x *= 16.0f, maxY, maxZ, maxZ, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, maxY, minZ, minZ, minV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, minZ, minZ, maxV, icon);
        this.addScaledVertexWithUV(tessellator, x, minY, maxZ, maxZ, maxV, icon);
    }

    protected void applyColorMultiplier(Tessellator tessellator, int colorMultiplier, ForgeDirection side) {
        float preMultiplier = tessellator instanceof TessellatorV2 ? this.getMultiplier(this.transformSide((TessellatorV2)tessellator, side)) : this.getMultiplier(side);
        float r = preMultiplier * ((float)(colorMultiplier >> 16 & 0xFF) / 255.0f);
        float g = preMultiplier * ((float)(colorMultiplier >> 8 & 0xFF) / 255.0f);
        float b = preMultiplier * ((float)(colorMultiplier & 0xFF) / 255.0f);
        tessellator.func_78386_a(r, g, b);
    }

    protected ForgeDirection transformSide(TessellatorV2 tessellator, ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return dir;
        }
        double[] coords = tessellator.getTransformationMatrix().transform(dir.offsetX, dir.offsetY, dir.offsetZ);
        double[] translation = tessellator.getTransformationMatrix().getTranslation();
        coords[0] = coords[0] - translation[0];
        coords[1] = coords[1] - translation[1];
        coords[2] = coords[2] - translation[2];
        double x = Math.abs(coords[0]);
        double y = Math.abs(coords[1]);
        double z = Math.abs(coords[2]);
        if (x > z) {
            if (x > y) {
                return coords[0] > 0.0 ? ForgeDirection.EAST : ForgeDirection.WEST;
            }
        } else if (z > y) {
            return coords[2] > 0.0 ? ForgeDirection.SOUTH : ForgeDirection.NORTH;
        }
        return coords[1] > 0.0 ? ForgeDirection.UP : ForgeDirection.DOWN;
    }

    protected float getMultiplier(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0.5f;
            }
            case SOUTH: 
            case NORTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    protected void drawPlane(Tessellator tessellator, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, IIcon icon, ForgeDirection direction) {
        float[] rot = this.rotatePrism(minX, minY, minZ, maxX, maxY, maxZ, direction);
        this.drawPlane(tessellator, rot[0], rot[1], rot[2], rot[3], rot[4], rot[5], icon);
    }

    private void drawPlane(Tessellator tessellator, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, IIcon icon) {
        this.addScaledVertexWithUV(tessellator, maxX, minY, maxZ, maxX, maxZ, icon);
        this.addScaledVertexWithUV(tessellator, maxX, maxY, minZ, maxX, minZ, icon);
        this.addScaledVertexWithUV(tessellator, minX, maxY, minZ, minX, minZ, icon);
        this.addScaledVertexWithUV(tessellator, minX, minY, maxZ, minX, maxZ, icon);
    }

    public float[] rotatePrism(float minX, float minY, float minZ, float maxX, float maxY, float maxZ, ForgeDirection direction) {
        float[] adj = new float[6];
        switch (direction) {
            default: {
                adj[0] = minX;
                adj[1] = minY;
                adj[2] = minZ;
                adj[3] = maxX;
                adj[4] = maxY;
                adj[5] = maxZ;
                break;
            }
            case EAST: {
                adj[0] = 16.0f - maxZ;
                adj[1] = minY;
                adj[2] = minX;
                adj[3] = 16.0f - minZ;
                adj[4] = maxY;
                adj[5] = maxX;
                break;
            }
            case SOUTH: {
                adj[0] = minX;
                adj[1] = minY;
                adj[2] = 16.0f - maxZ;
                adj[3] = maxX;
                adj[4] = maxY;
                adj[5] = 16.0f - minZ;
                break;
            }
            case WEST: {
                adj[0] = minZ;
                adj[1] = minY;
                adj[2] = minX;
                adj[3] = maxZ;
                adj[4] = maxY;
                adj[5] = maxX;
                break;
            }
            case UP: {
                adj[0] = minX;
                adj[1] = 16.0f - maxZ;
                adj[2] = minY;
                adj[3] = maxX;
                adj[4] = 16.0f - minZ;
                adj[5] = maxY;
            }
            case DOWN: {
                adj[0] = minX;
                adj[1] = minZ;
                adj[2] = minY;
                adj[3] = maxX;
                adj[4] = maxZ;
                adj[5] = maxY;
            }
        }
        return adj;
    }

    protected void drawAxisSystem(boolean startDrawing) {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (startDrawing) {
            tessellator.func_78382_b();
        }
        tessellator.func_78374_a((double)-0.005f, 2.0, 0.0, 1.0, 0.0);
        tessellator.func_78374_a((double)0.005f, 2.0, 0.0, 0.0, 0.0);
        tessellator.func_78374_a((double)0.005f, -1.0, 0.0, 0.0, 1.0);
        tessellator.func_78374_a((double)-0.005f, -1.0, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(2.0, (double)-0.005f, 0.0, 1.0, 0.0);
        tessellator.func_78374_a(2.0, (double)0.005f, 0.0, 0.0, 0.0);
        tessellator.func_78374_a(-1.0, (double)0.005f, 0.0, 0.0, 1.0);
        tessellator.func_78374_a(-1.0, (double)-0.005f, 0.0, 1.0, 1.0);
        tessellator.func_78374_a(0.0, (double)-0.005f, 2.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, (double)0.005f, 2.0, 0.0, 0.0);
        tessellator.func_78374_a(0.0, (double)0.005f, -1.0, 0.0, 1.0);
        tessellator.func_78374_a(0.0, (double)-0.005f, -1.0, 1.0, 1.0);
        if (startDrawing) {
            tessellator.func_78381_a();
        }
    }
}

