/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.mutation;

import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v3.ICrop;
import com.InfinityRaider.AgriCraft.api.v3.ICrossOverResult;
import com.InfinityRaider.AgriCraft.api.v3.IMutationEngine;
import com.InfinityRaider.AgriCraft.api.v3.IMutationHandler;
import com.InfinityRaider.AgriCraft.api.v3.IStatCalculator;
import com.InfinityRaider.AgriCraft.farming.CropPlantHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.MutationHandler;
import com.InfinityRaider.AgriCraft.farming.mutation.statcalculator.StatCalculator;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.tileentity.TileEntityCrop;
import java.util.Random;

public class MutationEngine
implements IMutationEngine {
    private final TileEntityCrop crop;
    private final Random random;

    public MutationEngine(TileEntityCrop crop) {
        this(crop, new Random());
    }

    public MutationEngine(TileEntityCrop crop, Random random) {
        this.crop = crop;
        this.random = random;
    }

    public void executeCrossOver() {
        ICrossOverResult result = this.rollAndExecuteStrategy();
        if (result == null || result.getSeed() == null) {
            return;
        }
        if (this.resultIsValid(result) && this.random.nextDouble() < result.getChance()) {
            this.crop.applyCrossOverResult(result, result.getStats());
        }
    }

    private boolean resultIsValid(ICrossOverResult result) {
        IGrowthRequirement growthReq = CropPlantHandler.getGrowthRequirement(result.getSeed(), result.getMeta());
        boolean valid = result.getSeed() != null && CropPlantHandler.isValidSeed(result.getSeed(), result.getMeta());
        return valid && growthReq.canGrow(this.crop.func_145831_w(), this.crop.field_145851_c, this.crop.field_145848_d, this.crop.field_145849_e);
    }

    public ICrossOverResult rollAndExecuteStrategy() {
        boolean spreading = this.random.nextDouble() > ConfigurationHandler.mutationChance;
        return spreading ? this.getMutationHandler().getMutationLogic().getSpreadingResult(this) : this.getMutationHandler().getMutationLogic().getMutationResult(this);
    }

    @Override
    public ICrop getCrop() {
        return this.crop;
    }

    @Override
    public Random getRandom() {
        return this.random;
    }

    @Override
    public IMutationHandler getMutationHandler() {
        return MutationHandler.getInstance();
    }

    @Override
    public IStatCalculator getStatCalculator() {
        return StatCalculator.getInstance();
    }
}

