/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.farming.growthrequirement;

import com.InfinityRaider.AgriCraft.api.v1.BlockWithMeta;
import com.InfinityRaider.AgriCraft.api.v1.IGrowthRequirement;
import com.InfinityRaider.AgriCraft.api.v1.ISoilContainer;
import com.InfinityRaider.AgriCraft.api.v1.RequirementType;
import com.InfinityRaider.AgriCraft.api.v2.IGrowthRequirementBuilder;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirement;
import com.InfinityRaider.AgriCraft.farming.growthrequirement.GrowthRequirementNull;
import com.InfinityRaider.AgriCraft.handler.ConfigurationHandler;
import com.InfinityRaider.AgriCraft.utility.IOHelper;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GrowthRequirementHandler {
    public static final IGrowthRequirement NULL = new GrowthRequirementNull();
    public static List<BlockWithMeta> defaultSoils = new ArrayList<BlockWithMeta>();
    static List<BlockWithMeta> soils = new ArrayList<BlockWithMeta>();

    public static IGrowthRequirementBuilder getNewBuilder() {
        return new Builder();
    }

    public static boolean isSoilValid(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        BlockWithMeta soil = block instanceof ISoilContainer ? new BlockWithMeta(((ISoilContainer)block).getSoil(world, x, y, z), ((ISoilContainer)block).getSoilMeta(world, x, y, z)) : new BlockWithMeta(block, meta);
        return soils.contains(soil) || defaultSoils.contains(soil);
    }

    public static void init() {
        GrowthRequirementHandler.registerSoils();
        GrowthRequirementHandler.registerCustomEntries();
    }

    private static void registerSoils() {
        GrowthRequirementHandler.addDefaultSoil(new BlockWithMeta(Blocks.field_150458_ak));
    }

    private static void registerCustomEntries() {
        LogHelper.info("Registering soils to whitelist:");
        String[] data = IOHelper.getLinesArrayFromData(ConfigurationHandler.readSoils());
        String total = " of " + data.length + ".";
        for (String line : data) {
            Block block;
            LogHelper.debug("  Parsing " + line + total);
            ItemStack stack = IOHelper.getStack(line);
            Block block2 = block = stack != null && stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).field_150939_a : null;
            if (block != null) {
                GrowthRequirementHandler.addDefaultSoil(new BlockWithMeta(block, stack.func_77960_j()));
                continue;
            }
            LogHelper.info(" Error when adding block to soil whitelist: Invalid block (line: " + line + ")");
        }
        LogHelper.info("Completed soil whitelist:");
        for (BlockWithMeta soil : soils) {
            LogHelper.info(" - " + Block.field_149771_c.func_148750_c((Object)soil.getBlock()) + ":" + soil.getMeta());
        }
    }

    public static void addAllToSoilWhitelist(Collection<? extends BlockWithMeta> list) {
        for (BlockWithMeta blockWithMeta : list) {
            GrowthRequirementHandler.addDefaultSoil(blockWithMeta);
        }
    }

    public static void removeAllFromSoilWhitelist(Collection<? extends BlockWithMeta> list) {
        defaultSoils.removeAll(list);
    }

    public static void addSoil(BlockWithMeta block) {
        if (!soils.contains(block)) {
            soils.add(block);
        }
    }

    public static boolean addDefaultSoil(BlockWithMeta block) {
        if (!defaultSoils.contains(block)) {
            defaultSoils.add(block);
            return true;
        }
        return false;
    }

    private static class Builder
    implements IGrowthRequirementBuilder {
        private final GrowthRequirement growthRequirement = new GrowthRequirement();

        @Override
        public Builder requiredBlock(BlockWithMeta requiredBlock, RequirementType requiredType, boolean oreDict) {
            if (requiredBlock == null || requiredType == RequirementType.NONE) {
                throw new IllegalArgumentException("Required block must be not null and required type must be other than NONE.");
            }
            this.growthRequirement.setRequiredBlock(requiredBlock, requiredType, oreDict);
            return this;
        }

        @Override
        public Builder soil(BlockWithMeta block) {
            this.growthRequirement.setSoil(block);
            GrowthRequirementHandler.addSoil(block);
            return this;
        }

        @Override
        public Builder brightnessRange(int min, int max) {
            this.growthRequirement.setBrightnessRange(Math.max(0, min), Math.min(16, max));
            return this;
        }

        @Override
        public IGrowthRequirement build() {
            return this.growthRequirement;
        }
    }
}

