/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingbook.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.blay09.mods.cookingbook.addon.HarvestCraftAddon;
import net.blay09.mods.cookingbook.api.SinkHandler;
import net.blay09.mods.cookingbook.api.ToastHandler;
import net.blay09.mods.cookingbook.api.event.FoodRegistryInitEvent;
import net.blay09.mods.cookingbook.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingbook.container.InventoryCraftBook;
import net.blay09.mods.cookingbook.registry.food.FoodIngredient;
import net.blay09.mods.cookingbook.registry.food.FoodRecipe;
import net.blay09.mods.cookingbook.registry.food.recipe.ShapedCraftingFood;
import net.blay09.mods.cookingbook.registry.food.recipe.ShapedOreCraftingFood;
import net.blay09.mods.cookingbook.registry.food.recipe.ShapelessCraftingFood;
import net.blay09.mods.cookingbook.registry.food.recipe.ShapelessOreCraftingFood;
import net.blay09.mods.cookingbook.registry.food.recipe.SmeltingFood;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CookingRegistry {
    private static final List<IRecipe> recipeList = Lists.newArrayList();
    private static final ArrayListMultimap<Item, FoodRecipe> foodItems = ArrayListMultimap.create();
    private static final List<ItemStack> tools = Lists.newArrayList();
    private static final Map<ItemStack, Integer> ovenFuelItems = Maps.newHashMap();
    private static final Map<ItemStack, ItemStack> ovenRecipes = Maps.newHashMap();
    private static final Map<ItemStack, SinkHandler> sinkHandlers = Maps.newHashMap();
    private static final Map<ItemStack, ToastHandler> toastHandlers = Maps.newHashMap();

    public static void initFoodRegistry() {
        recipeList.clear();
        foodItems.clear();
        FoodRegistryInitEvent init = new FoodRegistryInitEvent();
        MinecraftForge.EVENT_BUS.post((Event)init);
        Collection<ItemStack> nonFoodRecipes = init.getNonFoodRecipes();
        block0: for (Object e : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)e;
            ItemStack output = recipe.func_77571_b();
            if (output == null) continue;
            if (output.func_77973_b() instanceof ItemFood) {
                if (HarvestCraftAddon.isWeirdBrokenRecipe(recipe)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!CookingRegistry.areItemStacksEqualWithWildcard(recipe.func_77571_b(), itemStack)) continue;
                CookingRegistry.addFoodRecipe(recipe);
                continue block0;
            }
        }
        block2: for (Object object : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            Map.Entry entry = (Map.Entry)object;
            ItemStack sourceStack = null;
            if (entry.getKey() instanceof Item) {
                sourceStack = new ItemStack((Item)entry.getKey());
            } else if (entry.getKey() instanceof Block) {
                sourceStack = new ItemStack((Block)entry.getKey());
            } else if (entry.getKey() instanceof ItemStack) {
                sourceStack = (ItemStack)entry.getKey();
            }
            ItemStack resultStack = (ItemStack)entry.getValue();
            if (resultStack.func_77973_b() instanceof ItemFood) {
                foodItems.put((Object)resultStack.func_77973_b(), (Object)new SmeltingFood(resultStack, sourceStack));
                continue;
            }
            for (ItemStack itemStack : nonFoodRecipes) {
                if (!CookingRegistry.areItemStacksEqualWithWildcard(resultStack, itemStack)) continue;
                foodItems.put((Object)resultStack.func_77973_b(), (Object)new SmeltingFood(resultStack, sourceStack));
                continue block2;
            }
        }
    }

    public static void addFoodRecipe(IRecipe recipe) {
        ItemStack output = recipe.func_77571_b();
        if (output != null) {
            recipeList.add(recipe);
            if (recipe instanceof ShapedRecipes) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapedCraftingFood((ShapedRecipes)recipe));
            } else if (recipe instanceof ShapelessRecipes) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapelessCraftingFood((ShapelessRecipes)recipe));
            } else if (recipe instanceof ShapelessOreRecipe) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapelessOreCraftingFood((ShapelessOreRecipe)recipe));
            } else if (recipe instanceof ShapedOreRecipe) {
                foodItems.put((Object)output.func_77973_b(), (Object)new ShapedOreCraftingFood((ShapedOreRecipe)recipe));
            }
        }
    }

    public static boolean areIngredientsAvailableFor(List<FoodIngredient> craftMatrix, List<IInventory> inventories, List<IKitchenItemProvider> itemProviders) {
        int i;
        int[][] usedStackSize = new int[inventories.size()][];
        for (int i2 = 0; i2 < usedStackSize.length; ++i2) {
            usedStackSize[i2] = new int[inventories.get(i2).func_70302_i_()];
        }
        boolean[] itemFound = new boolean[craftMatrix.size()];
        block1: for (i = 0; i < craftMatrix.size(); ++i) {
            if (craftMatrix.get(i) == null || craftMatrix.get(i).isToolItem()) {
                itemFound[i] = true;
                continue;
            }
            for (IKitchenItemProvider itemProvider : itemProviders) {
                itemProvider.clearCraftingBuffer();
                for (ItemStack providedStack : itemProvider.getProvidedItemStacks()) {
                    if (!craftMatrix.get(i).isValidItem(providedStack) || !itemProvider.addToCraftingBuffer(providedStack)) continue;
                    itemFound[i] = true;
                    continue block1;
                }
            }
            for (int j = 0; j < inventories.size(); ++j) {
                for (int k = 0; k < inventories.get(j).func_70302_i_(); ++k) {
                    ItemStack itemStack = inventories.get(j).func_70301_a(k);
                    if (itemStack == null || !craftMatrix.get(i).isValidItem(itemStack) || itemStack.field_77994_a - usedStackSize[j][k] <= 0) continue;
                    int[] nArray = usedStackSize[j];
                    int n = k;
                    nArray[n] = nArray[n] + 1;
                    itemFound[i] = true;
                    continue block1;
                }
            }
        }
        for (i = 0; i < itemFound.length; ++i) {
            if (itemFound[i]) continue;
            return false;
        }
        return true;
    }

    public static IRecipe findMatchingFoodRecipe(InventoryCraftBook craftBook, World worldObj) {
        for (IRecipe recipe : recipeList) {
            if (!recipe.func_77569_a((InventoryCrafting)craftBook, worldObj)) continue;
            return recipe;
        }
        return null;
    }

    public static Collection<FoodRecipe> getFoodRecipes() {
        return foodItems.values();
    }

    public static void addToolItem(ItemStack toolItem) {
        tools.add(toolItem);
    }

    public static boolean isToolItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (ItemStack toolItem : tools) {
            if (!CookingRegistry.areItemStacksEqualWithWildcard(toolItem, itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void addOvenFuel(ItemStack itemStack, int fuelTime) {
        ovenFuelItems.put(itemStack, fuelTime);
    }

    public static int getOvenFuelTime(ItemStack itemStack) {
        for (Map.Entry<ItemStack, Integer> entry : ovenFuelItems.entrySet()) {
            if (!CookingRegistry.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static void addSmeltingItem(ItemStack source, ItemStack result) {
        ovenRecipes.put(source, result);
    }

    public static ItemStack getSmeltingResult(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ItemStack> entry : ovenRecipes.entrySet()) {
            if (!CookingRegistry.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void addToastHandler(ItemStack itemStack, ToastHandler toastHandler) {
        toastHandlers.put(itemStack, toastHandler);
    }

    public static void addSinkHandler(ItemStack itemStack, SinkHandler sinkHandler) {
        sinkHandlers.put(itemStack, sinkHandler);
    }

    public static ItemStack getSinkOutput(ItemStack itemStack) {
        for (Map.Entry<ItemStack, SinkHandler> entry : sinkHandlers.entrySet()) {
            if (!CookingRegistry.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue().getSinkOutput(itemStack);
        }
        return null;
    }

    public static ItemStack getToastOutput(ItemStack itemStack) {
        for (Map.Entry<ItemStack, ToastHandler> entry : toastHandlers.entrySet()) {
            if (!CookingRegistry.areItemStacksEqualWithWildcard(entry.getKey(), itemStack)) continue;
            return entry.getValue().getToasterOutput(itemStack);
        }
        return null;
    }

    public static boolean areItemStacksEqualWithWildcard(ItemStack first, ItemStack second) {
        if (first == null || second == null) {
            return false;
        }
        return first.func_77973_b() == second.func_77973_b() && (first.func_77960_j() == second.func_77960_j() || first.func_77960_j() == Short.MAX_VALUE || second.func_77960_j() == Short.MAX_VALUE);
    }
}

