/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.shapecard;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcjty.lib.varia.Coordinate;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spaceprojector.BuilderTileEntity;
import mcjty.rftools.blocks.spaceprojector.SpaceProjectorConfiguration;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

public class ShapeCardItem
extends Item {
    public static final int CARD_UNKNOWN = -2;
    public static final int CARD_SPACE = -1;
    public static final int CARD_SHAPE = 0;
    public static final int CARD_VOID = 1;
    public static final int CARD_QUARRY = 2;
    public static final int CARD_QUARRY_SILK = 3;
    public static final int CARD_QUARRY_FORTUNE = 4;
    public static final int CARD_QUARRY_CLEAR = 5;
    public static final int CARD_QUARRY_CLEAR_SILK = 6;
    public static final int CARD_QUARRY_CLEAR_FORTUNE = 7;
    public static final int MAXIMUM_COUNT = 50000000;
    private final IIcon[] icons = new IIcon[8];
    public static final int MODE_NONE = 0;
    public static final int MODE_CORNER1 = 1;
    public static final int MODE_CORNER2 = 2;

    public ShapeCardItem() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public int func_77626_a(ItemStack stack) {
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float sx, float sy, float sz) {
        if (world.field_72995_K) return true;
        int mode = ShapeCardItem.getMode(stack);
        if (mode == 0) {
            if (!player.func_70093_af()) return false;
            if (world.func_147438_o(x, y, z) instanceof BuilderTileEntity) {
                ShapeCardItem.setCurrentBlock(stack, new GlobalCoordinate(new Coordinate(x, y, z), world.field_73011_w.field_76574_g));
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.GREEN + "Now select the first corner"));
                ShapeCardItem.setMode(stack, 1);
                ShapeCardItem.setCorner1(stack, null);
                return true;
            } else {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "You can only do this on a builder!"));
            }
            return true;
        } else if (mode == 1) {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock.getDimension() != world.field_73011_w.field_76574_g) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "The Builder is in another dimension!"));
                return true;
            } else if (currentBlock.getCoordinate().equals((Object)new Coordinate(x, y, z))) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return true;
            } else {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.GREEN + "Now select the second corner"));
                ShapeCardItem.setMode(stack, 2);
                ShapeCardItem.setCorner1(stack, new Coordinate(x, y, z));
            }
            return true;
        } else {
            GlobalCoordinate currentBlock = ShapeCardItem.getCurrentBlock(stack);
            if (currentBlock.getDimension() != world.field_73011_w.field_76574_g) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "The Builder is in another dimension!"));
                return true;
            } else if (currentBlock.getCoordinate().equals((Object)new Coordinate(x, y, z))) {
                Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Cleared area selection mode!"));
                ShapeCardItem.setMode(stack, 0);
                return true;
            } else {
                Coordinate c1;
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                    stack.func_77982_d(tag);
                }
                if ((c1 = ShapeCardItem.getCorner1(stack)) == null) {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.RED + "Cleared area selection mode!"));
                    ShapeCardItem.setMode(stack, 0);
                    return true;
                } else {
                    Logging.message((EntityPlayer)player, (String)(EnumChatFormatting.GREEN + "New settings copied to the shape card!"));
                    System.out.println("currentBlock = " + currentBlock.getCoordinate());
                    System.out.println("corner1 = " + c1);
                    System.out.println("corner2 = " + x + ", " + y + ", " + z);
                    Coordinate center = new Coordinate((int)Math.ceil((float)(c1.getX() + x) / 2.0f), (int)Math.ceil((float)(c1.getY() + y) / 2.0f), (int)Math.ceil((float)(c1.getZ() + z) / 2.0f));
                    System.out.println("center = " + center);
                    tag.func_74768_a("dimX", Math.abs(c1.getX() - x) + 1);
                    tag.func_74768_a("dimY", Math.abs(c1.getY() - y) + 1);
                    tag.func_74768_a("dimZ", Math.abs(c1.getZ() - z) + 1);
                    tag.func_74768_a("offsetX", center.getX() - currentBlock.getCoordinate().getX());
                    tag.func_74768_a("offsetY", center.getY() - currentBlock.getCoordinate().getY());
                    tag.func_74768_a("offsetZ", center.getZ() - currentBlock.getCoordinate().getZ());
                    ShapeCardItem.setMode(stack, 0);
                    ShapeCardItem.setCorner1(stack, null);
                }
            }
        }
        return true;
    }

    public static void setCorner1(ItemStack itemStack, Coordinate corner) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (corner == null) {
            tagCompound.func_82580_o("corner1x");
            tagCompound.func_82580_o("corner1y");
            tagCompound.func_82580_o("corner1z");
        } else {
            tagCompound.func_74768_a("corner1x", corner.getX());
            tagCompound.func_74768_a("corner1y", corner.getY());
            tagCompound.func_74768_a("corner1z", corner.getZ());
        }
    }

    public static Coordinate getCorner1(ItemStack stack1) {
        NBTTagCompound tagCompound = stack1.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        if (!tagCompound.func_74764_b("corner1x")) {
            return null;
        }
        return new Coordinate(tagCompound.func_74762_e("corner1x"), tagCompound.func_74762_e("corner1y"), tagCompound.func_74762_e("corner1z"));
    }

    public static int getMode(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            return tagCompound.func_74762_e("mode");
        }
        return 0;
    }

    public static void setMode(ItemStack itemStack, int mode) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("mode", mode);
    }

    public static void setCurrentBlock(ItemStack itemStack, GlobalCoordinate c) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        if (c == null) {
            tagCompound.func_82580_o("selectedX");
            tagCompound.func_82580_o("selectedY");
            tagCompound.func_82580_o("selectedZ");
            tagCompound.func_82580_o("selectedDim");
        } else {
            tagCompound.func_74768_a("selectedX", c.getCoordinate().getX());
            tagCompound.func_74768_a("selectedY", c.getCoordinate().getY());
            tagCompound.func_74768_a("selectedZ", c.getCoordinate().getZ());
            tagCompound.func_74768_a("selectedDim", c.getDimension());
        }
    }

    public static GlobalCoordinate getCurrentBlock(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("selectedX")) {
            int x = tagCompound.func_74762_e("selectedX");
            int y = tagCompound.func_74762_e("selectedY");
            int z = tagCompound.func_74762_e("selectedZ");
            int dim = tagCompound.func_74762_e("selectedDim");
            return new GlobalCoordinate(new Coordinate(x, y, z), dim);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.func_77624_a(itemStack, player, list, whatIsThis);
        int type = itemStack.func_77960_j();
        if (!SpaceProjectorConfiguration.shapeCardAllowed) {
            list.add(EnumChatFormatting.RED + "Disabled in config!");
        } else if (type != 0) {
            if (!SpaceProjectorConfiguration.quarryAllowed) {
                list.add(EnumChatFormatting.RED + "Disabled in config!");
            } else if (ShapeCardItem.isClearingQuarry(type) && !SpaceProjectorConfiguration.clearingQuarryAllowed) {
                list.add(EnumChatFormatting.RED + "Disabled in config!");
            }
        }
        Shape shape = ShapeCardItem.getShape(itemStack);
        list.add(EnumChatFormatting.GREEN + "Shape " + shape.getDescription());
        list.add(EnumChatFormatting.GREEN + "Dimension " + ShapeCardItem.getDimension(itemStack));
        list.add(EnumChatFormatting.GREEN + "Offset " + ShapeCardItem.getOffset(itemStack));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.YELLOW + "Sneak right click on builder to start mark mode");
            list.add(EnumChatFormatting.YELLOW + "Then right click to mark two corners of wanted area");
            switch (type) {
                case 1: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to void");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space.");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + (int)((double)SpaceProjectorConfiguration.builderRfPerQuarry * SpaceProjectorConfiguration.voidShapeCardFactor) + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 0: {
                    list.add(EnumChatFormatting.WHITE + "This item can be configured as a shape. You");
                    list.add(EnumChatFormatting.WHITE + "can then use it in the shield projector to make");
                    list.add(EnumChatFormatting.WHITE + "a shield of that shape or in the builder to");
                    list.add(EnumChatFormatting.WHITE + "actually build the shape");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + SpaceProjectorConfiguration.builderRfPerOperation + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level)");
                    break;
                }
                case 3: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space and replace");
                    list.add(EnumChatFormatting.WHITE + "them with dirt.");
                    list.add(EnumChatFormatting.WHITE + "Blocks are harvested with silk touch");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + (int)((double)SpaceProjectorConfiguration.builderRfPerQuarry * SpaceProjectorConfiguration.silkquarryShapeCardFactor) + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 6: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space.");
                    list.add(EnumChatFormatting.WHITE + "Blocks are harvested with silk touch");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + (int)((double)SpaceProjectorConfiguration.builderRfPerQuarry * SpaceProjectorConfiguration.silkquarryShapeCardFactor) + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 4: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space and replace");
                    list.add(EnumChatFormatting.WHITE + "them with dirt.");
                    list.add(EnumChatFormatting.WHITE + "Blocks are harvested with fortune");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + (int)((double)SpaceProjectorConfiguration.builderRfPerQuarry * SpaceProjectorConfiguration.fortunequarryShapeCardFactor) + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 7: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space.");
                    list.add(EnumChatFormatting.WHITE + "Blocks are harvested with fortune");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + (int)((double)SpaceProjectorConfiguration.builderRfPerQuarry * SpaceProjectorConfiguration.fortunequarryShapeCardFactor) + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 2: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space and replace");
                    list.add(EnumChatFormatting.WHITE + "them with dirt.");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + SpaceProjectorConfiguration.builderRfPerQuarry + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                    break;
                }
                case 5: {
                    list.add(EnumChatFormatting.WHITE + "This item will cause the builder to quarry");
                    list.add(EnumChatFormatting.WHITE + "all blocks in the configured space");
                    list.add(EnumChatFormatting.GREEN + "Max area: " + SpaceProjectorConfiguration.maxBuilderDimension + "x" + Math.min(256, SpaceProjectorConfiguration.maxBuilderDimension) + "x" + SpaceProjectorConfiguration.maxBuilderDimension);
                    list.add(EnumChatFormatting.GREEN + "Base cost: " + SpaceProjectorConfiguration.builderRfPerQuarry + " RF/t per block");
                    list.add(EnumChatFormatting.GREEN + "(final cost depends on infusion level and block hardness)");
                }
            }
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    public static boolean isNormalShapeCard(ItemStack stack) {
        return stack.func_77960_j() == 0;
    }

    public static boolean isClearingQuarry(int type) {
        return type == 5 || type == 7 || type == 6;
    }

    public static boolean isQuarry(int type) {
        return type == 5 || type == 7 || type == 6 || type == 2 || type == 4 || type == 3;
    }

    private static void addBlocks(Set<Block> blocks, Block block, boolean oredict) {
        blocks.add(block);
        if (oredict) {
            int[] iDs;
            for (int id : iDs = OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
                String oreName = OreDictionary.getOreName((int)id);
                ArrayList ores = OreDictionary.getOres((String)oreName);
                for (ItemStack ore : ores) {
                    if (!(ore.func_77973_b() instanceof ItemBlock)) continue;
                    blocks.add(((ItemBlock)ore.func_77973_b()).field_150939_a);
                }
            }
        }
    }

    public static Set<Block> getVoidedBlocks(ItemStack stack) {
        HashSet<Block> blocks = new HashSet<Block>();
        boolean oredict = ShapeCardItem.isOreDictionary(stack);
        if (ShapeCardItem.isVoiding(stack, "stone")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150348_b, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "cobble")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150347_e, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "dirt")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150346_d, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "sand")) {
            ShapeCardItem.addBlocks(blocks, (Block)Blocks.field_150354_m, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "gravel")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150351_n, oredict);
        }
        if (ShapeCardItem.isVoiding(stack, "netherrack")) {
            ShapeCardItem.addBlocks(blocks, Blocks.field_150424_aL, oredict);
        }
        return blocks;
    }

    public static boolean isOreDictionary(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("oredict");
    }

    public static boolean isVoiding(ItemStack stack, String material) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("void" + material);
    }

    public static Shape getShape(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return Shape.SHAPE_BOX;
        }
        int shape = tagCompound.func_74762_e("shape");
        Shape s = Shape.getShape(shape);
        if (s == null) {
            return Shape.SHAPE_BOX;
        }
        return s;
    }

    public static void setShape(ItemStack stack, Shape shape) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        tagCompound.func_74768_a("shape", shape.getIndex());
    }

    public static Coordinate getDimension(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new Coordinate(5, 5, 5);
        }
        if (!tagCompound.func_74764_b("dimX")) {
            return new Coordinate(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new Coordinate(dimX, ShapeCardItem.clampDimension(dimY, 256), dimZ);
    }

    public static Coordinate getClampedDimension(ItemStack stack, int maximum) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new Coordinate(5, 5, 5);
        }
        int dimX = tagCompound.func_74762_e("dimX");
        int dimY = tagCompound.func_74762_e("dimY");
        int dimZ = tagCompound.func_74762_e("dimZ");
        return new Coordinate(ShapeCardItem.clampDimension(dimX, maximum), ShapeCardItem.clampDimension(dimY, maximum), ShapeCardItem.clampDimension(dimZ, maximum));
    }

    private static int clampDimension(int o, int maximum) {
        if (o > maximum) {
            o = maximum;
        } else if (o < 0) {
            o = 0;
        }
        return o;
    }

    public static Coordinate getOffset(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new Coordinate(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new Coordinate(offsetX, offsetY, offsetZ);
    }

    public static Coordinate getClampedOffset(ItemStack stack, int maximum) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return new Coordinate(0, 0, 0);
        }
        int offsetX = tagCompound.func_74762_e("offsetX");
        int offsetY = tagCompound.func_74762_e("offsetY");
        int offsetZ = tagCompound.func_74762_e("offsetZ");
        return new Coordinate(ShapeCardItem.clampOffset(offsetX, maximum), ShapeCardItem.clampOffset(offsetY, maximum), ShapeCardItem.clampOffset(offsetZ, maximum));
    }

    private static int clampOffset(int o, int maximum) {
        if (o < -maximum) {
            o = -maximum;
        } else if (o > maximum) {
            o = maximum;
        }
        return o;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            player.openGui((Object)RFTools.instance, RFTools.GUI_SHAPECARD, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return stack;
        }
        return stack;
    }

    public static Coordinate getMinCorner(Coordinate thisCoord, Coordinate dimension, Coordinate offset) {
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        return new Coordinate(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
    }

    public static Coordinate getMaxCorner(Coordinate thisCoord, Coordinate dimension, Coordinate offset) {
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        Coordinate minCorner = ShapeCardItem.getMinCorner(thisCoord, dimension, offset);
        return new Coordinate(minCorner.getX() + dx, minCorner.getY() + dy, minCorner.getZ() + dz);
    }

    public static int countBlocks(Shape shape, Coordinate dimension) {
        final int[] cnt = new int[]{0};
        Coordinate offset = new Coordinate(0, 128, 0);
        Coordinate clamped = new Coordinate(Math.min(dimension.getX(), 512), Math.min(dimension.getY(), 256), Math.min(dimension.getZ(), 512));
        ShapeCardItem.composeShape(shape, null, new Coordinate(0, 0, 0), clamped, offset, (Collection<Coordinate>)new AbstractCollection<Coordinate>(){

            @Override
            public Iterator<Coordinate> iterator() {
                return null;
            }

            @Override
            public boolean add(Coordinate coordinate) {
                cnt[0] = cnt[0] + 1;
                return true;
            }

            @Override
            public int size() {
                return 0;
            }
        }, 50000001, false, null);
        return cnt[0];
    }

    public static boolean xInChunk(int x, ChunkCoordIntPair chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77276_a == x >> 4;
    }

    public static boolean zInChunk(int z, ChunkCoordIntPair chunk) {
        if (chunk == null) {
            return true;
        }
        return chunk.field_77275_b == z >> 4;
    }

    public static void composeShape(Shape shape, World worldObj, Coordinate thisCoord, Coordinate dimension, Coordinate offset, Collection<Coordinate> blocks, int maxSize, boolean forquarry, ChunkCoordIntPair chunk) {
        switch (shape) {
            case SHAPE_BOX: {
                ShapeCardItem.composeBox(worldObj, thisCoord, dimension, offset, blocks, maxSize, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDBOX: {
                ShapeCardItem.composeBox(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, forquarry, chunk);
                break;
            }
            case SHAPE_TOPDOME: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 1, false, forquarry, chunk);
                break;
            }
            case SHAPE_BOTTOMDOME: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, -1, false, forquarry, chunk);
                break;
            }
            case SHAPE_SPHERE: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 0, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDSPHERE: {
                ShapeCardItem.composeSphere(worldObj, thisCoord, dimension, offset, blocks, maxSize, 0, true, forquarry, chunk);
                break;
            }
            case SHAPE_CYLINDER: {
                ShapeCardItem.composeCylinder(worldObj, thisCoord, dimension, offset, blocks, maxSize, false, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDCYLINDER: {
                ShapeCardItem.composeCylinder(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, true, forquarry, chunk);
                break;
            }
            case SHAPE_CAPPEDCYLINDER: {
                ShapeCardItem.composeCylinder(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, false, forquarry, chunk);
                break;
            }
            case SHAPE_PRISM: {
                ShapeCardItem.composePrism(worldObj, thisCoord, dimension, offset, blocks, maxSize, forquarry, chunk);
                break;
            }
            case SHAPE_TORUS: {
                ShapeCardItem.composeTorus(worldObj, thisCoord, dimension, offset, blocks, maxSize, false, forquarry, chunk);
                break;
            }
            case SHAPE_SOLIDTORUS: {
                ShapeCardItem.composeTorus(worldObj, thisCoord, dimension, offset, blocks, maxSize, true, forquarry, chunk);
            }
        }
    }

    private static void placeBlockIfPossible(World worldObj, Collection<Coordinate> blocks, int maxSize, int x, int y, int z, boolean forquarry) {
        if (worldObj == null) {
            blocks.add(new Coordinate(x, y, z));
            return;
        }
        if (forquarry) {
            if (worldObj.func_147437_c(x, y, z)) {
                return;
            }
            blocks.add(new Coordinate(x, y, z));
        } else if (BuilderTileEntity.isEmptyOrReplacable(worldObj, x, y, z) && blocks.size() < maxSize - 1) {
            blocks.add(new Coordinate(x, y, z));
        }
    }

    private static void composeSphere(World worldObj, Coordinate thisCoord, Coordinate dimension, Coordinate offset, Collection<Coordinate> blocks, int maxSize, int side, boolean solid, boolean forquarry, ChunkCoordIntPair chunk) {
        int davg;
        float dz2;
        float dy2;
        float dx2;
        float centerz;
        float centery;
        float centerx;
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        if (SpaceProjectorConfiguration.oldSphereCylinderShape) {
            centerx = (float)(xCoord + offset.getX()) + 0.5f;
            centery = (float)(yCoord + offset.getY()) + 0.5f;
            centerz = (float)(zCoord + offset.getZ()) + 0.5f;
        } else {
            centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            centery = (float)(yCoord + offset.getY()) + (dy % 2 != 0 ? 0.0f : -0.5f);
            centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        }
        Coordinate tl = new Coordinate(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
        if (SpaceProjectorConfiguration.oldSphereCylinderShape) {
            dx2 = dx == 0 ? 0.5f : (float)(dx * dx) / 4.0f;
            dy2 = dy == 0 ? 0.5f : (float)(dy * dy) / 4.0f;
            dz2 = dz == 0 ? 0.5f : (float)(dz * dz) / 4.0f;
            davg = (dx + dy + dz) / 3;
        } else {
            float factor = 1.8f;
            dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            dy2 = dy == 0 ? 0.5f : ((float)dy + factor) * ((float)dy + factor) / 4.0f;
            dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            davg = (int)(((float)(dx + dy + dz) + factor * 3.0f) / 3.0f);
        }
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.getX() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.getZ() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int cnt;
                    int y = tl.getY() + oy;
                    if (y < 0 || y >= 255 || side != 0 && (side != 1 || y < yCoord + offset.getY()) && (side != -1 || y > yCoord + offset.getY()) || ShapeCardItem.isInside3D(centerx, centery, centerz, x, y, z, dx2, dy2, dz2, davg) != 1) continue;
                    if (solid) {
                        cnt = 0;
                    } else {
                        cnt = ShapeCardItem.isInside3D(centerx, centery, centerz, x - 1, y, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x + 1, y, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y - 1, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y + 1, z, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y, z - 1, dx2, dy2, dz2, davg);
                        cnt += ShapeCardItem.isInside3D(centerx, centery, centerz, x, y, z + 1, dx2, dy2, dz2, davg);
                    }
                    if (cnt == 6) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static float squaredDistance3D(float cx, float cy, float cz, float x1, float y1, float z1, float dx2, float dy2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (y1 - cy) * (y1 - cy) / dy2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static float squaredDistance2D(float cx, float cz, float x1, float z1, float dx2, float dz2) {
        return (x1 - cx) * (x1 - cx) / dx2 + (z1 - cz) * (z1 - cz) / dz2;
    }

    private static int isInside2D(float centerx, float centerz, int x, int z, float dx2, float dz2, int davg) {
        double distance = Math.sqrt(ShapeCardItem.squaredDistance2D(centerx, centerz, x, z, dx2, dz2));
        return (int)(distance * (double)(davg / 2 + 1)) <= davg / 2 - 1 ? 1 : 0;
    }

    private static int isInside3D(float centerx, float centery, float centerz, int x, int y, int z, float dx2, float dy2, float dz2, int davg) {
        double distance = Math.sqrt(ShapeCardItem.squaredDistance3D(centerx, centery, centerz, x, y, z, dx2, dy2, dz2));
        return (int)(distance * (double)(davg / 2 + 1)) <= davg / 2 - 1 ? 1 : 0;
    }

    private static void composeCylinder(World worldObj, Coordinate thisCoord, Coordinate dimension, Coordinate offset, Collection<Coordinate> blocks, int maxSize, boolean capped, boolean solid, boolean forquarry, ChunkCoordIntPair chunk) {
        int davg;
        float dz2;
        float dx2;
        float centerz;
        float centerx;
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        if (SpaceProjectorConfiguration.oldSphereCylinderShape) {
            centerx = (float)(xCoord + offset.getX()) + 0.5f;
            centerz = (float)(zCoord + offset.getZ()) + 0.5f;
        } else {
            centerx = (float)(xCoord + offset.getX()) + (dx % 2 != 0 ? 0.0f : -0.5f);
            centerz = (float)(zCoord + offset.getZ()) + (dz % 2 != 0 ? 0.0f : -0.5f);
        }
        Coordinate tl = new Coordinate(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
        if (SpaceProjectorConfiguration.oldSphereCylinderShape) {
            dx2 = dx == 0 ? 0.5f : (float)(dx * dx) / 4.0f;
            dz2 = dz == 0 ? 0.5f : (float)(dz * dz) / 4.0f;
            davg = (dx + dz) / 2;
        } else {
            float factor = 1.7f;
            dx2 = dx == 0 ? 0.5f : ((float)dx + factor) * ((float)dx + factor) / 4.0f;
            dz2 = dz == 0 ? 0.5f : ((float)dz + factor) * ((float)dz + factor) / 4.0f;
            davg = (int)(((float)(dx + dz) + factor * 2.0f) / 2.0f);
        }
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.getX() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.getZ() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int cnt;
                    int y = tl.getY() + oy;
                    if (y < 0 || y >= 255 || ShapeCardItem.isInside2D(centerx, centerz, x, z, dx2, dz2, davg) != 1) continue;
                    if (solid) {
                        cnt = 0;
                    } else {
                        cnt = ShapeCardItem.isInside2D(centerx, centerz, x - 1, z, dx2, dz2, davg);
                        cnt += ShapeCardItem.isInside2D(centerx, centerz, x + 1, z, dx2, dz2, davg);
                        cnt += ShapeCardItem.isInside2D(centerx, centerz, x, z - 1, dx2, dz2, davg);
                        cnt += ShapeCardItem.isInside2D(centerx, centerz, x, z + 1, dx2, dz2, davg);
                    }
                    if (cnt == 4 && (!capped || oy != 0 && oy != dy - 1)) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static void composeBox(World worldObj, Coordinate thisCoord, Coordinate dimension, Coordinate offset, Collection<Coordinate> blocks, int maxSize, boolean solid, boolean forquarry, ChunkCoordIntPair chunk) {
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        Coordinate tl = new Coordinate(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.getX() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.getZ() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int y = tl.getY() + oy;
                    if (y < 0 || y >= 255 || !solid && ox != 0 && oy != 0 && oz != 0 && ox != dx - 1 && oy != dy - 1 && oz != dz - 1) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static void composePrism(World worldObj, Coordinate thisCoord, Coordinate dimension, Coordinate offset, Collection<Coordinate> blocks, int maxSize, boolean forquarry, ChunkCoordIntPair chunk) {
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        Coordinate tl = new Coordinate(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
        for (int oy = 0; oy < dy; ++oy) {
            int y = tl.getY() + oy;
            if (y < 0 || y >= 255) continue;
            int yoffset = oy;
            for (int ox = 0; ox < dx; ++ox) {
                int x;
                if (ox < yoffset || ox >= dx - yoffset || !ShapeCardItem.xInChunk(x = tl.getX() + ox, chunk)) continue;
                for (int oz = yoffset; oz < dz - yoffset; ++oz) {
                    int z = tl.getZ() + oz;
                    if (!ShapeCardItem.zInChunk(z, chunk) || ox != yoffset && oy != 0 && oz != yoffset && ox != dx - yoffset - 1 && oz != dz - yoffset - 1) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    private static int isInsideTorus(float centerx, float centery, float centerz, int x, int y, int z, float bigRadius, float smallRadius) {
        double rr = (double)bigRadius - Math.sqrt(((float)x - centerx) * ((float)x - centerx) + ((float)z - centerz) * ((float)z - centerz));
        double f = rr * rr + (double)(((float)y - centery) * ((float)y - centery)) - (double)(smallRadius * smallRadius);
        if (f < 0.0) {
            return 1;
        }
        return 0;
    }

    private static void composeTorus(World worldObj, Coordinate thisCoord, Coordinate dimension, Coordinate offset, Collection<Coordinate> blocks, int maxSize, boolean solid, boolean forquarry, ChunkCoordIntPair chunk) {
        int xCoord = thisCoord.getX();
        int yCoord = thisCoord.getY();
        int zCoord = thisCoord.getZ();
        int dx = dimension.getX();
        int dy = dimension.getY();
        int dz = dimension.getZ();
        float centerx = xCoord + offset.getX();
        float centery = yCoord + offset.getY();
        float centerz = zCoord + offset.getZ();
        Coordinate tl = new Coordinate(xCoord - dx / 2 + offset.getX(), yCoord - dy / 2 + offset.getY(), zCoord - dz / 2 + offset.getZ());
        float smallRadius = (float)(dy - 2) / 2.0f;
        float bigRadius = (float)(dx - 2) / 2.0f - smallRadius;
        for (int ox = 0; ox < dx; ++ox) {
            int x = tl.getX() + ox;
            if (!ShapeCardItem.xInChunk(x, chunk)) continue;
            for (int oz = 0; oz < dz; ++oz) {
                int z = tl.getZ() + oz;
                if (!ShapeCardItem.zInChunk(z, chunk)) continue;
                for (int oy = 0; oy < dy; ++oy) {
                    int cnt;
                    int y = tl.getY() + oy;
                    if (y < 0 || y >= 255 || ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y, z, bigRadius, smallRadius) != 1) continue;
                    if (solid) {
                        cnt = 0;
                    } else {
                        cnt = ShapeCardItem.isInsideTorus(centerx, centery, centerz, x - 1, y, z, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x + 1, y, z, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y, z - 1, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y, z + 1, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y - 1, z, bigRadius, smallRadius);
                        cnt += ShapeCardItem.isInsideTorus(centerx, centery, centerz, x, y + 1, z, bigRadius, smallRadius);
                    }
                    if (cnt == 6) continue;
                    ShapeCardItem.placeBlockIfPossible(worldObj, blocks, maxSize, x, y, z, forquarry);
                }
            }
        }
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons[0] = iconRegister.func_94245_a("rftools:shapeCardItem");
        this.icons[1] = iconRegister.func_94245_a("rftools:shapeCardVoidItem");
        this.icons[2] = iconRegister.func_94245_a("rftools:shapeCardQuarryItem");
        this.icons[3] = iconRegister.func_94245_a("rftools:shapeCardSilkItem");
        this.icons[4] = iconRegister.func_94245_a("rftools:shapeCardFortuneItem");
        this.icons[5] = iconRegister.func_94245_a("rftools:shapeCardCQuarryItem");
        this.icons[6] = iconRegister.func_94245_a("rftools:shapeCardCSilkItem");
        this.icons[7] = iconRegister.func_94245_a("rftools:shapeCardCFortuneItem");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        int damage = stack.func_77960_j();
        return this.icons[damage];
    }

    public String func_77667_c(ItemStack itemStack) {
        if (itemStack.func_77960_j() == 0) {
            return super.func_77667_c(itemStack);
        }
        return super.func_77667_c(itemStack) + itemStack.func_77960_j();
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < this.icons.length; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    public static enum Shape {
        SHAPE_BOX(0, "Box"),
        SHAPE_TOPDOME(1, "Top Dome"),
        SHAPE_BOTTOMDOME(2, "Bottom Dome"),
        SHAPE_SPHERE(3, "Sphere"),
        SHAPE_CYLINDER(4, "Cylinder"),
        SHAPE_CAPPEDCYLINDER(5, "Capped Cylinder"),
        SHAPE_PRISM(6, "Prism"),
        SHAPE_TORUS(7, "Torus"),
        SHAPE_SOLIDBOX(100, "Solid Box"),
        SHAPE_SOLIDSPHERE(103, "Solid Sphere"),
        SHAPE_SOLIDCYLINDER(104, "Solid Cylinder"),
        SHAPE_SOLIDTORUS(107, "Solid Torus");

        private final int index;
        private final String description;
        private static Map<Integer, Shape> shapes;
        private static Map<String, Shape> shapesByDescription;

        public Shape makeHollow() {
            switch (this) {
                case SHAPE_SOLIDBOX: {
                    return SHAPE_BOX;
                }
                case SHAPE_SOLIDSPHERE: {
                    return SHAPE_SPHERE;
                }
                case SHAPE_SOLIDCYLINDER: {
                    return SHAPE_CAPPEDCYLINDER;
                }
                case SHAPE_SOLIDTORUS: {
                    return SHAPE_TORUS;
                }
            }
            return this;
        }

        private Shape(int index, String description) {
            this.index = index;
            this.description = description;
        }

        public int getIndex() {
            return this.index;
        }

        public String getDescription() {
            return this.description;
        }

        public static Shape getShape(int index) {
            return shapes.get(index);
        }

        public static Shape getShape(String description) {
            return shapesByDescription.get(description);
        }

        static {
            shapesByDescription = new HashMap<String, Shape>();
            shapes = new HashMap<Integer, Shape>();
            for (Shape shape : Shape.values()) {
                shapes.put(shape.getIndex(), shape);
                shapesByDescription.put(shape.getDescription(), shape);
            }
        }
    }
}

