/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.dimension.world.mapgen;

import java.util.Random;
import mcjty.lib.varia.BlockMeta;
import mcjty.rftools.dimension.world.GenericChunkProvider;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class MapGenLiquidOrbs {
    private final GenericChunkProvider provider;
    private final boolean large;
    private final int r;

    public MapGenLiquidOrbs(GenericChunkProvider provider, boolean large) {
        this.provider = provider;
        this.large = large;
        this.r = large ? 2 : 1;
    }

    public void generate(World world, int chunkX, int chunkZ, Block[] ablock, byte[] ameta) {
        BlockMeta[] blocks = this.large ? this.provider.dimensionInformation.getHugeLiquidSphereBlocks() : this.provider.dimensionInformation.getLiquidSphereBlocks();
        Block[] fluids = this.large ? this.provider.dimensionInformation.getHugeLiquidSphereFluids() : this.provider.dimensionInformation.getLiquidSphereFluids();
        for (int cx = -this.r; cx <= this.r; ++cx) {
            for (int cz = -this.r; cz <= this.r; ++cz) {
                Random random = new Random((world.func_72905_C() + (long)(chunkX + cx)) * 37L + (long)((chunkZ + cz) * 5) + 113L);
                random.nextFloat();
                if (!(random.nextFloat() < 0.05f)) continue;
                int x = cx * 16 + random.nextInt(16);
                int y = 40 + random.nextInt(40);
                int z = cz * 16 + random.nextInt(16);
                int radius = random.nextInt(this.large ? 20 : 6) + (this.large ? 10 : 4);
                BlockMeta block = BlockMeta.STONE;
                if (blocks.length > 1) {
                    block = blocks[random.nextInt(blocks.length)];
                } else if (blocks.length == 1) {
                    block = blocks[0];
                }
                Block fluid = Blocks.field_150355_j;
                if (fluids.length > 1) {
                    fluid = fluids[random.nextInt(fluids.length)];
                } else if (fluids.length == 1) {
                    fluid = fluids[0];
                }
                this.fillSphere(ablock, ameta, x, y, z, radius, block, fluid);
            }
        }
    }

    private void fillSphere(Block[] ablock, byte[] ameta, int centerx, int centery, int centerz, int radius, BlockMeta blockMeta, Block fluid) {
        Block block = blockMeta.getBlock();
        byte meta = blockMeta.getMeta();
        double sqradius = radius * radius;
        double liquidradius = ((double)radius - 1.5) * ((double)radius - 1.5);
        for (int x = 0; x < 16; ++x) {
            double dxdx = (x - centerx) * (x - centerx);
            for (int z = 0; z < 16; ++z) {
                double dzdz = (z - centerz) * (z - centerz);
                int index = (x * 16 + z) * 256;
                for (int y = centery - radius; y <= centery + radius; ++y) {
                    double dydy = (y - centery) * (y - centery);
                    double sqdist = dxdx + dydy + dzdz;
                    if (sqdist < liquidradius) {
                        ablock[index + y] = fluid;
                        ameta[index + y] = 0;
                        continue;
                    }
                    if (!(sqdist <= sqradius)) continue;
                    ablock[index + y] = block;
                    ameta[index + y] = meta;
                }
            }
        }
    }
}

