/*
 * Decompiled with CFR 0.152.
 */
package com.mia.ftbtrophies.common.entities;

import com.mia.craftstudio.minecraft.CraftStudioRendererVBO;
import com.mia.craftstudio.minecraft.DirectionHelper;
import com.mia.craftstudio.minecraft.INodeProvider;
import com.mia.ftbtrophies.common.TileTrophy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileVariableRendering
extends TileTrophy
implements INodeProvider {
    private Map<ForgeDirection, List<Pattern>> filtersFILLED_Pos = new HashMap<ForgeDirection, List<Pattern>>();
    private Map<ForgeDirection, List<Pattern>> filtersEMPTY_Pos = new HashMap<ForgeDirection, List<Pattern>>();
    private Map<ForgeDirection, List<Pattern>> filtersFILLED_Neg = new HashMap<ForgeDirection, List<Pattern>>();
    private Map<ForgeDirection, List<Pattern>> filtersEMPTY_Neg = new HashMap<ForgeDirection, List<Pattern>>();
    private Map<EnumSet<ForgeDirection>, List<Pattern>> filtersCorner_Pos = new HashMap<EnumSet<ForgeDirection>, List<Pattern>>();
    private Map<EnumSet<ForgeDirection>, List<Pattern>> filtersCorner_Neg = new HashMap<EnumSet<ForgeDirection>, List<Pattern>>();
    private Map<EnumSet<ForgeDirection>, List<Pattern>> filtersDouble_Pos = new HashMap<EnumSet<ForgeDirection>, List<Pattern>>();
    private Map<EnumSet<ForgeDirection>, List<Pattern>> filtersDouble_Neg = new HashMap<EnumSet<ForgeDirection>, List<Pattern>>();
    private String statusHash;
    private final int[] rotations = new int[]{2, 1, 0, 3};

    private Map<EnumSet<ForgeDirection>, TileTrophy> getSurroundingTrophies() {
        HashMap<EnumSet<ForgeDirection>, TileTrophy> outMap = new HashMap<EnumSet<ForgeDirection>, TileTrophy>();
        for (EnumSet fd : DirectionHelper.directions) {
            Integer[] offset = (Integer[])DirectionHelper.offsets.get(fd);
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + offset[0], this.field_145848_d + offset[1], this.field_145849_e + offset[2]);
            if (!this.sameID(te)) continue;
            outMap.put(fd, (TileTrophy)te);
        }
        return outMap;
    }

    public String getParam(String key) {
        return (String)this.getModelData().tileParams.get(key);
    }

    public String getStatusHash() {
        if (this.statusHash == null) {
            Map<EnumSet<ForgeDirection>, TileTrophy> trophies = this.getSurroundingTrophies();
            this.statusHash = String.format("%d:", this.rotation);
            for (EnumSet<ForgeDirection> dirs : trophies.keySet()) {
                this.statusHash = this.statusHash + dirs.toString() + ",";
            }
        }
        return this.statusHash;
    }

    private ForgeDirection correctOrientation(ForgeDirection fdi) {
        ForgeDirection fdo = fdi;
        for (int i = 0; i < this.rotations[this.rotation / 4]; ++i) {
            fdo = fdo.getRotation(ForgeDirection.DOWN);
        }
        return fdo;
    }

    private void markSurroundingDirty() {
        for (TileTrophy tile : this.getSurroundingTrophies().values()) {
            if (tile == null) continue;
            tile.markRenderDirty();
        }
    }

    @Override
    public void markRenderDirty() {
        this.statusHash = null;
        super.markRenderDirty();
    }

    @Override
    public void func_145843_s() {
        this.markSurroundingDirty();
        super.func_145843_s();
    }

    private <T> void parsePatterns(String rules, Map<T, List<Pattern>> pos, Map<T, List<Pattern>> neg, T index) {
        ArrayList<Pattern> patternsPos = new ArrayList<Pattern>();
        ArrayList<Pattern> patternsNeg = new ArrayList<Pattern>();
        for (String s : rules.split(";")) {
            String pattern = s.replace(".", "\\.").replace("*", "*.").replace("?", ".");
            if (!pattern.startsWith("!")) {
                patternsPos.add(Pattern.compile(pattern));
                continue;
            }
            patternsNeg.add(Pattern.compile(pattern.substring(1)));
        }
        pos.put(index, patternsPos);
        neg.put(index, patternsNeg);
    }

    @Override
    public void init() {
        if (!this.initialized) {
            String key;
            ForgeDirection fd2;
            ForgeDirection fd1;
            for (ForgeDirection fdo : DirectionHelper.flatDirections) {
                ForgeDirection fd = this.correctOrientation(fdo);
                this.filtersFILLED_Pos.put(fd, new ArrayList());
                this.filtersFILLED_Neg.put(fd, new ArrayList());
                this.filtersEMPTY_Pos.put(fd, new ArrayList());
                this.filtersEMPTY_Neg.put(fd, new ArrayList());
                String baseKey = "Nodes_" + fdo.toString();
                String keyFILLED = baseKey + "_FILLED";
                String keyEMPTY = baseKey + "_EMPTY";
                for (String k : this.getModelData().tileParams.keySet()) {
                    if (k.toLowerCase().equals(keyFILLED.toLowerCase())) {
                        this.parsePatterns((String)this.getModelData().tileParams.get(k), this.filtersFILLED_Pos, this.filtersFILLED_Neg, fd);
                    }
                    if (!k.toLowerCase().equals(keyEMPTY.toLowerCase())) continue;
                    this.parsePatterns((String)this.getModelData().tileParams.get(k), this.filtersEMPTY_Pos, this.filtersEMPTY_Neg, fd);
                }
            }
            for (ForgeDirection fd1o : DirectionHelper.flatDirections) {
                for (ForgeDirection fd2o : DirectionHelper.flatDirections) {
                    if (fd1o.equals((Object)fd2o)) continue;
                    fd1 = this.correctOrientation(fd1o);
                    fd2 = this.correctOrientation(fd2o);
                    this.filtersDouble_Pos.put(EnumSet.of(fd1, fd2), new ArrayList());
                    this.filtersDouble_Neg.put(EnumSet.of(fd1, fd2), new ArrayList());
                    key = "Nodes_" + fd1o.toString().charAt(0) + fd2o.toString().charAt(0) + "_DOUBLE";
                    for (String k : this.getModelData().tileParams.keySet()) {
                        if (!k.toLowerCase().equals(key.toLowerCase())) continue;
                        this.parsePatterns((String)this.getModelData().tileParams.get(k), this.filtersDouble_Pos, this.filtersDouble_Neg, EnumSet.of(fd1, fd2));
                    }
                }
            }
            for (ForgeDirection fd1o : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH}) {
                for (ForgeDirection fd2o : new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST}) {
                    fd1 = this.correctOrientation(fd1o);
                    fd2 = this.correctOrientation(fd2o);
                    this.filtersCorner_Pos.put(EnumSet.of(fd1, fd2), new ArrayList());
                    this.filtersCorner_Neg.put(EnumSet.of(fd1, fd2), new ArrayList());
                    key = "Nodes_" + fd1o.toString().charAt(0) + fd2o.toString().charAt(0) + "_CORNER";
                    for (String k : this.getModelData().tileParams.keySet()) {
                        if (!k.toLowerCase().equals(key.toLowerCase())) continue;
                        this.parsePatterns((String)this.getModelData().tileParams.get(k), this.filtersCorner_Pos, this.filtersCorner_Neg, EnumSet.of(fd1, fd2));
                    }
                }
            }
            this.markSurroundingDirty();
            this.initialized = true;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Set<CraftStudioRendererVBO> getNodes(Set<CraftStudioRendererVBO> inNodes) {
        HashSet<CraftStudioRendererVBO> outNodes = new HashSet<CraftStudioRendererVBO>();
        HashSet filtersPos = new HashSet();
        HashSet filtersNeg = new HashSet();
        Map<EnumSet<ForgeDirection>, TileTrophy> tiles = this.getSurroundingTrophies();
        for (ForgeDirection forgeDirection : DirectionHelper.flatDirections) {
            if (tiles.containsKey(EnumSet.of(forgeDirection))) {
                filtersPos.addAll(this.filtersFILLED_Pos.get(forgeDirection));
                filtersNeg.addAll(this.filtersFILLED_Neg.get(forgeDirection));
                continue;
            }
            filtersPos.addAll(this.filtersEMPTY_Pos.get(forgeDirection));
            filtersNeg.addAll(this.filtersEMPTY_Neg.get(forgeDirection));
        }
        for (ForgeDirection forgeDirection : DirectionHelper.flatDirections) {
            for (ForgeDirection fd2 : DirectionHelper.flatDirections) {
                if (forgeDirection.equals((Object)fd2) || !tiles.containsKey(EnumSet.of(forgeDirection)) || !tiles.containsKey(EnumSet.of(fd2))) continue;
                filtersPos.addAll(this.filtersDouble_Pos.get(EnumSet.of(forgeDirection, fd2)));
                filtersNeg.addAll(this.filtersDouble_Neg.get(EnumSet.of(forgeDirection, fd2)));
            }
        }
        for (ForgeDirection forgeDirection : new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH}) {
            for (ForgeDirection fd2 : new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST}) {
                if (!tiles.containsKey(EnumSet.of(forgeDirection)) || !tiles.containsKey(EnumSet.of(fd2)) || !tiles.containsKey(EnumSet.of(forgeDirection, fd2))) continue;
                filtersPos.addAll(this.filtersCorner_Pos.get(EnumSet.of(forgeDirection, fd2)));
                filtersNeg.addAll(this.filtersCorner_Neg.get(EnumSet.of(forgeDirection, fd2)));
            }
        }
        for (CraftStudioRendererVBO node : inNodes) {
            String name = node.getNode().getFullName();
            for (Pattern p : filtersPos) {
                if (!p.matcher(name).find()) continue;
                outNodes.add(node);
            }
        }
        for (CraftStudioRendererVBO craftStudioRendererVBO : outNodes.toArray(new CraftStudioRendererVBO[0])) {
            String name = craftStudioRendererVBO.getNode().getFullName();
            for (Pattern p : filtersNeg) {
                if (!p.matcher(name).find()) continue;
                outNodes.remove(craftStudioRendererVBO);
            }
        }
        return outNodes;
    }
}

