/*
 * Decompiled with CFR 0.152.
 */
package com.mia.ftbtrophies.common;

import com.mia.ftbtrophies.common.TileTrophy;
import com.mia.ftbtrophies.common.entities.TileParticleEmitter;
import com.mia.ftbtrophies.common.entities.TileVariableRendering;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;

public enum TileTypeMap {
    FTBTrophies(TileTrophy.class, new String[0]),
    ParticleEmitter(TileParticleEmitter.class, new String[0]),
    VariableRendering(TileVariableRendering.class, new String[0]);

    private Class<? extends TileTrophy> clazz;
    private String[] altnames;

    private TileTypeMap(Class<? extends TileTrophy> clazz, String ... altnames) {
        this.clazz = clazz;
        this.altnames = altnames;
    }

    public Class<? extends TileTrophy> getTileClass() {
        return this.clazz;
    }

    public static TileTypeMap getTileType(Class<? extends TileTrophy> clazz) {
        for (TileTypeMap type : TileTypeMap.values()) {
            if (type.clazz != clazz) continue;
            return type;
        }
        return FTBTrophies;
    }

    public static void register() {
        for (TileTypeMap type : TileTypeMap.values()) {
            ArrayList<String> altNames = new ArrayList<String>();
            altNames.add(type.clazz.getSimpleName());
            altNames.add(type.clazz.getCanonicalName().replace(".common.", "."));
            for (String s : type.altnames) {
                altNames.add("com.mia.ftbtrophies.common.entities." + s);
                altNames.add("com.mia.ftbtrophies.entities." + s);
            }
            GameRegistry.registerTileEntityWithAlternatives(type.clazz, (String)type.clazz.getCanonicalName(), (String[])altNames.toArray(new String[0]));
        }
    }
}

