/*
 * Decompiled with CFR 0.152.
 */
package com.mia.ftbtrophies;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mia.craftstudio.CSModel;
import com.mia.craftstudio.libgdx.Vector3;
import com.mia.craftstudio.minecraft.ModelMetadata;
import com.mia.ftbtrophies.common.TileTypeMap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class TrophyModelMetadata
extends ModelMetadata {
    public String name;
    public int trophyID;
    public int lightLevel = 0;
    public int invX = 0;
    public int invY = 0;
    public boolean walkthrough = false;
    public boolean limitRotation = false;
    public boolean hasVariableRendering = false;
    public TileTypeMap tileType = TileTypeMap.FTBTrophies;
    public String sound;
    public transient float itemScale = -1.0f;
    public transient Vector3 itemOffset;
    private static final HashMap<String, Field> fieldMap = new HashMap();

    public TrophyModelMetadata() {
        for (Field f : TrophyModelMetadata.class.getFields()) {
            fieldMap.put(f.getName(), f);
        }
    }

    public TrophyModelMetadata(TrophyModelMetadata existingMeta, int newID, JsonObject changes) {
        for (Field f : TrophyModelMetadata.class.getFields()) {
            fieldMap.put(f.getName(), f);
        }
        this.craftstudioAssetName = existingMeta.craftstudioAssetName;
        this.craftstudioAssetID = existingMeta.craftstudioAssetID;
        this.scale = existingMeta.scale;
        this.textureOverride = null;
        this.tileParams = new HashMap(existingMeta.tileParams);
        this.csmodel = existingMeta.csmodel;
        this.name = existingMeta.name;
        this.trophyID = newID;
        this.lightLevel = existingMeta.lightLevel;
        this.invX = existingMeta.invX;
        this.invY = existingMeta.invY;
        this.walkthrough = existingMeta.walkthrough;
        this.limitRotation = existingMeta.limitRotation;
        this.hasVariableRendering = existingMeta.hasVariableRendering;
        this.tileType = existingMeta.tileType;
        this.sound = existingMeta.sound;
        this.itemScale = existingMeta.itemScale;
        Vector3 vector3 = this.itemOffset = existingMeta.itemOffset != null ? new Vector3(existingMeta.itemOffset) : null;
        if (changes != null) {
            Gson gson = new GsonBuilder().create();
            for (Map.Entry entry : changes.entrySet()) {
                Field foundField = fieldMap.get(((String)entry.getKey()).intern());
                if (foundField == null) continue;
                try {
                    foundField.set((Object)this, gson.fromJson((JsonElement)entry.getValue(), foundField.getGenericType()));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
    }

    public void wrapperCallback() {
        super.wrapperCallback();
        int[] extendBlock = this.wrapper.getExtendBlock(0);
        int width = 1 + extendBlock[3] - extendBlock[0];
        int depth = 1 + extendBlock[5] - extendBlock[2];
        int height = extendBlock[4] - extendBlock[1];
        if (height == 0) {
            ++height;
        }
        Vector3[] extend = this.wrapper.getExtend(8);
        this.itemScale = Math.min(1.0f / Math.abs(extend[1].y - extend[0].y), Math.min(1.0f / Math.abs(extend[1].x - extend[0].x), 1.0f / Math.abs(extend[1].z - extend[0].z)));
        this.itemOffset = new Vector3(-((extend[0].x + extend[1].x) / 2.0f), -((extend[0].y + extend[1].y) / 35.0f + (extend[0].y < 0.0f ? extend[0].y / 2.0f : 0.0f) + (extend[0].y > 0.0f ? extend[0].y : 0.0f) + (extend[1].y > 0.5f ? extend[1].y / 35.0f : 0.0f) + 0.84f), -((extend[0].z + extend[1].z) / 2.2f));
    }

    public void validate() {
        if (this.textureOverride == null) {
            this.textureOverride = this.getDefaultTextureName();
        }
        if (this.csmodel.getRootNode() != null && this.csmodel.getRootNode().hasAttribute(CSModel.ModelNode.Attrb.PASSABLEPROPAGATES)) {
            this.walkthrough = true;
        }
    }

    public String getDefaultTextureName() {
        return String.format("%04d_%s.png", this.trophyID, this.name.toLowerCase().replaceAll("[/\\\\:*?\"<>|' ]", "_"));
    }

    public int compareTo(ModelMetadata o) {
        if (o instanceof TrophyModelMetadata) {
            if (this.trophyID < ((TrophyModelMetadata)o).trophyID) {
                return -1;
            }
            if (this.trophyID > ((TrophyModelMetadata)o).trophyID) {
                return 1;
            }
            return 0;
        }
        return super.compareTo(o);
    }
}

