/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter.inbound;

import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import openmods.reflection.TypeUtils;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;
import openperipheral.converter.TypeConverter;

public class ConverterMapInbound
implements IGenericInboundTypeConverter {
    @Override
    public Object toJava(IConverter registry, Object obj, Type expected) {
        TypeToken type;
        if (obj instanceof Map && (type = TypeToken.of((Type)expected)).getRawType() == Map.class) {
            Type keyType = type.resolveType((Type)TypeUtils.MAP_KEY_PARAM).getType();
            Type valueType = type.resolveType((Type)TypeUtils.MAP_VALUE_PARAM).getType();
            HashMap result = Maps.newHashMap();
            for (Map.Entry e : ((Map)obj).entrySet()) {
                Object key = TypeConverter.nullableToJava(registry, e.getKey(), keyType);
                Object value = TypeConverter.nullableToJava(registry, e.getValue(), valueType);
                result.put(key, value);
            }
            return result;
        }
        return null;
    }
}

